/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InfiniteLoopStatementInspection
extends BaseInspection {
    public boolean myIgnoreInThreadTopLevel = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myIgnoreInThreadTopLevel", (String)JavaAnalysisBundle.message((String)"inspection.infinite.loop.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            InfiniteLoopStatementInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("infinite.loop.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            InfiniteLoopStatementInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new InfiniteLoopStatementsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/InfiniteLoopStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class InfiniteLoopStatementsVisitor
    extends BaseInspectionVisitor {
        private InfiniteLoopStatementsVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                InfiniteLoopStatementsVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement);
            this.checkStatement((PsiStatement)statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                InfiniteLoopStatementsVisitor.$$$reportNull$$$0(1);
            }
            super.visitWhileStatement(statement);
            this.checkStatement((PsiStatement)statement);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                InfiniteLoopStatementsVisitor.$$$reportNull$$$0(2);
            }
            super.visitDoWhileStatement(statement);
            this.checkStatement((PsiStatement)statement);
        }

        private void checkStatement(PsiStatement statement) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) {
                return;
            }
            if (ControlFlowUtils.containsReturn((PsiElement)statement)) {
                return;
            }
            if (ControlFlowUtils.containsSystemExit((PsiElement)statement)) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)statement, PsiSwitchExpression.class) != null && ControlFlowUtils.containsYield((PsiElement)statement)) {
                return;
            }
            if (InfiniteLoopStatementInspection.this.myIgnoreInThreadTopLevel) {
                PsiLambdaExpression lambda;
                PsiElement parent = PsiTreeUtil.findFirstParent((PsiElement)statement, element -> element instanceof PsiMethod || element instanceof PsiLambdaExpression || element instanceof PsiAnonymousClass);
                if (parent instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)parent;
                    if (method.hasModifierProperty("private")) {
                        PsiClass aClass = method.getContainingClass();
                        boolean allUsagesAreInThreadStart = ((StreamEx)StreamEx.ofTree((Object)aClass, element -> StreamEx.of((Object[])element.getChildren())).filter(element -> {
                            if (element instanceof PsiMethodCallExpression) {
                                PsiMethodCallExpression call = (PsiMethodCallExpression)element;
                                return call.getMethodExpression().isReferenceTo((PsiElement)method);
                            }
                            if (element instanceof PsiMethodReferenceExpression) {
                                PsiMethodReferenceExpression methodReference = (PsiMethodReferenceExpression)element;
                                return methodReference.isReferenceTo((PsiElement)method);
                            }
                            return false;
                        })).select(PsiExpression.class).allMatch(inArgument -> {
                            if (inArgument instanceof PsiMethodCallExpression) {
                                return InfiniteLoopStatementsVisitor.isArgumentInThreadConstructor(inArgument);
                            }
                            if (inArgument instanceof PsiMethodReferenceExpression) {
                                return InfiniteLoopStatementsVisitor.isInThreadConstructor(inArgument);
                            }
                            return false;
                        });
                        if (allUsagesAreInThreadStart) {
                            return;
                        }
                    } else {
                        PsiClass psiClass = method.getContainingClass();
                        if (psiClass instanceof PsiAnonymousClass) {
                            PsiAnonymousClass anonymous = (PsiAnonymousClass)psiClass;
                            if ("run".equals(method.getName()) && method.getParameterList().isEmpty() && InfiniteLoopStatementsVisitor.isInThreadConstructor((PsiExpression)anonymous.getParent())) {
                                return;
                            }
                        }
                    }
                } else if (parent instanceof PsiLambdaExpression && InfiniteLoopStatementsVisitor.isInThreadConstructor((PsiExpression)(lambda = (PsiLambdaExpression)parent))) {
                    return;
                }
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private static boolean isArgumentInThreadConstructor(@Nullable PsiExpression inArgument) {
            PsiLambdaExpression lambda;
            PsiElement psiElement;
            PsiElement skipped = PsiUtil.skipParenthesizedExprUp((PsiElement)inArgument);
            return skipped != null && (psiElement = skipped.getParent()) instanceof PsiLambdaExpression && InfiniteLoopStatementsVisitor.isInThreadConstructor((PsiExpression)(lambda = (PsiLambdaExpression)psiElement));
        }

        private static boolean isInThreadConstructor(@NotNull PsiExpression argument) {
            PsiElement argumentParent;
            PsiElement psiElement;
            if (argument == null) {
                InfiniteLoopStatementsVisitor.$$$reportNull$$$0(3);
            }
            if (!((psiElement = (argumentParent = PsiUtil.skipParenthesizedExprUp((PsiElement)argument.getParent())).getParent()) instanceof PsiConstructorCall)) {
                return false;
            }
            PsiConstructorCall constructorCall = (PsiConstructorCall)psiElement;
            PsiMethod constructor = constructorCall.resolveConstructor();
            if (constructor == null) {
                return false;
            }
            PsiClass aClass = constructor.getContainingClass();
            return aClass != null && "java.lang.Thread".equals(aClass.getQualifiedName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/InfiniteLoopStatementInspection$InfiniteLoopStatementsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInThreadConstructor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

