/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public final class NegatedEqualityExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("negated.equality.expression.problem.descriptor", infos[0]);
        if (string == null) {
            NegatedEqualityExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new NegatedEqualityExpressionFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedEqualsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedEqualityExpressionInspection", "buildErrorString"));
    }

    private static class NegatedEqualityExpressionFix
    extends PsiUpdateModCommandQuickFix {
        private NegatedEqualityExpressionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("negated.equality.expression.quickfix", new Object[0]);
            if (string == null) {
                NegatedEqualityExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                NegatedEqualityExpressionFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                NegatedEqualityExpressionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                NegatedEqualityExpressionFix.$$$reportNull$$$0(3);
            }
            if (!((parent = element.getParent()) instanceof PsiPrefixExpression)) {
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
            if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationTokenType())) {
                return;
            }
            PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)prefixExpression.getOperand());
            if (!(operand instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            CommentTracker commentTracker = new CommentTracker();
            StringBuilder text = new StringBuilder(commentTracker.text((PsiElement)binaryExpression.getLOperand()));
            if (JavaTokenType.EQEQ.equals(tokenType)) {
                text.append("!=");
            } else if (JavaTokenType.NE.equals(tokenType)) {
                text.append("==");
            } else {
                return;
            }
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs != null) {
                text.append(commentTracker.text((PsiElement)rhs));
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, text.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/NegatedEqualityExpressionInspection$NegatedEqualityExpressionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/NegatedEqualityExpressionInspection$NegatedEqualityExpressionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class NegatedEqualsVisitor
    extends BaseInspectionVisitor {
        private NegatedEqualsVisitor() {
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                NegatedEqualsVisitor.$$$reportNull$$$0(0);
            }
            super.visitPrefixExpression(expression);
            if (!JavaTokenType.EXCL.equals(expression.getOperationTokenType())) {
                return;
            }
            PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getOperand());
            if (!(operand instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (JavaTokenType.EQEQ.equals(tokenType)) {
                this.registerError((PsiElement)expression.getOperationSign(), "==");
            } else if (JavaTokenType.NE.equals(tokenType)) {
                this.registerError((PsiElement)expression.getOperationSign(), "!=");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/NegatedEqualityExpressionInspection$NegatedEqualsVisitor", "visitPrefixExpression"));
        }
    }
}

