/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.RemoveRedundantPolyadicOperandFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PointlessNullCheckInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMethodCallExpression parent = Objects.requireNonNull((PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)infos[1]), PsiMethodCallExpression.class));
        String string = InspectionGadgetsBundle.message("pointless.nullcheck.problem.descriptor.call", parent.getMethodExpression().getReferenceName());
        if (string == null) {
            PointlessNullCheckInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessNullCheckVisitor();
    }

    @Override
    @NotNull
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        return new RemoveRedundantPolyadicOperandFix(expression.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessNullCheckInspection", "buildErrorString"));
    }

    private static class PointlessNullCheckVisitor
    extends BaseInspectionVisitor {
        private PointlessNullCheckVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                PointlessNullCheckVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            IElementType operationTokenType = expression.getOperationTokenType();
            if (operationTokenType.equals(JavaTokenType.ANDAND)) {
                this.checkAndChain(expression);
            } else if (operationTokenType.equals(JavaTokenType.OROR)) {
                this.checkOrChain(expression);
            }
        }

        private void checkOrChain(PsiPolyadicExpression expression) {
            PsiExpression[] operands = expression.getOperands();
            for (int i = 0; i < operands.length - 1; ++i) {
                PsiBinaryExpression binaryExpression;
                IElementType tokenType;
                PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands[i]);
                if (!(psiExpression instanceof PsiBinaryExpression) || !(tokenType = (binaryExpression = (PsiBinaryExpression)psiExpression).getOperationTokenType()).equals(JavaTokenType.EQEQ)) continue;
                for (int j = i + 1; j < operands.length; ++j) {
                    PsiExpression implicitCheckCandidate = BoolUtils.getNegated(PsiUtil.skipParenthesizedExprDown((PsiExpression)operands[j]));
                    if (!this.checkExpressions(operands, i, j, binaryExpression, implicitCheckCandidate)) continue;
                    return;
                }
            }
        }

        private void checkAndChain(PsiPolyadicExpression expression) {
            PsiExpression[] operands = expression.getOperands();
            for (int i = 0; i < operands.length - 1; ++i) {
                PsiBinaryExpression binaryExpression;
                IElementType tokenType;
                PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands[i]);
                if (!(psiExpression instanceof PsiBinaryExpression) || !(tokenType = (binaryExpression = (PsiBinaryExpression)psiExpression).getOperationTokenType()).equals(JavaTokenType.NE)) continue;
                for (int j = i + 1; j < operands.length; ++j) {
                    PsiExpression implicitCheckCandidate = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands[j]);
                    if (!this.checkExpressions(operands, i, j, binaryExpression, implicitCheckCandidate)) continue;
                    return;
                }
            }
        }

        private boolean checkExpressions(PsiExpression[] operands, int i, int j, PsiBinaryExpression binaryExpression, PsiExpression implicitCheckCandidate) {
            PsiElement psiElement;
            PsiReferenceExpression explicitCheckReference = PointlessNullCheckVisitor.getReferenceFromNullCheck(binaryExpression);
            if (explicitCheckReference == null || !((psiElement = explicitCheckReference.resolve()) instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)psiElement;
            PsiReferenceExpression implicitCheckReference = this.getReferenceFromImplicitNullCheckExpression(implicitCheckCandidate);
            if (implicitCheckReference == null || !implicitCheckReference.isReferenceTo((PsiElement)variable)) {
                return false;
            }
            if (PointlessNullCheckVisitor.isVariableUsed(operands, i, j, variable)) {
                return false;
            }
            this.registerError((PsiElement)binaryExpression, binaryExpression, implicitCheckReference);
            return true;
        }

        private static boolean isVariableUsed(PsiExpression[] operands, int i, int j, PsiVariable variable) {
            return Arrays.stream(operands, i + 1, j).anyMatch(op -> VariableAccessUtils.variableIsUsed(variable, (PsiElement)op));
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromNullCheck(PsiBinaryExpression expression) {
            PsiReferenceExpression ref;
            PsiExpression comparedWithNull = ExpressionUtils.getValueComparedWithNull(expression);
            PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)comparedWithNull);
            return psiExpression instanceof PsiReferenceExpression ? (ref = (PsiReferenceExpression)psiExpression) : null;
        }

        @Nullable
        private PsiReferenceExpression getReferenceFromImplicitNullCheckExpression(PsiExpression expression) {
            PsiReferenceExpression checked = PointlessNullCheckVisitor.getReferenceFromBooleanCall(expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression));
            return checked == null ? this.getReferenceFromOrChain(expression) : checked;
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromBooleanCall(PsiExpression expression) {
            MethodContract methodContract;
            List<? extends MethodContract> contracts;
            if (!(expression instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (!PsiTypes.booleanType().equals((Object)call.getType())) {
                return null;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier != null && SideEffectChecker.mayHaveSideEffects(qualifier)) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return null;
            }
            if (MethodUtils.isEquals(method)) {
                StandardMethodContract.ValueConstraint[] nullArg = new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.NULL_VALUE};
                contracts = Collections.singletonList(new StandardMethodContract(nullArg, ContractReturnValue.returnFalse()));
            } else {
                contracts = JavaMethodContractUtil.getMethodCallContracts(method, (PsiCallExpression)call);
            }
            if (contracts.isEmpty() || !((methodContract = contracts.get(0)) instanceof StandardMethodContract)) {
                return null;
            }
            StandardMethodContract contract = (StandardMethodContract)methodContract;
            if (!contract.getReturnValue().equals(ContractReturnValue.returnFalse())) {
                return null;
            }
            ContractValue condition = (ContractValue)ContainerUtil.getOnlyItem(contract.getConditions());
            if (condition == null) {
                return null;
            }
            int idx = condition.getNullCheckedArgument(true).orElse(-1);
            if (idx == -1) {
                return null;
            }
            Object[] args = call.getArgumentList().getExpressions();
            if (args.length <= idx || method.isVarArgs() && idx == args.length - 1) {
                return null;
            }
            PsiExpression psiExpression = args[idx];
            if (!(psiExpression instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)psiExpression;
            PsiElement psiElement = reference.resolve();
            if (!(psiElement instanceof PsiVariable)) {
                return null;
            }
            PsiVariable target = (PsiVariable)psiElement;
            if (!SyntaxTraverser.psiTraverser((PsiElement)call).filter(PsiReference.class).filter(ref -> !reference.equals(ref) && ref.isReferenceTo((PsiElement)target)).isEmpty()) {
                return null;
            }
            if (ContainerUtil.or((Object[])args, SideEffectChecker::mayHaveSideEffects)) {
                return null;
            }
            return reference;
        }

        @Nullable
        private PsiReferenceExpression getReferenceFromOrChain(PsiExpression expression) {
            PsiElement psiElement;
            if (!(expression instanceof PsiPolyadicExpression)) {
                return null;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.OROR != tokenType) {
                return null;
            }
            PsiExpression[] operands = polyadicExpression.getOperands();
            PsiReferenceExpression referenceExpression = this.getReferenceFromImplicitNullCheckExpression(operands[0]);
            if (referenceExpression == null || !((psiElement = referenceExpression.resolve()) instanceof PsiVariable)) {
                return null;
            }
            PsiVariable variable = (PsiVariable)psiElement;
            int operandsLength = operands.length;
            for (int i = 1; i < operandsLength; ++i) {
                PsiReferenceExpression reference2 = this.getReferenceFromImplicitNullCheckExpression(operands[i]);
                if (reference2 != null && reference2.isReferenceTo((PsiElement)variable)) continue;
                return null;
            }
            return referenceExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/PointlessNullCheckInspection$PointlessNullCheckVisitor", "visitPolyadicExpression"));
        }
    }
}

