/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimplifiableBooleanExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object info = infos[0];
        if (info instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)info;
            String string = InspectionGadgetsBundle.message("boolean.expression.can.be.simplified.problem.descriptor", SimplifiableBooleanExpressionInspection.calculateReplacementExpression(prefixExpression, new CommentTracker()));
            if (string == null) {
                SimplifiableBooleanExpressionInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)info;
        String string = InspectionGadgetsBundle.message("boolean.expression.can.be.simplified.problem.descriptor", SimplifiableBooleanExpressionInspection.calculateReplacementExpression(binaryExpression, new CommentTracker()));
        if (string == null) {
            SimplifiableBooleanExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new SimplifiableBooleanExpressionFix();
    }

    @NonNls
    static String calculateReplacementExpression(PsiPrefixExpression expression, CommentTracker commentTracker) {
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getOperand());
        if (!(operand instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand;
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getLOperand());
        PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getROperand());
        if (lhs == null || rhs == null) {
            return null;
        }
        return ParenthesesUtils.getText(commentTracker.markUnchanged(lhs), 9) + "==" + ParenthesesUtils.getText(commentTracker.markUnchanged(rhs), 9);
    }

    @NonNls
    static String calculateReplacementExpression(PsiBinaryExpression expression, CommentTracker commentTracker) {
        Object conjunctionRemnant;
        boolean isFirst;
        PsiPolyadicExpression conjunction = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLOperand()), PsiPolyadicExpression.class);
        if (conjunction == null) {
            return null;
        }
        PsiExpression rightDisjunct = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getROperand());
        if (rightDisjunct == null) {
            return null;
        }
        if (SimplifiableBooleanExpressionInspection.hasOperand(conjunction, rightDisjunct)) {
            return commentTracker.text((PsiElement)rightDisjunct);
        }
        PsiExpression[] operands = conjunction.getOperands();
        if (operands.length < 2) {
            return null;
        }
        if (BoolUtils.areExpressionsOpposite(operands[0], rightDisjunct)) {
            isFirst = true;
        } else if (BoolUtils.areExpressionsOpposite(operands[operands.length - 1], rightDisjunct)) {
            isFirst = false;
        } else {
            return null;
        }
        if (operands.length == 2) {
            conjunctionRemnant = commentTracker.text(operands[isFirst ? 1 : 0], 14);
        } else {
            conjunctionRemnant = isFirst ? commentTracker.rangeText((PsiElement)operands[1], (PsiElement)operands[operands.length - 1]) : commentTracker.rangeText((PsiElement)operands[0], (PsiElement)operands[operands.length - 2]);
            if (expression.getLOperand() instanceof PsiParenthesizedExpression) {
                conjunctionRemnant = "(" + (String)conjunctionRemnant + ")";
            }
        }
        return isFirst ? commentTracker.text(rightDisjunct, 14) + "||" + (String)conjunctionRemnant : (String)conjunctionRemnant + "||" + commentTracker.text(rightDisjunct, 14);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableBooleanExpressionVisitor();
    }

    private static boolean hasOperand(PsiPolyadicExpression polyadic, PsiExpression operand) {
        if (operand == null) {
            return false;
        }
        EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
        return Arrays.stream(polyadic.getOperands()).anyMatch(op -> equivalence.expressionsAreEquivalent((PsiExpression)op, operand));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableBooleanExpressionInspection", "buildErrorString"));
    }

    private static class SimplifiableBooleanExpressionFix
    extends PsiUpdateModCommandQuickFix {
        private SimplifiableBooleanExpressionFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                SimplifiableBooleanExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            String replacement;
            if (project == null) {
                SimplifiableBooleanExpressionFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                SimplifiableBooleanExpressionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                SimplifiableBooleanExpressionFix.$$$reportNull$$$0(3);
            }
            CommentTracker commentTracker = new CommentTracker();
            if (element instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
                replacement = SimplifiableBooleanExpressionInspection.calculateReplacementExpression(prefixExpression, commentTracker);
            } else if (element instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
                replacement = SimplifiableBooleanExpressionInspection.calculateReplacementExpression(binaryExpression, commentTracker);
            } else {
                return;
            }
            if (replacement == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)element, replacement, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/SimplifiableBooleanExpressionInspection$SimplifiableBooleanExpressionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/SimplifiableBooleanExpressionInspection$SimplifiableBooleanExpressionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class SimplifiableBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableBooleanExpressionVisitor() {
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                SimplifiableBooleanExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitPrefixExpression(expression);
            if (!JavaTokenType.EXCL.equals(expression.getOperationTokenType())) {
                return;
            }
            PsiBinaryExpression maybeXor = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getOperand()), PsiBinaryExpression.class);
            if (maybeXor == null || !JavaTokenType.XOR.equals(maybeXor.getOperationTokenType())) {
                return;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)maybeXor.getLOperand());
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)maybeXor.getROperand());
            if (lhs == null || rhs == null) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression disjunction) {
            PsiExpression[] operands;
            if (disjunction == null) {
                SimplifiableBooleanExpressionVisitor.$$$reportNull$$$0(1);
            }
            super.visitBinaryExpression(disjunction);
            if (!JavaTokenType.OROR.equals(disjunction.getOperationTokenType())) {
                return;
            }
            PsiPolyadicExpression conjunction = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)disjunction.getLOperand()), PsiPolyadicExpression.class);
            if (conjunction == null || !JavaTokenType.ANDAND.equals(conjunction.getOperationTokenType())) {
                return;
            }
            PsiExpression rightDisjunct = PsiUtil.skipParenthesizedExprDown((PsiExpression)disjunction.getROperand());
            if (SimplifiableBooleanExpressionInspection.hasOperand(conjunction, rightDisjunct) && !SideEffectChecker.mayHaveSideEffects((PsiExpression)conjunction)) {
                this.registerError((PsiElement)disjunction, disjunction);
            }
            if ((operands = conjunction.getOperands()).length >= 2 && (BoolUtils.areExpressionsOpposite(operands[0], rightDisjunct) || BoolUtils.areExpressionsOpposite(operands[operands.length - 1], rightDisjunct)) && !SideEffectChecker.mayHaveSideEffects(rightDisjunct)) {
                this.registerError((PsiElement)disjunction, disjunction);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disjunction";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/SimplifiableBooleanExpressionInspection$SimplifiableBooleanExpressionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrefixExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBinaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

