/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.style.ConditionalExpressionGenerator;
import com.siyeh.ig.style.ConditionalModel;
import org.jetbrains.annotations.NotNull;

public final class SimplifiableConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacement = (String)infos[0];
        String orig = (String)infos[1];
        String string = InspectionGadgetsBundle.message("simplifiable.conditional.expression.problem.descriptor", replacement, orig);
        if (string == null) {
            SimplifiableConditionalExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new SimplifiableConditionalFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableConditionalExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection", "buildErrorString"));
    }

    private static class SimplifiableConditionalFix
    extends PsiUpdateModCommandQuickFix {
        private SimplifiableConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                SimplifiableConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiConditionalExpression expression;
            if (project == null) {
                SimplifiableConditionalFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                SimplifiableConditionalFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                SimplifiableConditionalFix.$$$reportNull$$$0(3);
            }
            if ((expression = (PsiConditionalExpression)ObjectUtils.tryCast((Object)startElement.getParent(), PsiConditionalExpression.class)) == null) {
                return;
            }
            ConditionalModel model = ConditionalModel.from(expression);
            if (model == null) {
                return;
            }
            ConditionalExpressionGenerator generator = ConditionalExpressionGenerator.from(model);
            if (generator == null || generator.getTokenType().equals("?:")) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            String newExpression = generator.generate(tracker);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression, tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection$SimplifiableConditionalFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection$SimplifiableConditionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class SimplifiableConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            PsiElement parent;
            if (expression == null) {
                SimplifiableConditionalExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(expression);
            ConditionalModel model = ConditionalModel.from(expression);
            if (model == null) {
                return;
            }
            ConditionalExpressionGenerator generator = ConditionalExpressionGenerator.from(model);
            if (generator == null || generator.getTokenType().equals("?:")) {
                return;
            }
            if (PsiTypes.booleanType().equals((Object)model.getType()) && ExpressionUtils.nonStructuralChildren((PsiExpression)expression).anyMatch(ExpressionUtils::isNullLiteral)) {
                return;
            }
            PsiExpression replacement = generator.getReplacement();
            if (replacement != null && (parent = expression.getParent()) instanceof PsiLambdaExpression && !LambdaUtil.isSafeLambdaBodyReplacement((PsiLambdaExpression)((PsiLambdaExpression)parent), () -> replacement)) {
                return;
            }
            this.registerError((PsiElement)expression.getCondition(), generator.generate(new CommentTracker()), expression.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection$SimplifiableConditionalExpressionVisitor", "visitConditionalExpression"));
        }
    }
}

