/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.codeserver.core.JavaPsiSwitchUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SwitchUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SwitchExpressionCanBePushedDownInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.SWITCH_EXPRESSION);
        if (set == null) {
            SwitchExpressionCanBePushedDownInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SwitchExpressionCanBePushedDownInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.processBlock((PsiSwitchBlock)expression);
            }

            public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.processBlock((PsiSwitchBlock)statement);
            }

            private void processBlock(PsiSwitchBlock block) {
                List<PsiExpression> branches = SwitchExpressionCanBePushedDownInspection.extractBranches(block);
                if (branches == null) {
                    return;
                }
                PsiExpression[] diffs = SwitchExpressionCanBePushedDownInspection.findDiffs(block, branches);
                if (diffs.length != 0) {
                    holder.registerProblem(block.getFirstChild(), InspectionGadgetsBundle.message("inspection.common.subexpression.in.switch.display.name", new Object[0]), new LocalQuickFix[]{new PushDownSwitchExpressionFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/controlflow/SwitchExpressionCanBePushedDownInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSwitchExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSwitchStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static @NotNull PsiExpression @NotNull [] findDiffs(@NotNull PsiSwitchBlock block, @NotNull List<PsiExpression> branches) {
        PsiSwitchStatement statement;
        if (block == null) {
            SwitchExpressionCanBePushedDownInspection.$$$reportNull$$$0(2);
        }
        if (branches == null) {
            SwitchExpressionCanBePushedDownInspection.$$$reportNull$$$0(3);
        }
        EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
        Object[] diffs = new PsiExpression[branches.size()];
        for (int i = 1; i < branches.size(); ++i) {
            PsiExpression cur;
            PsiExpression first;
            block20: {
                block19: {
                    EquivalenceChecker.Match match = equivalence.expressionsMatch(branches.get(0), branches.get(i));
                    if (match.isExactMismatch()) {
                        if (PsiExpression.EMPTY_ARRAY == null) {
                            SwitchExpressionCanBePushedDownInspection.$$$reportNull$$$0(4);
                        }
                        return PsiExpression.EMPTY_ARRAY;
                    }
                    if (match.isExactMatch()) {
                        diffs[i] = diffs[0];
                        continue;
                    }
                    PsiElement psiElement = match.getLeftDiff();
                    if (!(psiElement instanceof PsiExpression)) break block19;
                    first = (PsiExpression)psiElement;
                    psiElement = match.getRightDiff();
                    if (!(psiElement instanceof PsiExpression)) break block19;
                    cur = (PsiExpression)psiElement;
                    if (diffs[0] == null || diffs[0] == first) break block20;
                }
                if (PsiExpression.EMPTY_ARRAY == null) {
                    SwitchExpressionCanBePushedDownInspection.$$$reportNull$$$0(5);
                }
                return PsiExpression.EMPTY_ARRAY;
            }
            if (PsiTypes.voidType().equals((Object)first.getType()) || PsiTypes.voidType().equals((Object)cur.getType())) {
                if (PsiExpression.EMPTY_ARRAY == null) {
                    SwitchExpressionCanBePushedDownInspection.$$$reportNull$$$0(6);
                }
                return PsiExpression.EMPTY_ARRAY;
            }
            if (diffs[0] == null) {
                for (int j = 0; j < i; ++j) {
                    if (diffs[j] != null) continue;
                    diffs[j] = first;
                }
            }
            diffs[i] = cur;
        }
        if (ArrayUtil.contains(null, (Object[])diffs)) {
            if (PsiExpression.EMPTY_ARRAY == null) {
                SwitchExpressionCanBePushedDownInspection.$$$reportNull$$$0(7);
            }
            return PsiExpression.EMPTY_ARRAY;
        }
        if (block instanceof PsiSwitchStatement && SwitchExpressionCanBePushedDownInspection.isNonExhaustiveSwitchStatement(statement = (PsiSwitchStatement)block)) {
            if (PsiExpression.EMPTY_ARRAY == null) {
                SwitchExpressionCanBePushedDownInspection.$$$reportNull$$$0(8);
            }
            return PsiExpression.EMPTY_ARRAY;
        }
        if (diffs == null) {
            SwitchExpressionCanBePushedDownInspection.$$$reportNull$$$0(9);
        }
        return diffs;
    }

    private static boolean isNonExhaustiveSwitchStatement(PsiSwitchStatement statement) {
        PsiExpression selector = statement.getExpression();
        if (selector == null) {
            return false;
        }
        PsiClass selectorClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)selector.getType());
        if (selectorClass == null || !selectorClass.isEnum()) {
            return JavaPsiSwitchUtil.findDefaultElement((PsiSwitchBlock)statement) == null;
        }
        Set missingConstants = StreamEx.of((Object[])selectorClass.getFields()).select(PsiEnumConstant.class).toMutableSet();
        for (PsiSwitchLabelStatementBase child : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)statement.getBody(), PsiSwitchLabelStatementBase.class)) {
            if (JavaPsiSwitchUtil.findDefaultElement((PsiSwitchLabelStatementBase)child) != null) {
                return false;
            }
            for (PsiEnumConstant constant : SwitchUtils.findEnumConstants(child)) {
                missingConstants.remove(constant);
                if (!missingConstants.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static List<PsiExpression> extractBranches(PsiSwitchBlock block) {
        PsiCodeBlock body = block.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length < 2) {
            return null;
        }
        ArrayList<PsiExpression> result = new ArrayList<PsiExpression>();
        for (PsiStatement statement : statements) {
            if (!(statement instanceof PsiSwitchLabeledRuleStatement)) {
                return null;
            }
            PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)statement;
            PsiStatement ruleBody = rule.getBody();
            if (ruleBody instanceof PsiThrowStatement) continue;
            if (ruleBody instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)ruleBody;
                if (!(block instanceof PsiSwitchExpression)) {
                    return null;
                }
                if (ControlFlowUtils.codeBlockMayCompleteNormally(blockStatement.getCodeBlock())) {
                    return null;
                }
                Collection yields = PsiTreeUtil.findChildrenOfType((PsiElement)blockStatement, PsiYieldStatement.class);
                List myYields = ContainerUtil.filter((Collection)yields, st -> st.findEnclosingExpression() == block);
                for (PsiYieldStatement yield : myYields) {
                    PsiExpression expression = yield.getExpression();
                    if (expression == null) {
                        return null;
                    }
                    result.add(expression);
                }
                continue;
            }
            if (ruleBody instanceof PsiExpressionStatement) {
                PsiExpressionStatement expr = (PsiExpressionStatement)ruleBody;
                result.add(expr.getExpression());
                continue;
            }
            return null;
        }
        if (result.size() < 2) {
            return null;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/SwitchExpressionCanBePushedDownInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/SwitchExpressionCanBePushedDownInspection";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findDiffs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDiffs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class PushDownSwitchExpressionFix
    extends PsiUpdateModCommandQuickFix {
        private PushDownSwitchExpressionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.common.subexpression.in.switch.fix.family.name", new Object[0]);
            if (string == null) {
                PushDownSwitchExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiSwitchBlock block;
            if (project == null) {
                PushDownSwitchExpressionFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PushDownSwitchExpressionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PushDownSwitchExpressionFix.$$$reportNull$$$0(3);
            }
            if ((block = (PsiSwitchBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiSwitchBlock.class)) == null) {
                return;
            }
            List<PsiExpression> branches = SwitchExpressionCanBePushedDownInspection.extractBranches(block);
            if (branches == null) {
                return;
            }
            PsiExpression[] diffs = SwitchExpressionCanBePushedDownInspection.findDiffs(block, branches);
            if (diffs.length == 0) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiSwitchExpression newSwitch = (PsiSwitchExpression)factory.createExpressionFromText("switch(x) {}", (PsiElement)block);
            PsiExpression selector = block.getExpression();
            PsiExpression newSelector = Objects.requireNonNull(newSwitch.getExpression());
            if (selector == null) {
                newSelector.delete();
            } else {
                newSelector.replace((PsiElement)selector);
            }
            Objects.requireNonNull(newSwitch.getBody()).replace((PsiElement)Objects.requireNonNull(block.getBody()));
            List<PsiExpression> newBranches = Objects.requireNonNull(SwitchExpressionCanBePushedDownInspection.extractBranches((PsiSwitchBlock)newSwitch));
            for (int i = 0; i < newBranches.size(); ++i) {
                newBranches.get(i).replace((PsiElement)diffs[i]);
            }
            diffs[0].replace((PsiElement)newSwitch);
            PsiExpression expression = branches.get(0);
            if (block instanceof PsiSwitchExpression) {
                block.replace((PsiElement)expression);
            } else {
                PsiExpressionStatement newStatement = (PsiExpressionStatement)factory.createStatementFromText("x;", (PsiElement)block);
                newStatement.getExpression().replace((PsiElement)expression);
                block.replace((PsiElement)newStatement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/SwitchExpressionCanBePushedDownInspection$PushDownSwitchExpressionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/SwitchExpressionCanBePushedDownInspection$PushDownSwitchExpressionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

