/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SwitchUtils;
import org.jetbrains.annotations.NotNull;

public final class SwitchStatementWithTooManyBranchesInspection
extends BaseInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 10;
    public int m_limit = 10;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_limit", (String)InspectionGadgetsBundle.message("if.statement.with.too.many.branches.max.option", new Object[0]), (int)0, (int)1000)});
        if (optPane == null) {
            SwitchStatementWithTooManyBranchesInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer branchCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("if.statement.with.too.many.branches.problem.descriptor", branchCount);
        if (string == null) {
            SwitchStatementWithTooManyBranchesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementWithTooManyBranchesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/SwitchStatementWithTooManyBranchesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SwitchStatementWithTooManyBranchesVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementWithTooManyBranchesVisitor() {
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                SwitchStatementWithTooManyBranchesVisitor.$$$reportNull$$$0(0);
            }
            this.processSwitch((PsiSwitchBlock)expression);
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                SwitchStatementWithTooManyBranchesVisitor.$$$reportNull$$$0(1);
            }
            this.processSwitch((PsiSwitchBlock)statement);
        }

        public void processSwitch(PsiSwitchBlock expression) {
            int branchCountExcludingDefault;
            int branchCount = SwitchUtils.calculateBranchCount(expression);
            int n = branchCountExcludingDefault = branchCount < 0 ? -branchCount - 1 : branchCount;
            if (branchCountExcludingDefault <= SwitchStatementWithTooManyBranchesInspection.this.m_limit) {
                return;
            }
            this.registerError(expression.getFirstChild(), branchCountExcludingDefault);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/SwitchStatementWithTooManyBranchesInspection$SwitchStatementWithTooManyBranchesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

