/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.style.ConditionalExpressionGenerator;
import com.siyeh.ig.style.IfConditionalModel;
import java.util.Objects;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public final class TrivialIfInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreChainedIf = false;
    public boolean ignoreAssertStatements = false;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "RedundantIfStatement";
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreChainedIf", (String)InspectionGadgetsBundle.message("trivial.if.option.ignore.chained", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreAssertStatements", (String)InspectionGadgetsBundle.message("trivial.if.option.ignore.assert.statements", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            TrivialIfInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("trivial.if.problem.descriptor", new Object[0]);
        if (string == null) {
            TrivialIfInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        SmartList fixes = new SmartList((Object)new TrivialIfFix());
        String turnOffOption = (String)infos[0];
        if (turnOffOption != null) {
            OptCheckbox checkbox = (OptCheckbox)Objects.requireNonNull(this.getOptionsPane().findControl(turnOffOption));
            String message = StringUtil.unescapeXmlEntities((String)checkbox.label().label());
            fixes.add(LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)this, turnOffOption, message, true)));
        }
        LocalQuickFix[] localQuickFixArray = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            TrivialIfInspection.$$$reportNull$$$0(2);
        }
        return localQuickFixArray;
    }

    private static void simplify(PsiIfStatement statement) {
        ConditionalExpressionGenerator generator;
        IfConditionalModel model = IfConditionalModel.from(statement, true);
        if (model != null && (generator = ConditionalExpressionGenerator.from(model)) != null) {
            CommentTracker ct = new CommentTracker();
            String text = generator.generate(ct);
            if (model.getElseExpression().textMatches((CharSequence)text) && !PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)model.getElseBranch(), (boolean)false)) {
                ct.deleteAndRestoreComments((PsiElement)statement);
            } else if (model.getElseBranch() instanceof PsiDeclarationStatement) {
                ct.replace((PsiElement)model.getElseExpression(), text);
                ct.deleteAndRestoreComments((PsiElement)statement);
            } else {
                ct.replace((PsiElement)model.getThenExpression(), text);
                ct.replaceAndRestoreComments((PsiElement)statement, (PsiElement)model.getThenBranch());
                PsiStatement elseBranch = model.getElseBranch();
                if (elseBranch.isValid() && (elseBranch instanceof PsiExpressionStatement || !ControlFlowUtils.isReachable(elseBranch))) {
                    PsiElement sibling = elseBranch.getPrevSibling();
                    if (sibling instanceof PsiWhiteSpace) {
                        sibling.delete();
                    }
                    new CommentTracker().deleteAndRestoreComments((PsiElement)elseBranch);
                }
            }
        }
        if (TrivialIfInspection.isSimplifiableAssert(statement)) {
            TrivialIfInspection.replaceSimplifiableAssert(statement);
        }
    }

    private static void replaceSimplifiableAssert(PsiIfStatement statement) {
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition);
        if (statement.getElseBranch() != null) {
            return;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(statement.getThenBranch());
        if (!(thenBranch instanceof PsiAssertStatement)) {
            return;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)thenBranch;
        PsiExpression assertCondition = assertStatement.getAssertCondition();
        if (assertCondition == null) {
            return;
        }
        PsiExpression replacementCondition = JavaPsiFacade.getElementFactory((Project)statement.getProject()).createExpressionFromText((String)(BoolUtils.isFalse(assertCondition) ? conditionText : conditionText + "||" + assertCondition.getText()), (PsiElement)statement);
        assertCondition.replace((PsiElement)replacementCondition);
        statement.replace((PsiElement)assertStatement);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
                boolean chainedIf;
                if (ifStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitIfStatement(ifStatement);
                boolean bl = chainedIf = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)ifStatement) instanceof PsiIfStatement || ifStatement.getParent() instanceof PsiIfStatement && ((PsiIfStatement)ifStatement.getParent()).getElseBranch() == ifStatement;
                if (TrivialIfInspection.this.ignoreChainedIf && chainedIf && !this.isOnTheFly()) {
                    return;
                }
                PsiExpression condition = ifStatement.getCondition();
                if (condition == null) {
                    return;
                }
                if (TrivialIfInspection.this.isTrivial(ifStatement)) {
                    ProblemHighlightType level;
                    PsiElement anchor = Objects.requireNonNull(ifStatement.getFirstChild());
                    ProblemHighlightType problemHighlightType = level = TrivialIfInspection.this.ignoreChainedIf && chainedIf ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    String turnOffOption = chainedIf && !TrivialIfInspection.this.ignoreChainedIf && !InspectionProjectProfileManager.isInformationLevel((String)TrivialIfInspection.this.getShortName(), (PsiElement)ifStatement) ? "ignoreChainedIf" : (!TrivialIfInspection.this.ignoreAssertStatements && TrivialIfInspection.isSimplifiableAssert(ifStatement) ? "ignoreAssertStatements" : null);
                    this.registerError(anchor, level, new Object[]{turnOffOption});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/controlflow/TrivialIfInspection$1", "visitIfStatement"));
            }
        };
    }

    private boolean isTrivial(PsiIfStatement ifStatement) {
        ConditionalExpressionGenerator generator;
        if (PsiUtilCore.hasErrorElementChild((PsiElement)ifStatement)) {
            return false;
        }
        IfConditionalModel model = IfConditionalModel.from(ifStatement, true);
        if (model != null && (generator = ConditionalExpressionGenerator.from(model)) != null && generator.getTokenType().isEmpty()) {
            return true;
        }
        return !this.ignoreAssertStatements && TrivialIfInspection.isSimplifiableAssert(ifStatement);
    }

    private static boolean isSimplifiableAssert(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (!(thenBranch instanceof PsiAssertStatement)) {
            return false;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)thenBranch;
        return assertStatement.getAssertCondition() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/TrivialIfInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class TrivialIfFix
    extends PsiUpdateModCommandQuickFix {
        private TrivialIfFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("trivial.if.fix.family.name", new Object[0]);
            if (string == null) {
                TrivialIfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement ifKeywordElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                TrivialIfFix.$$$reportNull$$$0(1);
            }
            if (ifKeywordElement == null) {
                TrivialIfFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                TrivialIfFix.$$$reportNull$$$0(3);
            }
            PsiIfStatement statement = (PsiIfStatement)ifKeywordElement.getParent();
            TrivialIfInspection.simplify(statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifKeywordElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

