/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryLabelOnBreakStatementInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.label.on.break.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryLabelOnBreakStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessaryLabelOnBreakStatementFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryLabelOnBreakStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryLabelOnBreakStatementInspection", "buildErrorString"));
    }

    private static class UnnecessaryLabelOnBreakStatementFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessaryLabelOnBreakStatementFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.label.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryLabelOnBreakStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement breakKeywordElement, @NotNull ModPsiUpdater updater) {
            PsiBreakStatement breakStatement;
            PsiIdentifier identifier;
            if (project == null) {
                UnnecessaryLabelOnBreakStatementFix.$$$reportNull$$$0(1);
            }
            if (breakKeywordElement == null) {
                UnnecessaryLabelOnBreakStatementFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessaryLabelOnBreakStatementFix.$$$reportNull$$$0(3);
            }
            if ((identifier = (breakStatement = (PsiBreakStatement)breakKeywordElement.getParent()).getLabelIdentifier()) == null) {
                return;
            }
            identifier.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/UnnecessaryLabelOnBreakStatementInspection$UnnecessaryLabelOnBreakStatementFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "breakKeywordElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/UnnecessaryLabelOnBreakStatementInspection$UnnecessaryLabelOnBreakStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UnnecessaryLabelOnBreakStatementVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryLabelOnBreakStatementVisitor() {
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
            PsiIdentifier labelIdentifier;
            if (statement == null) {
                UnnecessaryLabelOnBreakStatementVisitor.$$$reportNull$$$0(0);
            }
            if ((labelIdentifier = statement.getLabelIdentifier()) == null) {
                return;
            }
            String labelText = labelIdentifier.getText();
            if (labelText == null || labelText.isEmpty()) {
                return;
            }
            PsiStatement exitedStatement = statement.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            PsiStatement labelEnabledParent = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiForStatement.class, PsiDoWhileStatement.class, PsiForeachStatement.class, PsiWhileStatement.class, PsiSwitchStatement.class});
            if (labelEnabledParent == null) {
                return;
            }
            if (exitedStatement.equals((Object)labelEnabledParent)) {
                this.registerError((PsiElement)labelIdentifier, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/UnnecessaryLabelOnBreakStatementInspection$UnnecessaryLabelOnBreakStatementVisitor", "visitBreakStatement"));
        }
    }
}

