/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.DeleteCatchSectionFix;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class CaughtExceptionImmediatelyRethrownInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("caught.exception.immediately.rethrown.problem.descriptor", new Object[0]);
        if (string == null) {
            CaughtExceptionImmediatelyRethrownInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiTryStatement tryStatement = (PsiTryStatement)infos[0];
        boolean removeTryCatch = tryStatement.getCatchSections().length == 1 && tryStatement.getFinallyBlock() == null && tryStatement.getResourceList() == null;
        return new DeleteCatchSectionFix(removeTryCatch);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CaughtExceptionImmediatelyRethrownVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/CaughtExceptionImmediatelyRethrownInspection", "buildErrorString"));
    }

    private static class CaughtExceptionImmediatelyRethrownVisitor
    extends BaseInspectionVisitor {
        private CaughtExceptionImmediatelyRethrownVisitor() {
        }

        public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
            if (statement == null) {
                CaughtExceptionImmediatelyRethrownVisitor.$$$reportNull$$$0(0);
            }
            super.visitThrowStatement(statement);
            PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getException());
            if (!(expression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiStatement previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
            if (previousStatement != null) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiStatement) {
                return;
            }
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)target;
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (!(declarationScope instanceof PsiCatchSection)) {
                return;
            }
            PsiCatchSection catchSection = (PsiCatchSection)declarationScope;
            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiCodeBlock.class);
            if (block == null) {
                return;
            }
            PsiElement blockParent = block.getParent();
            if (blockParent != catchSection) {
                return;
            }
            if (CaughtExceptionImmediatelyRethrownVisitor.isSuperClassExceptionCaughtLater((PsiVariable)parameter, catchSection)) {
                return;
            }
            for (PsiReferenceExpression element : VariableAccessUtils.getVariableReferences((PsiVariable)parameter)) {
                if (element == expression) continue;
                return;
            }
            PsiTryStatement tryStatement = catchSection.getTryStatement();
            this.registerVariableError((PsiVariable)parameter, tryStatement);
        }

        private static boolean isSuperClassExceptionCaughtLater(PsiVariable parameter, PsiCatchSection catchSection) {
            PsiTryStatement tryStatement = catchSection.getTryStatement();
            PsiCatchSection[] catchSections = tryStatement.getCatchSections();
            int index = 0;
            while (catchSections[index] != catchSection) {
                ++index;
            }
            PsiType type = parameter.getType();
            HashSet parameterClasses = new HashSet();
            CaughtExceptionImmediatelyRethrownVisitor.processExceptionClasses(type, (Processor<? super PsiClass>)((Processor)aClass -> {
                parameterClasses.add(aClass);
                return true;
            }));
            if (parameterClasses.isEmpty()) {
                return false;
            }
            Ref superClassExceptionType = new Ref((Object)Boolean.FALSE);
            for (int i = index; i < catchSections.length; ++i) {
                PsiCatchSection nextCatchSection = catchSections[i];
                PsiParameter nextParameter = nextCatchSection.getParameter();
                if (nextParameter == null) continue;
                PsiType nextType = nextParameter.getType();
                CaughtExceptionImmediatelyRethrownVisitor.processExceptionClasses(nextType, (Processor<? super PsiClass>)((Processor)aClass -> {
                    for (PsiClass parameterClass : parameterClasses) {
                        if (!parameterClass.isInheritor(aClass, true)) continue;
                        superClassExceptionType.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                }));
                if (!((Boolean)superClassExceptionType.get()).booleanValue()) continue;
                return true;
            }
            return false;
        }

        private static void processExceptionClasses(PsiType type, Processor<? super PsiClass> processor) {
            if (type instanceof PsiClassType) {
                PsiClassType classType = (PsiClassType)type;
                PsiClass aClass = classType.resolve();
                if (aClass != null) {
                    processor.process((Object)aClass);
                }
            } else if (type instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                for (PsiType disjunction : disjunctionType.getDisjunctions()) {
                    PsiClassType classType;
                    PsiClass aClass;
                    if (!(disjunction instanceof PsiClassType) || (aClass = (classType = (PsiClassType)disjunction).resolve()) == null) continue;
                    processor.process((Object)aClass);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/CaughtExceptionImmediatelyRethrownInspection$CaughtExceptionImmediatelyRethrownVisitor", "visitThrowStatement"));
        }
    }
}

