/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInsight.options.JavaClassValidator;
import com.intellij.codeInspection.AddToInspectionOptionListFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.java.JavaBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewExceptionWithoutArgumentsInspection
extends BaseInspection {
    public final List<String> exceptions = new ArrayList<String>();

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("new.exception.without.arguments.problem.descriptor", new Object[0]);
        if (string == null) {
            NewExceptionWithoutArgumentsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"exceptions", (String)JavaBundle.message((String)"label.ignored.exceptions", (Object[])new Object[0]), (StringValidator)new JavaClassValidator().withSuperClass("java.lang.Exception").withTitle(InspectionGadgetsBundle.message("choose.exception.class", new Object[0])))});
        if (optPane == null) {
            NewExceptionWithoutArgumentsInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        String exceptionName = (String)infos[0];
        return new AddToInspectionOptionListFix((InspectionProfileEntry)this, JavaAnalysisBundle.message((String)"intention.name.ignore.exception", (Object[])new Object[]{exceptionName}), exceptionName, tool -> tool.exceptions);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NewExceptionWithoutArgumentsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/NewExceptionWithoutArgumentsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NewExceptionWithoutArgumentsVisitor
    extends BaseInspectionVisitor {
        private NewExceptionWithoutArgumentsVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                NewExceptionWithoutArgumentsVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null || !argumentList.isEmpty()) {
                return;
            }
            PsiJavaCodeReferenceElement classReference = expression.getClassReference();
            if (classReference == null) {
                return;
            }
            PsiElement target = classReference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            if (NewExceptionWithoutArgumentsInspection.this.exceptions.contains(aClass.getQualifiedName())) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Exception")) {
                return;
            }
            if (NewExceptionWithoutArgumentsVisitor.hasAccessibleConstructorWithParameters(aClass, (PsiElement)expression)) {
                this.registerNewExpressionError(expression, aClass.getQualifiedName());
            }
        }

        public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
            if (expression == null) {
                NewExceptionWithoutArgumentsVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethodReferenceExpression(expression);
            if (!expression.isConstructor()) {
                return;
            }
            PsiType type = PsiMethodReferenceUtil.getQualifierType((PsiMethodReferenceExpression)expression);
            if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Exception")) {
                return;
            }
            PsiElement target = expression.resolve();
            if (!(target instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)target;
            if (method.getParameterList().getParametersCount() != 0) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null || !NewExceptionWithoutArgumentsVisitor.hasAccessibleConstructorWithParameters(aClass, (PsiElement)expression)) {
                return;
            }
            PsiElement qualifier = expression.getQualifier();
            if (qualifier == null) {
                return;
            }
            this.registerError(qualifier, aClass.getQualifiedName());
        }

        private static boolean hasAccessibleConstructorWithParameters(PsiClass aClass, PsiElement context) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                PsiResolveHelper resolveHelper;
                PsiParameterList parameterList = constructor.getParameterList();
                int count = parameterList.getParametersCount();
                if (count <= 0 || !(resolveHelper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper()).isAccessible((PsiMember)constructor, context, aClass)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/errorhandling/NewExceptionWithoutArgumentsInspection$NewExceptionWithoutArgumentsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

