/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public final class FinalizeInspection
extends BaseInspection {
    public boolean ignoreTrivialFinalizers = true;

    @NotNull
    public String getID() {
        return "FinalizeDeclaration";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("finalize.declaration.problem.descriptor", new Object[0]);
        if (string == null) {
            FinalizeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreTrivialFinalizers", (String)InspectionGadgetsBundle.message("ignore.trivial.finalizers.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            FinalizeInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new FinalizeDeclaredVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/finalization/FinalizeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class FinalizeDeclaredVisitor
    extends BaseInspectionVisitor {
        private FinalizeDeclaredVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                FinalizeDeclaredVisitor.$$$reportNull$$$0(0);
            }
            if (!MethodUtils.isFinalize(method)) {
                return;
            }
            if (FinalizeInspection.this.ignoreTrivialFinalizers && MethodUtils.isTrivial(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/finalization/FinalizeInspection$FinalizeDeclaredVisitor", "visitMethod"));
        }
    }
}

