/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ConvertToVarargsMethodFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("convert.to.variable.arity.method.quickfix", new Object[0]);
        if (string == null) {
            ConvertToVarargsMethodFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiElement psiElement;
        if (project == null) {
            ConvertToVarargsMethodFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            ConvertToVarargsMethodFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            ConvertToVarargsMethodFix.$$$reportNull$$$0(3);
        }
        if (!((psiElement = element.getParent()) instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)psiElement;
        ArrayList<PsiReferenceExpression> methodCalls = new ArrayList<PsiReferenceExpression>();
        ArrayList<PsiDocMethodOrFieldRef> javadocRefs = new ArrayList<PsiDocMethodOrFieldRef>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)method).findAll()) {
            PsiElement referenceElement = reference.getElement();
            if (referenceElement instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)referenceElement;
                methodCalls.add((PsiReferenceExpression)updater.getWritable((PsiElement)ref));
                continue;
            }
            if (!(referenceElement instanceof PsiDocMethodOrFieldRef)) continue;
            PsiDocMethodOrFieldRef ref = (PsiDocMethodOrFieldRef)referenceElement;
            javadocRefs.add((PsiDocMethodOrFieldRef)updater.getWritable((PsiElement)ref));
        }
        method = (PsiMethod)updater.getWritable((PsiElement)method);
        ConvertToVarargsMethodFix.makeMethodVarargs(method);
        ConvertToVarargsMethodFix.makeMethodCallsVarargs(methodCalls);
        ConvertToVarargsMethodFix.makeJavadocRefsVarargs(javadocRefs);
    }

    private static void makeJavadocRefsVarargs(Collection<PsiDocMethodOrFieldRef> refs) {
        for (PsiDocMethodOrFieldRef ref : refs) {
            String[] signature = ref.getSignature();
            if (signature == null) {
                return;
            }
            PsiElement name = ref.getNameElement();
            if (name == null) {
                return;
            }
            Object last = signature[signature.length - 1];
            if (!((String)last).endsWith("[]")) {
                return;
            }
            last = ((String)last).substring(0, ((String)last).length() - 2) + "...";
            StringBuilder text = new StringBuilder();
            text.append("/** {@link #").append(name.getText()).append("(");
            for (int i = 0; i < signature.length - 1; ++i) {
                text.append(signature[i]).append(",");
            }
            text.append((String)last).append(")} */");
            PsiComment comment = JavaPsiFacade.getElementFactory((Project)ref.getProject()).createCommentFromText(text.toString(), (PsiElement)ref);
            ref.replace(comment.getChildren()[2].getChildren()[3]);
        }
    }

    private static void makeMethodVarargs(PsiMethod method) {
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter lastParameter = parameterList.getParameter(parameterList.getParametersCount() - 1);
        if (lastParameter == null) {
            return;
        }
        lastParameter.normalizeDeclaration();
        PsiType type = lastParameter.getType();
        if (!(type instanceof PsiArrayType)) {
            return;
        }
        PsiArrayType arrayType = (PsiArrayType)type;
        PsiType componentType = arrayType.getComponentType();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        PsiEllipsisType ellipsisType = new PsiEllipsisType(componentType, TypeAnnotationProvider.Static.create((PsiAnnotation[])type.getAnnotations()));
        PsiTypeElement newTypeElement = factory.createTypeElement((PsiType)ellipsisType);
        PsiTypeElement typeElement = lastParameter.getTypeElement();
        if (typeElement != null) {
            CommentTracker ct = new CommentTracker();
            PsiElement result = ct.replace((PsiElement)typeElement, (PsiElement)newTypeElement);
            ct.insertCommentsBefore(result.getLastChild());
            JavaCodeStyleManager.getInstance((Project)method.getProject()).shortenClassReferences(result);
        }
    }

    private static void makeMethodCallsVarargs(Collection<PsiReferenceExpression> referenceExpressions) {
        for (PsiReferenceExpression referenceExpression : referenceExpressions) {
            PsiNewExpression newExpression;
            PsiArrayInitializerExpression arrayInitializerExpression;
            PsiExpression lastArgument;
            PsiMethodCallExpression methodCallExpression;
            PsiExpressionList argumentList;
            PsiExpression[] arguments;
            PsiElement psiElement = referenceExpression.getParent();
            if (!(psiElement instanceof PsiMethodCallExpression) || (arguments = (argumentList = (methodCallExpression = (PsiMethodCallExpression)psiElement).getArgumentList()).getExpressions()).length == 0 || !((lastArgument = arguments[arguments.length - 1]) instanceof PsiNewExpression) || (arrayInitializerExpression = (newExpression = (PsiNewExpression)lastArgument).getArrayInitializer()) == null) continue;
            for (PsiExpression initializer : arrayInitializerExpression.getInitializers()) {
                argumentList.add((PsiElement)initializer);
            }
            lastArgument.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/ConvertToVarargsMethodFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/ConvertToVarargsMethodFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

