/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.SingleDeclarationNormalizer;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NormalizeDeclarationFix
extends PsiUpdateModCommandQuickFix {
    private final boolean myCStyleDeclaration;

    public NormalizeDeclarationFix(boolean cStyleDeclaration) {
        this.myCStyleDeclaration = cStyleDeclaration;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myCStyleDeclaration ? InspectionGadgetsBundle.message("c.style.array.declaration.replace.quickfix", new Object[0]) : InspectionGadgetsBundle.message("normalize.declaration.quickfix", new Object[0]);
        if (string == null) {
            NormalizeDeclarationFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        block19: {
            block20: {
                block17: {
                    PsiDeclarationStatement declarationStatement;
                    block18: {
                        if (project == null) {
                            NormalizeDeclarationFix.$$$reportNull$$$0(1);
                        }
                        if (element == null) {
                            NormalizeDeclarationFix.$$$reportNull$$$0(2);
                        }
                        if (updater == null) {
                            NormalizeDeclarationFix.$$$reportNull$$$0(3);
                        }
                        if (!(element instanceof PsiVariable || element instanceof PsiMethod || element instanceof PsiDeclarationStatement)) {
                            element = element.getParent();
                        }
                        if (element instanceof PsiParameter || element instanceof PsiRecordComponent) {
                            JavaSharedImplUtil.normalizeBrackets((PsiVariable)((PsiVariable)element));
                            return;
                        }
                        if (element instanceof PsiLocalVariable && !((element = element.getParent()) instanceof PsiDeclarationStatement)) {
                            return;
                        }
                        if (!(element instanceof PsiDeclarationStatement)) break block17;
                        declarationStatement = (PsiDeclarationStatement)element;
                        PsiElement grandParent = element.getParent();
                        if (!(grandParent instanceof PsiForStatement)) break block18;
                        PsiForStatement statement = (PsiForStatement)grandParent;
                        NormalizeDeclarationFix.splitMultipleDeclarationInForStatementInitialization(statement);
                        break block19;
                    }
                    Object[] elements = declarationStatement.getDeclaredElements();
                    List psiVariables = ContainerUtil.filterIsInstance((Object[])elements, PsiVariable.class);
                    if (this.myCStyleDeclaration && elements.length == psiVariables.size() && new SingleDeclarationNormalizer(psiVariables).normalize()) break block19;
                    PsiVariable variable = (PsiVariable)elements[0];
                    variable.normalizeDeclaration();
                    for (int i = 1; i < elements.length; ++i) {
                        declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)declarationStatement, PsiDeclarationStatement.class);
                        assert (declarationStatement != null);
                        JavaSharedImplUtil.normalizeBrackets((PsiVariable)((PsiVariable)declarationStatement.getDeclaredElements()[0]));
                    }
                    break block19;
                }
                if (!(element instanceof PsiField)) break block20;
                PsiField f = (PsiField)element;
                PsiField field = DeclarationSearchUtils.findFirstFieldInDeclaration(f);
                assert (field != null);
                PsiField nextField = field;
                int count = 0;
                ArrayList<PsiVariable> psiFields = new ArrayList<PsiVariable>();
                while (nextField != null) {
                    ++count;
                    psiFields.add((PsiVariable)nextField);
                    nextField = DeclarationSearchUtils.findNextFieldInDeclaration(nextField);
                }
                if (this.myCStyleDeclaration && new SingleDeclarationNormalizer(psiFields).normalize()) break block19;
                field.normalizeDeclaration();
                for (int i = 1; i < count; ++i) {
                    field = (PsiField)PsiTreeUtil.getNextSiblingOfType((PsiElement)field, PsiField.class);
                    assert (field != null);
                    JavaSharedImplUtil.normalizeBrackets((PsiVariable)field);
                }
                break block19;
            }
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiTypeElement returnTypeElement = method.getReturnTypeElement();
                if (returnTypeElement == null) {
                    return;
                }
                PsiType returnType = method.getReturnType();
                if (returnType == null) {
                    return;
                }
                PsiTypeElement typeElement = JavaPsiFacade.getElementFactory((Project)project).createTypeElement(returnType);
                CommentTracker ct = new CommentTracker();
                PsiElement replacement = ct.replaceAndRestoreComments((PsiElement)returnTypeElement, (PsiElement)typeElement);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replacement);
                PsiParameterList child = method.getParameterList();
                while (child != null && !(child instanceof PsiCodeBlock)) {
                    PsiParameterList elementToDelete = child;
                    child = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)child);
                    if (elementToDelete instanceof PsiJavaToken) {
                        PsiJavaToken token = (PsiJavaToken)elementToDelete;
                        IElementType tokenType = token.getTokenType();
                        if (!JavaTokenType.LBRACKET.equals(tokenType) && !JavaTokenType.RBRACKET.equals(tokenType)) continue;
                        elementToDelete.delete();
                        continue;
                    }
                    if (!(elementToDelete instanceof PsiAnnotation)) continue;
                    elementToDelete.delete();
                }
            }
        }
    }

    private static void splitMultipleDeclarationInForStatementInitialization(PsiForStatement forStatement) {
        int max;
        PsiStatement initialization;
        if (!(forStatement.getParent() instanceof PsiCodeBlock)) {
            forStatement = (PsiForStatement)BlockUtils.expandSingleStatementToBlockStatement((PsiStatement)forStatement);
        }
        if (!((initialization = forStatement.getInitialization()) instanceof PsiDeclarationStatement)) {
            return;
        }
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)initialization;
        List variables = ContainerUtil.filterIsInstance((Object[])declarationStatement.getDeclaredElements(), PsiLocalVariable.class);
        boolean dependentVariables = NormalizeDeclarationFix.containsDependentVariables(variables);
        if (dependentVariables) {
            min = 0;
            max = variables.size() - 1;
        } else {
            min = 1;
            max = variables.size();
        }
        CommentTracker ct = new CommentTracker();
        for (int i = min; i < max; ++i) {
            PsiVariable variable = (PsiVariable)variables.get(i);
            PsiDeclarationStatement newStatement = NormalizeDeclarationFix.createNewDeclaration(variable, ct);
            forStatement.getParent().addBefore((PsiElement)newStatement, (PsiElement)forStatement);
        }
        PsiVariable remainingVariable = (PsiVariable)variables.get(dependentVariables ? variables.size() - 1 : 0);
        PsiDeclarationStatement replacementStatement = NormalizeDeclarationFix.createNewDeclaration(remainingVariable, ct);
        ct.replaceAndRestoreComments((PsiElement)declarationStatement, (PsiElement)replacementStatement);
    }

    @NotNull
    private static PsiDeclarationStatement createNewDeclaration(PsiVariable variable, CommentTracker ct) {
        String name = variable.getName();
        assert (name != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
        PsiDeclarationStatement replacementStatement = factory.createVariableDeclarationStatement(name, variable.getType(), ct.markUnchanged(variable.getInitializer()), (PsiElement)variable);
        if (!variable.hasModifierProperty("final")) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiLocalVariable)replacementStatement.getDeclaredElements()[0]), (String)"final", (boolean)false);
        }
        PsiDeclarationStatement psiDeclarationStatement = replacementStatement;
        if (psiDeclarationStatement == null) {
            NormalizeDeclarationFix.$$$reportNull$$$0(4);
        }
        return psiDeclarationStatement;
    }

    private static boolean containsDependentVariables(List<PsiLocalVariable> variables) {
        if (variables.isEmpty()) {
            return false;
        }
        HashSet visited = ContainerUtil.newHashSet((Object[])new PsiLocalVariable[]{variables.getFirst()});
        for (int i = 1; i < variables.size(); ++i) {
            PsiLocalVariable variable = variables.get(i);
            if (!PsiTreeUtil.processElements((PsiElement)variable.getInitializer(), element -> !visited.contains(NormalizeDeclarationFix.tryResolveLocalVariable(element)))) {
                return true;
            }
            visited.add(variable);
        }
        return false;
    }

    private static PsiLocalVariable tryResolveLocalVariable(PsiElement element) {
        PsiReferenceExpression referenceExpression;
        if (element instanceof PsiReferenceExpression && (referenceExpression = (PsiReferenceExpression)element).getQualifierExpression() == null) {
            PsiLocalVariable var;
            PsiElement psiElement = referenceExpression.resolve();
            return psiElement instanceof PsiLocalVariable ? (var = (PsiLocalVariable)psiElement) : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/NormalizeDeclarationFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/NormalizeDeclarationFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

