/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class SingleDeclarationNormalizer {
    private final List<PsiVariable> myVariables;

    SingleDeclarationNormalizer(@NotNull List<PsiVariable> variables) {
        if (variables == null) {
            SingleDeclarationNormalizer.$$$reportNull$$$0(0);
        }
        this.myVariables = variables;
    }

    boolean normalize() {
        if (!this.possibleSingleDeclaration() || !this.sameAnnotationsForAllDimensions()) {
            return false;
        }
        PsiVariable firstVar = this.myVariables.get(0);
        JavaSharedImplUtil.normalizeBrackets((PsiVariable)firstVar);
        PsiVariable nextVar = firstVar;
        for (int i = 1; i < this.myVariables.size(); ++i) {
            IElementType tokenType;
            PsiElement currSibling;
            nextVar = (PsiVariable)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextVar, PsiVariable.class);
            assert (nextVar != null);
            PsiElement nextSibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)nextVar.getNameIdentifier());
            while (nextSibling != null && (!((currSibling = nextSibling) instanceof PsiJavaToken) || (tokenType = ((PsiJavaToken)currSibling).getTokenType()) != JavaTokenType.EQ && tokenType != JavaTokenType.SEMICOLON)) {
                nextSibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)nextSibling);
                currSibling.delete();
            }
        }
        return true;
    }

    private boolean possibleSingleDeclaration() {
        if (this.myVariables.size() < 2) {
            return false;
        }
        int firstVarArrayDimensions = this.myVariables.get(0).getType().getArrayDimensions();
        for (int i = 1; i < this.myVariables.size(); ++i) {
            PsiVariable nextVar = this.myVariables.get(i);
            if (firstVarArrayDimensions == nextVar.getType().getArrayDimensions()) continue;
            return false;
        }
        return true;
    }

    private boolean sameAnnotationsForAllDimensions() {
        PsiVariable firstVar = this.myVariables.get(0);
        assert (firstVar.getNameIdentifier() != null);
        Map<Integer, Set<String>> firstFieldAnnotations = SingleDeclarationNormalizer.getFieldAnnotations((PsiElement)firstVar.getNameIdentifier());
        PsiVariable nextVar = firstVar;
        for (int i = 1; i < this.myVariables.size(); ++i) {
            nextVar = (PsiVariable)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextVar, PsiVariable.class);
            assert (nextVar != null);
            assert (nextVar.getNameIdentifier() != null);
            Map<Integer, Set<String>> nextFieldAnnotations = SingleDeclarationNormalizer.getFieldAnnotations((PsiElement)nextVar.getNameIdentifier());
            if (firstFieldAnnotations.size() != nextFieldAnnotations.size()) {
                return false;
            }
            if (ContainerUtil.intersection(firstFieldAnnotations, nextFieldAnnotations).size() == firstFieldAnnotations.size()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<Integer, Set<String>> getFieldAnnotations(@NotNull PsiElement startElement) {
        if (startElement == null) {
            SingleDeclarationNormalizer.$$$reportNull$$$0(1);
        }
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
        int dimensionCounter = 0;
        PsiElement nextSibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)startElement);
        while (nextSibling != null) {
            if (nextSibling instanceof PsiAnnotation) {
                Set annotations = (Set)result.computeIfAbsent(dimensionCounter, v -> new HashSet());
                annotations.add(((PsiAnnotation)nextSibling).getQualifiedName());
            } else if (PsiUtil.isJavaToken((PsiElement)nextSibling, (IElementType)JavaTokenType.RBRACKET)) {
                ++dimensionCounter;
            }
            nextSibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)nextSibling);
        }
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = result;
        if (int2ObjectOpenHashMap == null) {
            SingleDeclarationNormalizer.$$$reportNull$$$0(2);
        }
        return int2ObjectOpenHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/SingleDeclarationNormalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/SingleDeclarationNormalizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFieldAnnotations";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

