/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.DeleteImportFix;
import org.jetbrains.annotations.NotNull;

public final class SamePackageImportInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("import.from.same.package.problem.descriptor", new Object[0]);
        if (string == null) {
            SamePackageImportInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new DeleteImportFix();
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            SamePackageImportInspection.$$$reportNull$$$0(1);
        }
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SamePackageImportVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/imports/SamePackageImportInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/imports/SamePackageImportInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class SamePackageImportVisitor
    extends BaseInspectionVisitor {
        private SamePackageImportVisitor() {
        }

        public void visitImportList(@NotNull PsiImportList importList) {
            PsiImportStatement[] importStatements;
            PsiElement parent;
            if (importList == null) {
                SamePackageImportVisitor.$$$reportNull$$$0(0);
            }
            if (!((parent = importList.getParent()) instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile javaFile = (PsiJavaFile)parent;
            String packageName = javaFile.getPackageName();
            for (PsiImportStatement importStatement : importStatements = importList.getImportStatements()) {
                PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
                if (reference == null) continue;
                String text = importStatement.getQualifiedName();
                if (importStatement.isOnDemand()) {
                    if (!packageName.equals(text)) continue;
                    this.registerError((PsiElement)importStatement, new Object[0]);
                    continue;
                }
                if (text == null) {
                    return;
                }
                int classNameIndex = text.lastIndexOf(46);
                String parentName = classNameIndex < 0 ? "" : text.substring(0, classNameIndex);
                if (!packageName.equals(parentName)) continue;
                this.registerError((PsiElement)importStatement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importList", "com/siyeh/ig/imports/SamePackageImportInspection$SamePackageImportVisitor", "visitImportList"));
        }
    }
}

