/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import org.jetbrains.annotations.NotNull;

public final class ExtendsUtilityClassInspection
extends BaseInspection {
    public boolean ignoreUtilityClasses = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass superClass = (PsiClass)infos[0];
        String superClassName = superClass.getName();
        String string = InspectionGadgetsBundle.message("class.extends.utility.class.problem.descriptor", superClassName);
        if (string == null) {
            ExtendsUtilityClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreUtilityClasses", (String)InspectionGadgetsBundle.message("class.extends.utility.class.ignore.utility.class.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ExtendsUtilityClassInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ClassExtendsUtilityClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/ExtendsUtilityClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ClassExtendsUtilityClassVisitor
    extends BaseInspectionVisitor {
        private ClassExtendsUtilityClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ClassExtendsUtilityClassVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            PsiClass superClass = aClass.getSuperClass();
            if (superClass == null) {
                return;
            }
            if (superClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!UtilityClassUtil.isUtilityClass(superClass)) {
                return;
            }
            if (ExtendsUtilityClassInspection.this.ignoreUtilityClasses && UtilityClassUtil.isUtilityClass(aClass, false, false)) {
                return;
            }
            this.registerClassError(aClass, superClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/inheritance/ExtendsUtilityClassInspection$ClassExtendsUtilityClassVisitor", "visitClass"));
        }
    }
}

