/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.inheritance.AbstractMethodOverridesAbstractMethodInspection;
import com.siyeh.ig.migration.TryWithIdenticalCatchesInspection;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TrackingEquivalenceChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedundantMethodOverrideInspection
extends BaseInspection {
    public boolean checkLibraryMethods = true;
    public boolean ignoreDelegates = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean delegatesToSuperMethod = (Boolean)infos[0];
        String string = delegatesToSuperMethod ? InspectionGadgetsBundle.message("redundant.method.override.delegates.to.super.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("redundant.method.override.problem.descriptor", new Object[0]);
        if (string == null) {
            RedundantMethodOverrideInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"checkLibraryMethods", (String)InspectionGadgetsBundle.message("redundant.method.override.option.check.library.methods", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreDelegates", (String)InspectionGadgetsBundle.message("redundant.method.override.option.ignore.delegates", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RedundantMethodOverrideInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        Boolean isDelegate;
        Boolean canBeRemoved;
        Object object;
        ArrayList<PsiUpdateModCommandQuickFix> quickFixes = new ArrayList<PsiUpdateModCommandQuickFix>();
        if (infos.length > 1 && (object = infos[1]) instanceof Boolean && (canBeRemoved = (Boolean)object).booleanValue()) {
            quickFixes.add(new RedundantMethodOverrideFix());
        }
        if (infos.length > 0 && (object = infos[0]) instanceof Boolean && !(isDelegate = (Boolean)object).booleanValue()) {
            quickFixes.add(new ReplaceWithSuperDelegateFix());
        }
        LocalQuickFix[] localQuickFixArray = quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            RedundantMethodOverrideInspection.$$$reportNull$$$0(2);
        }
        return localQuickFixArray;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantMethodOverrideVisitor();
    }

    @Nullable
    private static PsiMethod findSuperMethod(@NotNull PsiMethod method) {
        Object[] superMethods;
        if (method == null) {
            RedundantMethodOverrideInspection.$$$reportNull$$$0(3);
        }
        if ((superMethods = method.findSuperMethods()).length == 1) {
            return superMethods[0];
        }
        if (ContainerUtil.exists((Object[])superMethods, superMethod -> superMethod.hasModifierProperty("abstract"))) {
            return null;
        }
        return StreamEx.of((Object[])superMethods).findFirst(candidate -> RedundantMethodOverrideInspection.isNotInterface(candidate.getContainingClass())).orElse(null);
    }

    private static boolean isNotInterface(@Nullable PsiClass psiClass) {
        return psiClass != null && !psiClass.isInterface();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findSuperMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }

    private static class RedundantMethodOverrideFix
    extends PsiUpdateModCommandQuickFix {
        private RedundantMethodOverrideFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("redundant.method.override.quickfix", new Object[0]);
            if (string == null) {
                RedundantMethodOverrideFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement methodNameIdentifier, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                RedundantMethodOverrideFix.$$$reportNull$$$0(1);
            }
            if (methodNameIdentifier == null) {
                RedundantMethodOverrideFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RedundantMethodOverrideFix.$$$reportNull$$$0(3);
            }
            PsiElement method = methodNameIdentifier.getParent();
            assert (method != null);
            method.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$RedundantMethodOverrideFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNameIdentifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$RedundantMethodOverrideFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ReplaceWithSuperDelegateFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithSuperDelegateFix() {
        }

        @Nullable
        private static PsiClassType findRequiredSuperQualifier(@Nullable PsiClass contextClass, PsiMethod methodToCall) {
            if (contextClass == null) {
                return null;
            }
            PsiClass superClass = methodToCall.getContainingClass();
            if (superClass == null || !superClass.isInterface()) {
                return null;
            }
            if (contextClass instanceof PsiAnonymousClass) {
                PsiAnonymousClass anonymousClass = (PsiAnonymousClass)contextClass;
                PsiClass baseClass = anonymousClass.getBaseClassType().resolve();
                return baseClass != null && baseClass.isInterface() ? anonymousClass.getBaseClassType() : null;
            }
            PsiClassType superType = PsiTypesUtil.getClassType((PsiClass)superClass);
            if (!contextClass.isInterface() && ContainerUtil.exists((Object[])contextClass.getExtendsListTypes(), type -> TypeConversionUtil.isAssignable((PsiType)superType, (PsiType)type))) {
                return null;
            }
            PsiClassType[] types = contextClass.isInterface() ? contextClass.getExtendsListTypes() : contextClass.getImplementsListTypes();
            return (PsiClassType)ContainerUtil.findLast(Arrays.asList(types), type -> TypeConversionUtil.isAssignable((PsiType)superType, (PsiType)type));
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("redundant.method.override.delegate.quickfix", new Object[0]);
            if (string == null) {
                ReplaceWithSuperDelegateFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement methodNameIdentifier, @NotNull ModPsiUpdater updater) {
            PsiTypeElement oldType;
            PsiTypeElement newType;
            PsiSubstitutor substitutor;
            PsiElement psiElement;
            if (project == null) {
                ReplaceWithSuperDelegateFix.$$$reportNull$$$0(1);
            }
            if (methodNameIdentifier == null) {
                ReplaceWithSuperDelegateFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithSuperDelegateFix.$$$reportNull$$$0(3);
            }
            if (!((psiElement = methodNameIdentifier.getParent()) instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)psiElement;
            PsiMethod superMethod = RedundantMethodOverrideInspection.findSuperMethod(method);
            if (superMethod == null) {
                return;
            }
            PsiClassType requiredQualifier = ReplaceWithSuperDelegateFix.findRequiredSuperQualifier(method.getContainingClass(), superMethod);
            String qualifier = requiredQualifier != null ? requiredQualifier.rawType().getCanonicalText() + ".super." : "super.";
            String parameters = StringUtil.join((Object[])superMethod.getParameterList().getParameters(), PsiParameter::getName, (String)",");
            String call = qualifier + method.getName() + "(" + parameters + ");";
            if (!PsiTypes.voidType().equals((Object)method.getReturnType())) {
                call = "return " + call;
            }
            if ((substitutor = AbstractMethodOverridesAbstractMethodInspection.getSuperSubstitutor(method, superMethod)) == null) {
                return;
            }
            PsiParameterList parameterList = (PsiParameterList)superMethod.getParameterList().copy();
            for (PsiParameter parameter : parameterList.getParameters()) {
                newType = PsiElementFactory.getInstance((Project)project).createTypeElement(substitutor.substitute(parameter.getType()));
                oldType = parameter.getTypeElement();
                assert (oldType != null);
                oldType.replace((PsiElement)newType);
            }
            for (PsiParameter parameter : method.getParameterList().getParameters()) {
                newType = PsiElementFactory.getInstance((Project)project).createTypeElement(substitutor.substitute(parameter.getType()));
                oldType = parameter.getTypeElement();
                assert (oldType != null);
                oldType.replace((PsiElement)newType);
            }
            method.getParameterList().replace((PsiElement)parameterList);
            PsiCodeBlock methodBody = method.getBody();
            if (methodBody != null) {
                for (PsiStatement element : methodBody.getStatements()) {
                    element.delete();
                }
                PsiStatement statement = PsiElementFactory.getInstance((Project)project).createStatementFromText(call, (PsiElement)methodBody);
                methodBody.add((PsiElement)statement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$ReplaceWithSuperDelegateFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNameIdentifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$ReplaceWithSuperDelegateFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class RedundantMethodOverrideVisitor
    extends BaseInspectionVisitor {
        private RedundantMethodOverrideVisitor() {
        }

        public void visitMethod(final @NotNull PsiMethod method) {
            if (method == null) {
                RedundantMethodOverrideVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (method.isConstructor()) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null || method.getNameIdentifier() == null) {
                return;
            }
            PsiMethod superMethod = RedundantMethodOverrideInspection.findSuperMethod(method);
            if (superMethod == null || !AbstractMethodOverridesAbstractMethodInspection.methodsHaveSameAnnotationsAndModifiers(method, superMethod) || !AbstractMethodOverridesAbstractMethodInspection.haveSameReturnTypes(method, superMethod) || !AbstractMethodOverridesAbstractMethodInspection.haveSameExceptionSignatures(method, superMethod) || method.getDocComment() != null && !AbstractMethodOverridesAbstractMethodInspection.haveSameJavaDoc(method, superMethod) || method.isVarArgs() != superMethod.isVarArgs()) {
                return;
            }
            if (superMethod.hasModifierProperty("default") && !PsiUtil.isAvailable((JavaFeature)JavaFeature.EXTENSION_METHODS, (PsiElement)method)) {
                return;
            }
            boolean canBeRemoved = MethodSignatureUtil.areErasedParametersEqual((MethodSignature)method.getSignature(PsiSubstitutor.EMPTY), (MethodSignature)superMethod.getSignature(PsiSubstitutor.EMPTY));
            boolean isDelegate = this.isSuperCallWithSameArguments(body, method, superMethod);
            if (isDelegate) {
                if (!RedundantMethodOverrideInspection.this.ignoreDelegates && canBeRemoved) {
                    this.registerMethodError(method, isDelegate, canBeRemoved);
                }
                return;
            }
            if (RedundantMethodOverrideInspection.this.checkLibraryMethods && superMethod instanceof PsiCompiledElement) {
                PsiElement navigationElement = superMethod.getNavigationElement();
                if (!(navigationElement instanceof PsiMethod)) {
                    return;
                }
                superMethod = (PsiMethod)navigationElement;
            }
            PsiCodeBlock superBody = superMethod.getBody();
            final PsiMethod finalSuperMethod = superMethod;
            TrackingEquivalenceChecker checker = new TrackingEquivalenceChecker(){

                @Override
                protected boolean equivalentDeclarations(PsiElement element1, PsiElement element2) {
                    if (super.equivalentDeclarations(element1, element2)) {
                        return true;
                    }
                    return RedundantMethodOverrideInspection.this.checkLibraryMethods && element1.getNavigationElement().equals((Object)element2.getNavigationElement());
                }

                @Override
                protected PsiClass getQualifierTarget(PsiReferenceExpression ref) {
                    PsiClass target = super.getQualifierTarget(ref);
                    if (target == method.getContainingClass() && target == PsiUtil.getContainingClass((PsiElement)ref)) {
                        return finalSuperMethod.getContainingClass();
                    }
                    return target;
                }

                @Override
                @NotNull
                protected EquivalenceChecker.Match thisExpressionsMatch(@NotNull PsiThisExpression thisExpression1, @NotNull PsiThisExpression thisExpression2) {
                    if (thisExpression1 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (thisExpression2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    PsiClass containingClass1 = PsiUtil.resolveClassInClassTypeOnly((PsiType)thisExpression1.getType());
                    PsiClass containingClass2 = PsiUtil.resolveClassInClassTypeOnly((PsiType)thisExpression2.getType());
                    if (containingClass1 == finalSuperMethod.getContainingClass()) {
                        if (containingClass2 == method.getContainingClass()) {
                            EquivalenceChecker.Match match = EXACT_MATCH;
                            if (match == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return match;
                        }
                    } else if (containingClass1 == containingClass2) {
                        EquivalenceChecker.Match match = EXACT_MATCH;
                        if (match == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return match;
                    }
                    EquivalenceChecker.Match match = EXACT_MISMATCH;
                    if (match == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return match;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2, 3, 4 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "thisExpression1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "thisExpression2";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$RedundantMethodOverrideVisitor$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$RedundantMethodOverrideVisitor$1";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[1] = "thisExpressionsMatch";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "thisExpressionsMatch";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2, 3, 4 -> new IllegalStateException(string);
                    };
                }
            };
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiParameter[] superParameters = superMethod.getParameterList().getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                checker.markDeclarationsAsEquivalent((PsiElement)parameters[i], (PsiElement)superParameters[i]);
            }
            checker.markDeclarationsAsEquivalent((PsiElement)method, (PsiElement)superMethod);
            if (checker.codeBlocksAreEquivalent(body, superBody) && RedundantMethodOverrideVisitor.haveTheSameComments(method, superMethod)) {
                this.registerMethodError(method, isDelegate, canBeRemoved);
            }
        }

        private static boolean haveTheSameComments(PsiMethod method1, PsiMethod method2) {
            Set<String> text1 = RedundantMethodOverrideVisitor.collectCommentText(method1);
            Set<String> text2 = RedundantMethodOverrideVisitor.collectCommentText(method2);
            return text2.containsAll(text1);
        }

        private static Set<String> collectCommentText(PsiMethod method) {
            HashSet<String> result = new HashSet<String>();
            PsiTreeUtil.processElements((PsiElement)method, child -> {
                String text;
                PsiComment psiComment;
                if (child instanceof PsiComment && !((psiComment = (PsiComment)child) instanceof PsiDocComment) && !(text = TryWithIdenticalCatchesInspection.getCommentText(psiComment)).isEmpty()) {
                    result.add(text);
                }
                return true;
            });
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isSuperCallWithSameArguments(PsiCodeBlock body, PsiMethod method, PsiMethod superMethod) {
            PsiExpression expression;
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 1) {
                return false;
            }
            PsiStatement statement = statements[0];
            if (PsiTypes.voidType().equals((Object)method.getReturnType())) {
                if (!(statement instanceof PsiExpressionStatement)) return false;
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
                expression = expressionStatement.getExpression();
            } else {
                if (!(statement instanceof PsiReturnStatement)) return false;
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
                expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)returnStatement.getReturnValue());
            }
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            if (!MethodCallUtils.isSuperMethodCall(methodCallExpression, method)) {
                return false;
            }
            PsiMethod targetMethod = methodCallExpression.resolveMethod();
            if (targetMethod != superMethod) {
                return false;
            }
            if (!RedundantMethodOverrideVisitor.collectCommentText(method).isEmpty()) {
                return false;
            }
            if (!superMethod.hasModifierProperty("protected")) return RedundantMethodOverrideVisitor.areSameArguments(methodCallExpression, method);
            PsiJavaFile file = (PsiJavaFile)method.getContainingFile();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)method.getProject()).findPackage(file.getPackageName());
            if (aPackage == null) {
                return false;
            }
            PackageScope scope = new PackageScope(aPackage, false, false);
            if (this.isOnTheFly()) {
                PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)method.getProject());
                PsiSearchHelper.SearchCostResult cost = searchHelper.isCheapEnoughToSearch(method.getName(), (GlobalSearchScope)scope, null);
                if (cost == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
                    return true;
                }
                if (cost == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return false;
                }
            }
            Query search = ReferencesSearch.search((PsiElement)method, (SearchScope)scope);
            PsiClass containingClass = method.getContainingClass();
            for (PsiReference reference : search.asIterable()) {
                if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)reference.getElement(), (boolean)true)) continue;
                return false;
            }
            return RedundantMethodOverrideVisitor.areSameArguments(methodCallExpression, method);
        }

        private static boolean areSameArguments(PsiMethodCallExpression methodCallExpression, PsiMethod method) {
            PsiParameter[] parameters;
            PsiExpression[] arguments = methodCallExpression.getArgumentList().getExpressions();
            if (arguments.length != (parameters = method.getParameterList().getParameters()).length) {
                return false;
            }
            for (int i = 0; i < arguments.length; ++i) {
                PsiExpression argument = arguments[i];
                PsiExpression exp = PsiUtil.deparenthesizeExpression((PsiExpression)argument);
                if (!(exp instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiElement resolved = ((PsiReferenceExpression)exp).resolve();
                if (method.getManager().areElementsEquivalent((PsiElement)parameters[i], resolved)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$RedundantMethodOverrideVisitor", "visitMethod"));
        }
    }
}

