/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListModCommandFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandExecutor;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class StaticInheritanceFix
extends ModCommandQuickFix {
    private final boolean myReplaceInWholeProject;

    StaticInheritanceFix(boolean replaceInWholeProject) {
        this.myReplaceInWholeProject = replaceInWholeProject;
    }

    @NotNull
    public String getName() {
        String scope = this.myReplaceInWholeProject ? InspectionGadgetsBundle.message("the.whole.project", new Object[0]) : InspectionGadgetsBundle.message("this.class", new Object[0]);
        String string = InspectionGadgetsBundle.message("static.inheritance.replace.quickfix", scope);
        if (string == null) {
            StaticInheritanceFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("static.inheritance.fix.family.name", new Object[0]);
        if (string == null) {
            StaticInheritanceFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            StaticInheritanceFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            StaticInheritanceFix.$$$reportNull$$$0(3);
        }
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)descriptor.getStartElement();
        PsiClass iface = (PsiClass)referenceElement.resolve();
        assert (iface != null);
        PsiField[] allFields = iface.getAllFields();
        PsiClass implementingClass = PsiUtil.getContainingClass((PsiElement)referenceElement);
        assert (implementingClass != null);
        ActionContext context = ActionContext.from((ProblemDescriptor)descriptor);
        ModCommand modCommand = ModCommand.psiUpdate((ActionContext)context, updater -> this.processUsages(context, allFields, implementingClass, project, iface, (ModPsiUpdater)updater));
        if (modCommand == null) {
            StaticInheritanceFix.$$$reportNull$$$0(4);
        }
        return modCommand;
    }

    private void processUsages(@NotNull ActionContext context, @NotNull @NotNull PsiField @NotNull [] allFields, PsiClass implementingClass, Project project, PsiClass iface, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            StaticInheritanceFix.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            StaticInheritanceFix.$$$reportNull$$$0(6);
        }
        if (allFields == null) {
            StaticInheritanceFix.$$$reportNull$$$0(7);
        }
        Map<PsiReferenceExpression, PsiClass> replacements = this.findReplacements(allFields, implementingClass, updater);
        PsiClassType classType = JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(iface);
        PsiClass aClass = (PsiClass)updater.getWritable((PsiElement)implementingClass);
        ExtendsListModCommandFix fix = new ExtendsListModCommandFix(aClass, classType, false);
        ModCommandExecutor.getInstance().executeForFileCopy(fix.perform(context), aClass.getContainingFile());
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        replacements.forEach((referenceExpression, containingClass) -> {
            PsiReferenceExpression qualified = (PsiReferenceExpression)elementFactory.createExpressionFromText("xxx." + referenceExpression.getText(), (PsiElement)referenceExpression);
            PsiReferenceExpression newReference = (PsiReferenceExpression)referenceExpression.replace((PsiElement)qualified);
            PsiReferenceExpression qualifier = (PsiReferenceExpression)newReference.getQualifierExpression();
            assert (qualifier != null) : DebugUtil.psiToString((PsiElement)newReference, (boolean)true);
            qualifier.bindToElement((PsiElement)containingClass);
        });
    }

    @NotNull
    private Map<PsiReferenceExpression, PsiClass> findReplacements(@NotNull @NotNull PsiField @NotNull [] allFields, @NotNull PsiClass implementingClass, @NotNull ModPsiUpdater updater) {
        if (implementingClass == null) {
            StaticInheritanceFix.$$$reportNull$$$0(8);
        }
        if (updater == null) {
            StaticInheritanceFix.$$$reportNull$$$0(9);
        }
        if (allFields == null) {
            StaticInheritanceFix.$$$reportNull$$$0(10);
        }
        LinkedHashMap<PsiReferenceExpression, PsiClass> replacements = new LinkedHashMap<PsiReferenceExpression, PsiClass>();
        for (PsiField field : allFields) {
            SearchScope scope = implementingClass.getUseScope();
            Query search = ReferencesSearch.search((PsiElement)field, (SearchScope)scope, (boolean)false);
            for (PsiReference reference : search.asIterable()) {
                if (!(reference instanceof PsiReferenceExpression)) continue;
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)reference;
                if (!this.myReplaceInWholeProject) {
                    boolean isInheritor = false;
                    PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
                    while (aClass != null && !(isInheritor = InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)implementingClass, (boolean)true))) {
                        aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
                    }
                    if (!isInheritor) continue;
                }
                PsiClass containingClass = Objects.requireNonNull(field.getContainingClass());
                replacements.put((PsiReferenceExpression)updater.getWritable((PsiElement)referenceExpression), containingClass);
            }
        }
        LinkedHashMap<PsiReferenceExpression, PsiClass> linkedHashMap = replacements;
        if (linkedHashMap == null) {
            StaticInheritanceFix.$$$reportNull$$$0(11);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/inheritance/StaticInheritanceFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFields";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementingClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/inheritance/StaticInheritanceFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findReplacements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processUsages";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findReplacements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

