/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.MakeInitializerExplicitFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.InitializationUtils;
import org.jetbrains.annotations.NotNull;

public final class InstanceVariableInitializationInspection
extends BaseInspection {
    public boolean m_ignorePrimitives = false;

    @NotNull
    public String getID() {
        return "InstanceVariableMayNotBeInitialized";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Boolean junitTestCase = (Boolean)infos[0];
        if (junitTestCase.booleanValue()) {
            String string = InspectionGadgetsBundle.message("instance.Variable.may.not.be.initialized.problem.descriptor.junit", new Object[0]);
            if (string == null) {
                InstanceVariableInitializationInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("instance.variable.may.not.be.initialized.problem.descriptor", new Object[0]);
        if (string == null) {
            InstanceVariableInitializationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignorePrimitives", (String)InspectionGadgetsBundle.message("primitive.fields.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            InstanceVariableInitializationInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new MakeInitializerExplicitFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceVariableInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/initialization/InstanceVariableInitializationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class InstanceVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private InstanceVariableInitializationVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiType fieldType;
            if (field == null) {
                InstanceVariableInitializationVisitor.$$$reportNull$$$0(0);
            }
            if (field.hasModifierProperty("static") || field.hasModifierProperty("final")) {
                return;
            }
            if (field.getInitializer() != null) {
                return;
            }
            if (NullableNotNullManager.isNullable((PsiModifierListOwner)field)) {
                return;
            }
            if (InstanceVariableInitializationInspection.this.m_ignorePrimitives && ClassUtils.isPrimitive(fieldType = field.getType())) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (UnusedSymbolUtil.isImplicitWrite((PsiVariable)field)) {
                return;
            }
            boolean isTestClass = TestFrameworks.getInstance().isTestClass(aClass);
            if (isTestClass && InstanceVariableInitializationVisitor.isInitializedInSetup(field, aClass)) {
                return;
            }
            if (InstanceVariableInitializationVisitor.isInitializedInInitializer(field)) {
                return;
            }
            if (InitializationUtils.isInitializedInConstructors(field, aClass)) {
                return;
            }
            if (isTestClass) {
                this.registerFieldError(field, Boolean.TRUE);
            } else {
                this.registerFieldError(field, Boolean.FALSE);
            }
        }

        private static boolean isInitializedInSetup(PsiField field, PsiClass aClass) {
            PsiMethod setupMethod = TestFrameworks.getInstance().findSetUpMethod(aClass);
            return InitializationUtils.methodAssignsVariableOrFails(setupMethod, (PsiVariable)field);
        }

        private static boolean isInitializedInInitializer(@NotNull PsiField field) {
            PsiField[] fields;
            PsiClass aClass;
            if (field == null) {
                InstanceVariableInitializationVisitor.$$$reportNull$$$0(1);
            }
            if ((aClass = field.getContainingClass()) == null) {
                return false;
            }
            if (InitializationUtils.isInitializedInInitializer(field, aClass)) {
                return true;
            }
            for (PsiField otherField : fields = aClass.getFields()) {
                PsiExpression initializer;
                if (field.equals((Object)otherField) || otherField.hasModifierProperty("static") || !InitializationUtils.expressionAssignsVariableOrFails(initializer = otherField.getInitializer(), (PsiVariable)field)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "field";
            objectArray2[1] = "com/siyeh/ig/initialization/InstanceVariableInitializationInspection$InstanceVariableInitializationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInitializedInInitializer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

