/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

class NonFinalStaticVariableUsedInClassInitializationVisitor
extends BaseInspectionVisitor {
    NonFinalStaticVariableUsedInClassInitializationVisitor() {
    }

    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        if (expression == null) {
            NonFinalStaticVariableUsedInClassInitializationVisitor.$$$reportNull$$$0(0);
        }
        super.visitReferenceExpression(expression);
        PsiElement referent = expression.resolve();
        if (!(referent instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)referent;
        if (!field.hasModifierProperty("static")) {
            return;
        }
        if (field.hasModifierProperty("final")) {
            return;
        }
        if (!NonFinalStaticVariableUsedInClassInitializationVisitor.isInClassInitialization((PsiExpression)expression)) {
            return;
        }
        this.registerError((PsiElement)expression, field);
    }

    private static boolean isInClassInitialization(PsiExpression expression) {
        PsiClass expressionClass = PsiUtil.getContainingClass((PsiElement)expression);
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiClassInitializer.class, PsiField.class});
        if (member == null) {
            return false;
        }
        PsiClass memberClass = member.getContainingClass();
        if (!memberClass.equals((Object)expressionClass)) {
            return false;
        }
        if (!member.hasModifierProperty("static")) {
            return false;
        }
        if (member instanceof PsiClassInitializer) {
            return !PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/initialization/NonFinalStaticVariableUsedInClassInitializationVisitor", "visitReferenceExpression"));
    }
}

