/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class AbsoluteAlignmentInUserInterfaceInspection
extends BaseInspection {
    @NonNls
    private static final Map<String, String> gridbagConstants = Map.of("NORTHWEST", "FIRST_LINE_START", "NORTHEAST", "FIRST_LINE_END", "SOUTHWEST", "LAST_LINE_START", "SOUTHEAST", "LAST_LINE_END");
    @NonNls
    private static final Map<String, String> borderLayoutConstants = Map.of("NORTH", "PAGE_START", "SOUTH", "PAGE_END", "EAST", "LINE_END", "WEST", "LINE_START");
    @NonNls
    private static final Map<String, String> flowLayoutConstants = Map.of("LEFT", "LEADING", "RIGHT", "TRAILING");
    @NonNls
    private static final Map<String, String> scrollPaneConstants = Map.of("LOWER_LEFT_CORNER", "LOWER_LEADING_CORNER", "LOWER_RIGHT_CORNER", "LOWER_TRAILING_CORNER", "UPPER_LEFT_CORNER", "UPPER_LEADING_CORNER", "UPPER_RIGHT_CORNER", "UPPER_TRAILING_CORNER");
    @NonNls
    private static final Map<String, String> boxLayoutConstants = Map.of("X_AXIS", "LINE_AXIS", "Y_AXIS", "PAGE_AXIS");

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String className = (String)infos[0];
        String shortClassName = className.substring(className.lastIndexOf(46) + 1);
        String string = InspectionGadgetsBundle.message("absolute.alignment.in.user.interface.problem.descriptor", shortClassName);
        if (string == null) {
            AbsoluteAlignmentInUserInterfaceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new AbsoluteAlignmentInUserInterfaceFix((String)infos[0], (String)infos[1]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AbsoluteAlignmentInUserInterfaceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/AbsoluteAlignmentInUserInterfaceInspection", "buildErrorString"));
    }

    private static class AbsoluteAlignmentInUserInterfaceFix
    extends PsiUpdateModCommandQuickFix {
        private final String myClassName;
        private final String myReplacement;

        AbsoluteAlignmentInUserInterfaceFix(String className, String replacement) {
            this.myClassName = className;
            this.myReplacement = replacement;
        }

        @NotNull
        public String getName() {
            String shortClassName = this.myClassName.substring(this.myClassName.lastIndexOf(46) + 1);
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{shortClassName + "." + this.myReplacement});
            if (string == null) {
                AbsoluteAlignmentInUserInterfaceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("absolute.alignment.in.user.interface.fix.family.name", new Object[0]);
            if (string == null) {
                AbsoluteAlignmentInUserInterfaceFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                AbsoluteAlignmentInUserInterfaceFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                AbsoluteAlignmentInUserInterfaceFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                AbsoluteAlignmentInUserInterfaceFix.$$$reportNull$$$0(4);
            }
            if (!((parent = element.getParent()) instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
            PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, this.myClassName + "." + this.myReplacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/internationalization/AbsoluteAlignmentInUserInterfaceInspection$AbsoluteAlignmentInUserInterfaceFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/internationalization/AbsoluteAlignmentInUserInterfaceInspection$AbsoluteAlignmentInUserInterfaceFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class AbsoluteAlignmentInUserInterfaceVisitor
    extends BaseInspectionVisitor {
        private AbsoluteAlignmentInUserInterfaceVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            String className;
            if (expression == null) {
                AbsoluteAlignmentInUserInterfaceVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression);
            PsiElement referenceNameElement = expression.getReferenceNameElement();
            if (referenceNameElement == null) {
                return;
            }
            String referenceName = expression.getReferenceName();
            String value = gridbagConstants.get(referenceName);
            if (value != null) {
                className = AbsoluteAlignmentInUserInterfaceVisitor.checkExpression(expression, "java.awt.GridBagConstraints");
            } else {
                value = borderLayoutConstants.get(referenceName);
                if (value != null) {
                    className = AbsoluteAlignmentInUserInterfaceVisitor.checkExpression(expression, "java.awt.BorderLayout", "java.awt.GridBagConstraints");
                } else {
                    value = flowLayoutConstants.get(referenceName);
                    if (value != null) {
                        className = AbsoluteAlignmentInUserInterfaceVisitor.checkExpression(expression, "java.awt.FlowLayout");
                    } else {
                        value = scrollPaneConstants.get(referenceName);
                        if (value != null) {
                            className = AbsoluteAlignmentInUserInterfaceVisitor.checkExpression(expression, "javax.swing.ScrollPaneConstants");
                        } else {
                            value = boxLayoutConstants.get(referenceName);
                            if (value != null) {
                                className = AbsoluteAlignmentInUserInterfaceVisitor.checkExpression(expression, "javax.swing.BoxLayout");
                            } else {
                                return;
                            }
                        }
                    }
                }
            }
            if (className == null) {
                return;
            }
            this.registerError(referenceNameElement, className, value);
        }

        private static String checkExpression(PsiReferenceExpression expression, String ... classNames) {
            PsiElement target = expression.resolve();
            if (!(target instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)target;
            PsiClass containingClass = field.getContainingClass();
            for (String className : classNames) {
                if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)className)) continue;
                return className;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/internationalization/AbsoluteAlignmentInUserInterfaceInspection$AbsoluteAlignmentInUserInterfaceVisitor", "visitReferenceExpression"));
        }
    }
}

