/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.intention.AddAnnotationModCommandAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.internationalization.NonNlsUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class CallToSuspiciousStringMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.suspicious.string.method.problem.descriptor", new Object[0]);
        if (string == null) {
            CallToSuspiciousStringMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CallToSuspiciousStringMethodVisitor();
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        PsiModifierListOwner annotatableArgument;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiModifierListOwner annotatableQualifier = NonNlsUtils.getAnnotatableQualifier(methodExpression);
        if (annotatableQualifier != null) {
            LocalQuickFix fix = LocalQuickFix.from((ModCommandAction)new AddAnnotationModCommandAction("org.jetbrains.annotations.NonNls", annotatableQualifier, new String[0]));
            result.add(fix);
        }
        if ((annotatableArgument = NonNlsUtils.getAnnotatableArgument(methodCallExpression)) != null) {
            LocalQuickFix fix = LocalQuickFix.from((ModCommandAction)new AddAnnotationModCommandAction("org.jetbrains.annotations.NonNls", annotatableArgument, new String[0]));
            result.add(fix);
        }
        LocalQuickFix[] localQuickFixArray = result.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            CallToSuspiciousStringMethodInspection.$$$reportNull$$$0(1);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/internationalization/CallToSuspiciousStringMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CallToSuspiciousStringMethodVisitor
    extends BaseInspectionVisitor {
        private static final CallMatcher SUSPICIOUS_METHODS = CallMatcher.instanceCall("java.lang.String", "equals", "equalsIgnoreCase", "compareTo", "compareToIgnoreCase").parameterCount(1);
        private static final CallMatcher TRIM = CallMatcher.instanceCall("java.lang.String", "trim").parameterCount(0);

        private CallToSuspiciousStringMethodVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiExpressionList argumentList;
            PsiExpression[] arguments;
            if (expression == null) {
                CallToSuspiciousStringMethodVisitor.$$$reportNull$$$0(0);
            }
            if (SUSPICIOUS_METHODS.test(expression) ? (arguments = (argumentList = expression.getArgumentList()).getExpressions()).length != 1 || NonNlsUtils.isNonNlsAnnotated(arguments[0]) : !TRIM.test(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (NonNlsUtils.isNonNlsAnnotated(qualifier)) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/internationalization/CallToSuspiciousStringMethodInspection$CallToSuspiciousStringMethodVisitor", "visitMethodCallExpression"));
        }
    }
}

