/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class OverlyLargePrimitiveArrayInitializerInspection
extends BaseInspection {
    public int m_limit = 64;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer numElements = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("large.initializer.primitive.type.array.problem.descriptor", numElements);
        if (string == null) {
            OverlyLargePrimitiveArrayInitializerInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_limit", (String)InspectionGadgetsBundle.message("large.initializer.primitive.type.array.maximum.number.of.elements.option", new Object[0]), (int)1, (int)Integer.MAX_VALUE)});
        if (optPane == null) {
            OverlyLargePrimitiveArrayInitializerInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyLargePrimitiveArrayInitializerVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/j2me/OverlyLargePrimitiveArrayInitializerInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class OverlyLargePrimitiveArrayInitializerVisitor
    extends BaseInspectionVisitor {
        private OverlyLargePrimitiveArrayInitializerVisitor() {
        }

        public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression) {
            if (expression == null) {
                OverlyLargePrimitiveArrayInitializerVisitor.$$$reportNull$$$0(0);
            }
            super.visitArrayInitializerExpression(expression);
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            PsiType componentType = type.getDeepComponentType();
            if (!(componentType instanceof PsiPrimitiveType)) {
                return;
            }
            int numElements = this.calculateNumElements((PsiExpression)expression);
            if (numElements <= OverlyLargePrimitiveArrayInitializerInspection.this.m_limit) {
                return;
            }
            this.registerError((PsiElement)expression, numElements);
        }

        private int calculateNumElements(PsiExpression expression) {
            if (expression instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayExpression = (PsiArrayInitializerExpression)expression;
                PsiExpression[] initializers = arrayExpression.getInitializers();
                return Arrays.stream(initializers).mapToInt(this::calculateNumElements).sum();
            }
            return 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/j2me/OverlyLargePrimitiveArrayInitializerInspection$OverlyLargePrimitiveArrayInitializerVisitor", "visitArrayInitializerExpression"));
        }
    }
}

