/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class ClassWithoutConstructorInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.without.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassWithoutConstructorInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new ClassWithoutConstructorFix();
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            ClassWithoutConstructorInspection.$$$reportNull$$$0(1);
        }
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithoutConstructorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/javabeans/ClassWithoutConstructorInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/javabeans/ClassWithoutConstructorInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class ClassWithoutConstructorFix
    extends PsiUpdateModCommandQuickFix {
        private ClassWithoutConstructorFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("class.without.constructor.create.quickfix", new Object[0]);
            if (string == null) {
                ClassWithoutConstructorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement classIdentifier, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ClassWithoutConstructorFix.$$$reportNull$$$0(1);
            }
            if (classIdentifier == null) {
                ClassWithoutConstructorFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ClassWithoutConstructorFix.$$$reportNull$$$0(3);
            }
            PsiClass aClass = (PsiClass)classIdentifier.getParent();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiMethod constructor = factory.createConstructor();
            PsiModifierList modifierList = constructor.getModifierList();
            if (aClass == null) {
                return;
            }
            if (aClass.hasModifierProperty("private")) {
                modifierList.setModifierProperty("public", false);
                modifierList.setModifierProperty("private", true);
            } else if (aClass.hasModifierProperty("protected")) {
                modifierList.setModifierProperty("public", false);
                modifierList.setModifierProperty("protected", true);
            } else if (aClass.hasModifierProperty("abstract")) {
                modifierList.setModifierProperty("public", false);
                modifierList.setModifierProperty("protected", true);
            } else if (!aClass.hasModifierProperty("public")) {
                modifierList.setModifierProperty("public", false);
            }
            aClass.add((PsiElement)constructor);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
            styleManager.reformat((PsiElement)constructor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/javabeans/ClassWithoutConstructorInspection$ClassWithoutConstructorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classIdentifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/javabeans/ClassWithoutConstructorInspection$ClassWithoutConstructorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ClassWithoutConstructorVisitor
    extends BaseInspectionVisitor {
        private ClassWithoutConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ClassWithoutConstructorVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
                return;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length > 0) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/javabeans/ClassWithoutConstructorInspection$ClassWithoutConstructorVisitor", "visitClass"));
        }
    }
}

