/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class ClassWithoutNoArgConstructorInspection
extends BaseInspection {
    public boolean m_ignoreClassesWithNoConstructors = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreClassesWithNoConstructors", (String)InspectionGadgetsBundle.message("class.without.no.arg.constructor.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ClassWithoutNoArgConstructorInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.without.no.arg.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassWithoutNoArgConstructorInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithoutNoArgConstructorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javabeans/ClassWithoutNoArgConstructorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ClassWithoutNoArgConstructorVisitor
    extends BaseInspectionVisitor {
        private ClassWithoutNoArgConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ClassWithoutNoArgConstructorVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isRecord()) {
                return;
            }
            if (aClass instanceof PsiAnonymousClass || aClass instanceof PsiTypeParameter) {
                return;
            }
            if (ClassWithoutNoArgConstructorVisitor.classHasNoArgConstructor(aClass, ClassWithoutNoArgConstructorInspection.this.m_ignoreClassesWithNoConstructors)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private static boolean classHasNoArgConstructor(PsiClass aClass, boolean ignoreNoConstructor) {
            Object[] constructors = aClass.getConstructors();
            if (ignoreNoConstructor && constructors.length == 0) {
                return true;
            }
            return ContainerUtil.exists((Object[])constructors, c -> c.getParameterList().isEmpty());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/javabeans/ClassWithoutNoArgConstructorInspection$ClassWithoutNoArgConstructorVisitor", "visitClass"));
        }
    }
}

