/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class DanglingJavadocInspection
extends BaseInspection {
    public boolean ignoreCopyright = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("dangling.javadoc.problem.descriptor", new Object[0]);
        if (string == null) {
            DanglingJavadocInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreCopyright", (String)InspectionGadgetsBundle.message("dangling.javadoc.ignore.copyright.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            DanglingJavadocInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        boolean markdownComment = (Boolean)infos[0];
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new DeleteCommentFix(), new ConvertCommentFix(markdownComment)};
        if (localQuickFixArray == null) {
            DanglingJavadocInspection.$$$reportNull$$$0(2);
        }
        return localQuickFixArray;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new DanglingJavadocVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javadoc/DanglingJavadocInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DeleteCommentFix
    extends PsiUpdateModCommandQuickFix {
        private DeleteCommentFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("dangling.javadoc.delete.quickfix", new Object[0]);
            if (string == null) {
                DeleteCommentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                DeleteCommentFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                DeleteCommentFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                DeleteCommentFix.$$$reportNull$$$0(3);
            }
            element.getParent().delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/javadoc/DanglingJavadocInspection$DeleteCommentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/javadoc/DanglingJavadocInspection$DeleteCommentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ConvertCommentFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myMarkdownComment;

        ConvertCommentFix(boolean markdownComment) {
            this.myMarkdownComment = markdownComment;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.myMarkdownComment ? InspectionGadgetsBundle.message("dangling.javadoc.convert.line.comment.quickfix", new Object[0]) : InspectionGadgetsBundle.message("dangling.javadoc.convert.quickfix", new Object[0]);
            if (string == null) {
                ConvertCommentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                ConvertCommentFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ConvertCommentFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ConvertCommentFix.$$$reportNull$$$0(3);
            }
            if (!((parent = element.getParent()) instanceof PsiDocComment)) {
                return;
            }
            PsiDocComment docComment = (PsiDocComment)parent;
            boolean markdownComment = docComment.isMarkdownComment();
            StringBuilder newCommentText = new StringBuilder();
            for (PsiElement child = docComment.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof PsiDocToken) {
                    PsiDocToken docToken = (PsiDocToken)child;
                    IElementType tokenType = docToken.getTokenType();
                    if (JavaDocTokenType.DOC_COMMENT_START.equals(tokenType)) {
                        newCommentText.append("/*");
                        continue;
                    }
                    if (!JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS.equals(tokenType)) {
                        newCommentText.append(child.getText());
                        continue;
                    }
                    if (!markdownComment) continue;
                    newCommentText.append("//");
                    continue;
                }
                newCommentText.append(child.getText());
            }
            Document document = element.getContainingFile().getFileDocument();
            TextRange range = docComment.getTextRange();
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newCommentText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/javadoc/DanglingJavadocInspection$ConvertCommentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/javadoc/DanglingJavadocInspection$ConvertCommentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class DanglingJavadocVisitor
    extends BaseInspectionVisitor {
        private DanglingJavadocVisitor() {
        }

        public void visitDocComment(@NotNull PsiDocComment comment) {
            if (comment == null) {
                DanglingJavadocVisitor.$$$reportNull$$$0(0);
            }
            super.visitDocComment(comment);
            if (JavaDocUtil.shouldRunInspectionOnOldMarkdownComment((PsiDocComment)comment) && JavaDocUtil.isDanglingDocComment((PsiDocComment)comment, (boolean)DanglingJavadocInspection.this.ignoreCopyright)) {
                this.registerError(comment.getFirstChild(), comment.isMarkdownComment());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/siyeh/ig/javadoc/DanglingJavadocInspection$DanglingJavadocVisitor", "visitDocComment"));
        }
    }
}

