/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryInheritDocInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = switch (((WarningType)((Object)infos[0])).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> InspectionGadgetsBundle.message("unnecessary.inherit.doc.module.invalid.problem.descriptor", new Object[0]);
            case 1 -> InspectionGadgetsBundle.message("unnecessary.inherit.doc.class.invalid.problem.descriptor", new Object[0]);
            case 2 -> InspectionGadgetsBundle.message("unnecessary.inherit.doc.field.invalid.problem.descriptor", new Object[0]);
            case 3 -> InspectionGadgetsBundle.message("unnecessary.inherit.doc.constructor.invalid.problem.descriptor", new Object[0]);
            case 5 -> InspectionGadgetsBundle.message("unnecessary.inherit.doc.constructor.no.super.problem.descriptor", new Object[0]);
            case 4 -> InspectionGadgetsBundle.message("unnecessary.inherit.doc.problem.descriptor", new Object[0]);
        };
        if (string == null) {
            UnnecessaryInheritDocInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessaryInheritDocFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryInheritDocVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/UnnecessaryInheritDocInspection", "buildErrorString"));
    }

    static enum WarningType {
        MODULE,
        CLASS,
        FIELD,
        CONSTRUCTOR,
        EMPTY,
        NO_SUPER;

    }

    private static class UnnecessaryInheritDocFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessaryInheritDocFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.inherit.doc.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryInheritDocFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnnecessaryInheritDocFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                UnnecessaryInheritDocFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessaryInheritDocFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiDocTag)) {
                return;
            }
            PsiDocTag docTag = (PsiDocTag)element;
            PsiElement parent = docTag.getParent();
            if (parent instanceof PsiDocComment) {
                PsiDocComment docComment = (PsiDocComment)parent;
                PsiDocTag[] docTags = docComment.getTags();
                if (docTags.length > 0) {
                    element.delete();
                    return;
                }
                PsiDocToken[] docTokens = (PsiDocToken[])PsiTreeUtil.getChildrenOfType((PsiElement)parent, PsiDocToken.class);
                if (docTokens != null) {
                    for (PsiDocToken docToken : docTokens) {
                        IElementType tokenType = docToken.getTokenType();
                        if (!JavaDocTokenType.DOC_COMMENT_DATA.equals(tokenType) || StringUtil.isEmptyOrSpaces((String)docToken.getText())) continue;
                        element.delete();
                        return;
                    }
                }
            }
            parent.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/javadoc/UnnecessaryInheritDocInspection$UnnecessaryInheritDocFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/javadoc/UnnecessaryInheritDocInspection$UnnecessaryInheritDocFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UnnecessaryInheritDocVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryInheritDocVisitor() {
        }

        public void visitInlineDocTag(@NotNull PsiInlineDocTag tag) {
            PsiDocTag docTag;
            String docTagName;
            String name;
            if (tag == null) {
                UnnecessaryInheritDocVisitor.$$$reportNull$$$0(0);
            }
            if (!"inheritDoc".equals(name = tag.getName())) {
                return;
            }
            PsiDocComment docComment = tag.getContainingComment();
            if (docComment == null) {
                return;
            }
            PsiJavaDocumentedElement owner = docComment.getOwner();
            if (owner instanceof PsiJavaModule) {
                this.registerError((PsiElement)tag, new Object[]{WarningType.MODULE});
                return;
            }
            if (owner instanceof PsiField) {
                this.registerError((PsiElement)tag, new Object[]{WarningType.FIELD});
                return;
            }
            if (owner instanceof PsiClass) {
                this.registerError((PsiElement)tag, new Object[]{WarningType.CLASS});
                return;
            }
            if (owner instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)owner;
                if (method.isConstructor()) {
                    this.registerError((PsiElement)tag, new Object[]{WarningType.CONSTRUCTOR});
                    return;
                }
                if (!MethodUtils.hasSuper(method)) {
                    this.registerError((PsiElement)tag, new Object[]{WarningType.NO_SUPER});
                    return;
                }
            } else {
                return;
            }
            PsiElement parent = tag.getParent();
            if (parent instanceof PsiDocTag && ((docTagName = (docTag = (PsiDocTag)parent).getName()).equals("throws") || docTagName.equals("exception")) && !UnnecessaryInheritDocVisitor.isCheckExceptionAndPresentInThrowsList((PsiMethod)owner, docTag)) {
                return;
            }
            PsiDocToken[] docTokens = (PsiDocToken[])PsiTreeUtil.getChildrenOfType((PsiElement)parent, PsiDocToken.class);
            if (docTokens == null) {
                return;
            }
            for (PsiDocToken docToken : docTokens) {
                IElementType tokenType = docToken.getTokenType();
                if (!JavaDocTokenType.DOC_COMMENT_DATA.equals(tokenType) || StringUtil.isEmptyOrSpaces((String)docToken.getText())) continue;
                return;
            }
            this.registerError((PsiElement)tag, new Object[]{WarningType.EMPTY});
        }

        private static boolean isCheckExceptionAndPresentInThrowsList(PsiMethod method, PsiDocTag docTag) {
            PsiDocTagValue valueElement = docTag.getValueElement();
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.findChildOfType((PsiElement)valueElement, PsiJavaCodeReferenceElement.class);
            if (referenceElement != null) {
                PsiElement target = referenceElement.resolve();
                if (!(target instanceof PsiClass)) {
                    return false;
                }
                PsiClass aClass = (PsiClass)target;
                if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Exception") || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.RuntimeException")) {
                    return false;
                }
                PsiReferenceList throwsList = method.getThrowsList();
                PsiJavaCodeReferenceElement[] elements = throwsList.getReferenceElements();
                boolean found = false;
                for (PsiJavaCodeReferenceElement element : elements) {
                    if (!target.equals((Object)element.resolve())) continue;
                    found = true;
                }
                if (!found) {
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/siyeh/ig/javadoc/UnnecessaryInheritDocInspection$UnnecessaryInheritDocVisitor", "visitInlineDocTag"));
        }
    }
}

