/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class AutoBoxingInspection
extends BaseInspection {
    public boolean ignoreAddedToCollection = false;
    @NonNls
    static final Map<String, String> s_boxingClasses = Map.of("byte", "java.lang.Byte", "short", "java.lang.Short", "int", "java.lang.Integer", "long", "java.lang.Long", "float", "java.lang.Float", "double", "java.lang.Double", "boolean", "java.lang.Boolean", "char", "java.lang.Character");

    public String getAlternativeID() {
        return "boxing";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("auto.boxing.problem.descriptor", new Object[0]);
        if (string == null) {
            AutoBoxingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreAddedToCollection", (String)InspectionGadgetsBundle.message("auto.boxing.ignore.added.to.collection.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            AutoBoxingInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            AutoBoxingInspection.$$$reportNull$$$0(2);
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AutoBoxingVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        if (infos.length == 0) {
            return null;
        }
        return new AutoBoxingFix();
    }

    public static void replaceWithBoxing(@NotNull PsiExpression expression) {
        Object newExpression;
        String classToConstruct;
        PsiType type;
        if (expression == null) {
            AutoBoxingInspection.$$$reportNull$$$0(3);
        }
        if (!((type = expression.getType()) instanceof PsiPrimitiveType)) {
            return;
        }
        PsiClassType expectedType = ((PsiPrimitiveType)type).getBoxedType((PsiElement)expression);
        if (expectedType == null) {
            return;
        }
        String expectedTypeText = expectedType.getCanonicalText();
        if (s_boxingClasses.containsValue(expectedTypeText)) {
            classToConstruct = expectedTypeText;
        } else {
            String expressionTypeText = type.getCanonicalText();
            classToConstruct = s_boxingClasses.get(expressionTypeText);
        }
        if (AutoBoxingInspection.shortcutReplace(expression, classToConstruct)) {
            return;
        }
        PsiExpression strippedExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        if (strippedExpression == null) {
            return;
        }
        CommentTracker commentTracker = new CommentTracker();
        @NonNls String expressionText = strippedExpression.getText();
        if ("true".equals(expressionText)) {
            newExpression = "java.lang.Boolean.TRUE";
        } else if ("false".equals(expressionText)) {
            newExpression = "java.lang.Boolean.FALSE";
        } else {
            commentTracker.markUnchanged(strippedExpression);
            newExpression = classToConstruct + ".valueOf(" + expressionText + ")";
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            PsiReplacementUtil.replaceExpression((PsiExpression)typeCastExpression, (String)newExpression, commentTracker);
        } else {
            PsiReplacementUtil.replaceExpression(expression, (String)newExpression, commentTracker);
        }
    }

    private static boolean shortcutReplace(PsiExpression expression, String classToConstruct) {
        boolean shouldReplace;
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (qualifierExpression == null) {
            return false;
        }
        switch (classToConstruct) {
            case "java.lang.Integer": {
                boolean bl = MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Integer", (PsiType)PsiTypes.intType(), "intValue", new PsiType[0]);
                break;
            }
            case "java.lang.Short": {
                boolean bl = MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Short", (PsiType)PsiTypes.shortType(), "shortValue", new PsiType[0]);
                break;
            }
            case "java.lang.Byte": {
                boolean bl = MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Byte", (PsiType)PsiTypes.byteType(), "byteValue", new PsiType[0]);
                break;
            }
            case "java.lang.Character": {
                boolean bl = MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Character", (PsiType)PsiTypes.charType(), "charValue", new PsiType[0]);
                break;
            }
            case "java.lang.Long": {
                boolean bl = MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Long", (PsiType)PsiTypes.longType(), "longValue", new PsiType[0]);
                break;
            }
            case "java.lang.Float": {
                boolean bl = MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Float", (PsiType)PsiTypes.floatType(), "floatValue", new PsiType[0]);
                break;
            }
            case "java.lang.Double": {
                boolean bl = MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Double", (PsiType)PsiTypes.doubleType(), "doubleValue", new PsiType[0]);
                break;
            }
            default: {
                boolean bl = shouldReplace = false;
            }
        }
        if (shouldReplace) {
            expression.replace((PsiElement)qualifierExpression);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/jdk/AutoBoxingInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/jdk/AutoBoxingInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithBoxing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private class AutoBoxingVisitor
    extends BaseInspectionVisitor {
        private AutoBoxingVisitor() {
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                AutoBoxingVisitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
            if (expression == null) {
                AutoBoxingVisitor.$$$reportNull$$$0(1);
            }
            super.visitArrayAccessExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                AutoBoxingVisitor.$$$reportNull$$$0(2);
            }
            super.visitAssignmentExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            if (expression == null) {
                AutoBoxingVisitor.$$$reportNull$$$0(3);
            }
            super.visitConditionalExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
            if (expression == null) {
                AutoBoxingVisitor.$$$reportNull$$$0(4);
            }
            super.visitInstanceOfExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                AutoBoxingVisitor.$$$reportNull$$$0(5);
            }
            super.visitLiteralExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                AutoBoxingVisitor.$$$reportNull$$$0(6);
            }
            super.visitMethodCallExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
            if (expression == null) {
                AutoBoxingVisitor.$$$reportNull$$$0(7);
            }
            super.visitParenthesizedExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                AutoBoxingVisitor.$$$reportNull$$$0(8);
            }
            super.visitPolyadicExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
            if (expression == null) {
                AutoBoxingVisitor.$$$reportNull$$$0(9);
            }
            super.visitUnaryExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                AutoBoxingVisitor.$$$reportNull$$$0(10);
            }
            super.visitReferenceExpression(expression);
            if (expression instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)expression;
                if (methodReferenceExpression.isConstructor()) {
                    return;
                }
                PsiElement referenceNameElement = methodReferenceExpression.getReferenceNameElement();
                if (referenceNameElement == null) {
                    return;
                }
                PsiElement target = methodReferenceExpression.resolve();
                if (!(target instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)target;
                PsiType returnType = method.getReturnType();
                if (returnType == null || returnType.equals(PsiTypes.voidType()) || !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)returnType)) {
                    return;
                }
                PsiPrimitiveType primitiveType = (PsiPrimitiveType)returnType;
                PsiClassType boxedType = primitiveType.getBoxedType((PsiElement)expression);
                if (boxedType == null) {
                    return;
                }
                PsiType functionalInterfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)methodReferenceExpression);
                if (functionalInterfaceReturnType == null || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)functionalInterfaceReturnType) || !functionalInterfaceReturnType.isAssignableFrom((PsiType)boxedType)) {
                    return;
                }
                this.registerError(referenceNameElement, new Object[0]);
            } else {
                this.checkExpression((PsiExpression)expression);
            }
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                AutoBoxingVisitor.$$$reportNull$$$0(11);
            }
            super.visitTypeCastExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        private void checkExpression(@NotNull PsiExpression expression) {
            if (expression == null) {
                AutoBoxingVisitor.$$$reportNull$$$0(12);
            }
            if (!ExpressionUtils.isAutoBoxed(expression)) {
                return;
            }
            if (AutoBoxingInspection.this.ignoreAddedToCollection && AutoBoxingVisitor.isAddedToCollection(expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private static boolean isAddedToCollection(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            PsiElement grandParent = expressionList.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if (!("put".equals(methodName) || "set".equals(methodName) || "add".equals(methodName))) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.Collection", "java.util.Map") != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/jdk/AutoBoxingInspection$AutoBoxingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayAccessExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitConditionalExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInstanceOfExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLiteralExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParenthesizedExpression";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeCastExpression";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AutoBoxingFix
    extends PsiUpdateModCommandQuickFix {
        private AutoBoxingFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("auto.boxing.make.boxing.explicit.quickfix", new Object[0]);
            if (string == null) {
                AutoBoxingFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                AutoBoxingFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                AutoBoxingFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AutoBoxingFix.$$$reportNull$$$0(3);
            }
            PsiExpression expression = (PsiExpression)element;
            AutoBoxingInspection.replaceWithBoxing(expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/jdk/AutoBoxingInspection$AutoBoxingFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/jdk/AutoBoxingInspection$AutoBoxingFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

