/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class UseOfObsoleteDateTimeApiInspection
extends BaseInspection {
    static final Set<String> dateTimeNames = Set.of("java.util.Date", "java.util.Calendar", "java.util.GregorianCalendar", "java.util.TimeZone", "java.util.SimpleTimeZone");

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.of.obsolete.date.time.api.problem.descriptor", new Object[0]);
        if (string == null) {
            UseOfObsoleteDateTimeApiInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ObsoleteDateTimeApiVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/UseOfObsoleteDateTimeApiInspection", "buildErrorString"));
    }

    private static class ObsoleteDateTimeApiVisitor
    extends BaseInspectionVisitor {
        private Boolean newDateTimeApiPresent = null;

        private ObsoleteDateTimeApiVisitor() {
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement referenceElement) {
            PsiParameter parameter;
            PsiMethod method;
            PsiElement parent;
            if (referenceElement == null) {
                ObsoleteDateTimeApiVisitor.$$$reportNull$$$0(0);
            }
            if (!this.isNewDateTimeApiPresent((PsiElement)referenceElement)) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiImportStatementBase.class) != null) {
                return;
            }
            super.visitReferenceElement(referenceElement);
            PsiElement target = referenceElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass targetClass = (PsiClass)target;
            String qualifiedName = targetClass.getQualifiedName();
            if (qualifiedName == null || !dateTimeNames.contains(qualifiedName)) {
                return;
            }
            PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)referenceElement, PsiTypeElement.class);
            if (typeElement != null && ((parent = typeElement.getParent()) instanceof PsiMethod ? LibraryUtil.isOverrideOfLibraryMethod(method = (PsiMethod)parent) : parent instanceof PsiParameter && LibraryUtil.isOverrideOfLibraryMethodParameter((PsiVariable)(parameter = (PsiParameter)parent)))) {
                return;
            }
            this.registerError((PsiElement)referenceElement, new Object[0]);
        }

        private boolean isNewDateTimeApiPresent(PsiElement context) {
            if (this.newDateTimeApiPresent == null) {
                this.newDateTimeApiPresent = ClassUtils.findClass("java.time.Instant", context) != null;
            }
            return this.newDateTimeApiPresent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceElement", "com/siyeh/ig/maturity/UseOfObsoleteDateTimeApiInspection$ObsoleteDateTimeApiVisitor", "visitReferenceElement"));
        }
    }
}

