/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class InnerClassReferenceVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final PsiClass innerClass;
    private final boolean allowReferencesToLocalVariables;
    private boolean referencesStaticallyAccessible;

    public InnerClassReferenceVisitor(@NotNull PsiClass innerClass) {
        if (innerClass == null) {
            InnerClassReferenceVisitor.$$$reportNull$$$0(0);
        }
        this(innerClass, false);
    }

    public InnerClassReferenceVisitor(@NotNull PsiClass innerClass, boolean allowReferencesToLocalVariables) {
        if (innerClass == null) {
            InnerClassReferenceVisitor.$$$reportNull$$$0(1);
        }
        this.referencesStaticallyAccessible = true;
        this.innerClass = innerClass;
        this.allowReferencesToLocalVariables = allowReferencesToLocalVariables;
    }

    public boolean canInnerClassBeStatic() {
        PsiClass superClass = this.innerClass.getSuperClass();
        if (superClass != null && !this.isClassStaticallyAccessible(superClass)) {
            return false;
        }
        return this.referencesStaticallyAccessible;
    }

    private boolean isClassStaticallyAccessible(@NotNull PsiClass aClass) {
        if (aClass == null) {
            InnerClassReferenceVisitor.$$$reportNull$$$0(2);
        }
        if (PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)aClass, (boolean)false) || aClass.hasModifierProperty("static")) {
            return true;
        }
        if (aClass instanceof PsiTypeParameter) {
            PsiTypeParameter parameter = (PsiTypeParameter)aClass;
            PsiTypeParameterListOwner owner = parameter.getOwner();
            return owner != null && PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)owner, (boolean)false);
        }
        PsiClass containingClass = aClass.getContainingClass();
        return containingClass == null || InheritanceUtil.isInheritorOrSelf((PsiClass)this.innerClass, (PsiClass)containingClass, (boolean)true);
    }

    public void visitThisExpression(@NotNull PsiThisExpression expression) {
        if (expression == null) {
            InnerClassReferenceVisitor.$$$reportNull$$$0(3);
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitThisExpression(expression);
        if (this.hasContainingClassQualifier((PsiQualifiedExpression)expression)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
        if (expression == null) {
            InnerClassReferenceVisitor.$$$reportNull$$$0(4);
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitSuperExpression(expression);
        if (this.hasContainingClassQualifier((PsiQualifiedExpression)expression)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    private boolean hasContainingClassQualifier(PsiQualifiedExpression expression) {
        PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
        return qualifier != null && !this.innerClass.equals((Object)qualifier.resolve());
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement expression) {
        PsiClass aClass;
        if (expression == null) {
            InnerClassReferenceVisitor.$$$reportNull$$$0(5);
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitReferenceElement(expression);
        if (expression.isQualified()) {
            return;
        }
        PsiElement target = expression.resolve();
        if (target == null) {
            this.referencesStaticallyAccessible = false;
            return;
        }
        if ((target instanceof PsiLocalVariable || target instanceof PsiParameter) && !this.allowReferencesToLocalVariables && !PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)target, (boolean)true)) {
            this.referencesStaticallyAccessible = false;
            return;
        }
        if (target instanceof PsiMethod || target instanceof PsiField) {
            PsiMember member = (PsiMember)target;
            if (member.hasModifierProperty("static") || PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)member, (boolean)true)) {
                return;
            }
            if (!member.hasModifierProperty("private")) {
                PsiClass containingClass = member.getContainingClass();
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)this.innerClass, (PsiClass)containingClass, (boolean)true)) {
                    return;
                }
                PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
                while (parentClass != null && PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)parentClass, (boolean)true)) {
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)containingClass, (boolean)true)) {
                        return;
                    }
                    parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, (boolean)true);
                }
            }
            this.referencesStaticallyAccessible = false;
        } else if (target instanceof PsiClass && !this.isClassStaticallyAccessible(aClass = (PsiClass)target)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    public void visitNewExpression(@NotNull PsiNewExpression expression) {
        PsiClass aClass;
        if (expression == null) {
            InnerClassReferenceVisitor.$$$reportNull$$$0(6);
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitNewExpression(expression);
        PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
        if (classReference == null) {
            return;
        }
        PsiElement target = classReference.resolve();
        if (target instanceof PsiClass && !this.isClassStaticallyAccessible(aClass = (PsiClass)target)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    public void visitTypeElement(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            InnerClassReferenceVisitor.$$$reportNull$$$0(7);
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitTypeElement(typeElement);
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)typeElement.getType());
        if (aClass instanceof PsiTypeParameter && !PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)aClass, (boolean)true)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/memory/InnerClassReferenceVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassStaticallyAccessible";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThisExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSuperExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNewExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

