/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.LoopCountVisitor;
import org.jetbrains.annotations.NotNull;

public final class MethodWithMultipleLoopsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer negationCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("method.with.multiple.loops.problem.descriptor", negationCount);
        if (string == null) {
            MethodWithMultipleLoopsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MethodWithMultipleLoopsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/MethodWithMultipleLoopsInspection", "buildErrorString"));
    }

    private static class MethodWithMultipleLoopsVisitor
    extends BaseInspectionVisitor {
        private MethodWithMultipleLoopsVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MethodWithMultipleLoopsVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            LoopCountVisitor visitor2 = new LoopCountVisitor();
            method.accept((PsiElementVisitor)visitor2);
            int loopsCount = visitor2.getCount();
            if (loopsCount <= 1) {
                return;
            }
            this.registerMethodError(method, loopsCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/MethodWithMultipleLoopsInspection$MethodWithMultipleLoopsVisitor", "visitMethod"));
        }
    }
}

