/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.NCSSVisitor;
import org.jetbrains.annotations.NotNull;

public final class OverlyLongLambdaInspection
extends MethodMetricInspection {
    private static final int DEFAULT_LIMIT = 3;

    @Override
    protected int getDefaultLimit() {
        return 3;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("non.comment.source.statements.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer statementCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("overly.long.lambda.problem.descriptor", statementCount);
        if (string == null) {
            OverlyLongLambdaInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyLongLambdaVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/OverlyLongLambdaInspection", "buildErrorString"));
    }

    private class OverlyLongLambdaVisitor
    extends BaseInspectionVisitor {
        private OverlyLongLambdaVisitor() {
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            PsiElement body;
            if (expression == null) {
                OverlyLongLambdaVisitor.$$$reportNull$$$0(0);
            }
            if (!((body = expression.getBody()) instanceof PsiCodeBlock)) {
                return;
            }
            PsiCodeBlock block = (PsiCodeBlock)body;
            PsiJavaToken brace = block.getLBrace();
            if (brace == null) {
                return;
            }
            NCSSVisitor visitor2 = new NCSSVisitor();
            block.accept((PsiElementVisitor)visitor2);
            int count = visitor2.getStatementCount();
            if (count <= OverlyLongLambdaInspection.this.getLimit()) {
                return;
            }
            this.registerErrorAtOffset((PsiElement)expression, 0, body.getStartOffsetInParent() + 1, count);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/methodmetrics/OverlyLongLambdaInspection$OverlyLongLambdaVisitor", "visitLambdaExpression"));
        }
    }
}

