/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayDeque;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.NodeFilter;

@ApiStatus.Internal
public final class MarkdownDocumentationCommentsMigrationInspection
extends BaseInspection
implements DumbAware {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("markdown.documentation.comments.migration.display.name", new Object[0]);
        if (string == null) {
            MarkdownDocumentationCommentsMigrationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected LocalQuickFix buildFix(Object ... infos) {
        return new MarkdownDocumentationCommentsMigrationFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MarkdownDocumentationCommentsMigrationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/MarkdownDocumentationCommentsMigrationInspection", "buildErrorString"));
    }

    private static class MarkdownDocumentationCommentsMigrationFix
    extends PsiUpdateModCommandQuickFix
    implements DumbAware {
        private static final TokenSet SKIP_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JavaDocTokenType.DOC_COMMENT_START, JavaDocTokenType.DOC_COMMENT_END, JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS});

        private MarkdownDocumentationCommentsMigrationFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("markdown.documentation.comments.migration.fix", new Object[0]);
            if (string == null) {
                MarkdownDocumentationCommentsMigrationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            int n;
            if (project == null) {
                MarkdownDocumentationCommentsMigrationFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                MarkdownDocumentationCommentsMigrationFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MarkdownDocumentationCommentsMigrationFix.$$$reportNull$$$0(3);
            }
            if (element instanceof PsiDocToken) {
                element = element.getParent();
            }
            if (!(element instanceof PsiDocComment)) {
                return;
            }
            String markdown = MarkdownDocumentationCommentsMigrationFix.convertToMarkdown(MarkdownDocumentationCommentsMigrationFix.appendElementText(element, new StringBuilder()).toString());
            String indent = MarkdownDocumentationCommentsMigrationFix.getElementIndent(element);
            String[] lines = markdown.split("\n");
            StringBuilder result = new StringBuilder(markdown.length() + (indent.length() + 4) * lines.length);
            for (String line : lines) {
                if (!result.isEmpty()) {
                    result.append(indent);
                }
                boolean isBlank = line.isBlank();
                result.append(line.startsWith(" ") || isBlank ? "///" : "/// ");
                if (!isBlank) {
                    result.append(line);
                }
                result.append('\n');
            }
            result.append(indent);
            Document document = element.getContainingFile().getFileDocument();
            int startOffset = element.getTextOffset();
            PsiElement psiElement = element.getNextSibling();
            if (psiElement instanceof PsiWhiteSpace) {
                PsiWhiteSpace whiteSpace = (PsiWhiteSpace)psiElement;
                n = whiteSpace.getTextOffset() + whiteSpace.getTextLength();
            } else {
                n = startOffset + element.getTextLength();
            }
            int endOffset = n;
            document.replaceString(startOffset, endOffset, (CharSequence)result);
        }

        private static StringBuilder appendElementText(@NotNull PsiElement element, StringBuilder result) {
            if (element == null) {
                MarkdownDocumentationCommentsMigrationFix.$$$reportNull$$$0(4);
            }
            for (PsiElement child : element.getChildren()) {
                if (PsiDocToken.isDocToken((PsiElement)child, (TokenSet)SKIP_TOKENS)) continue;
                if (child instanceof PsiInlineDocTag) {
                    String name;
                    PsiInlineDocTag inlineDocTag = (PsiInlineDocTag)child;
                    PsiElement next = inlineDocTag.getNameElement().getNextSibling();
                    if (next instanceof PsiWhiteSpace && next.getText().contains("\n") && !Strings.endsWith((CharSequence)result, (CharSequence)"<pre>")) {
                        result.append("\n ");
                    }
                    if ("code".equals(name = inlineDocTag.getName())) {
                        MarkdownDocumentationCommentsMigrationFix.handleCode(inlineDocTag, result);
                        continue;
                    }
                    if ("link".equals(name) || "linkplain".equals(name)) {
                        MarkdownDocumentationCommentsMigrationFix.handleLink(inlineDocTag, result);
                        continue;
                    }
                    MarkdownDocumentationCommentsMigrationFix.handleInlineDocTag((PsiElement)inlineDocTag, result);
                    continue;
                }
                if (child instanceof PsiDocParamRef) {
                    result.append(MarkdownDocumentationCommentsMigrationFix.escapeInline(child.getText()));
                    continue;
                }
                if (child instanceof PsiDocTag) {
                    result.append("<%s>".formatted("jbr-internal-jdoc"));
                    MarkdownDocumentationCommentsMigrationFix.appendElementText(child, result);
                    result.append("</%s>".formatted("jbr-internal-jdoc"));
                    continue;
                }
                if (child instanceof PsiDocTagValue) {
                    MarkdownDocumentationCommentsMigrationFix.appendElementText(child, result);
                    continue;
                }
                if (child instanceof PsiWhiteSpace) {
                    if (PsiDocToken.isDocToken((PsiElement)child.getNextSibling(), (IElementType)JavaDocTokenType.DOC_COMMENT_END)) continue;
                    String text = child.getText();
                    if (text.contains("\n")) {
                        if (result.isEmpty()) continue;
                        result.append("\n");
                        continue;
                    }
                    result.append(text);
                    continue;
                }
                result.append(child.getText());
            }
            return result;
        }

        private static String escapeInline(String text) {
            return "<%s>%s</%s>".formatted("jbr-internal-inline", StringUtil.escapeXmlEntities((String)text), "jbr-internal-inline");
        }

        private static String convertToMarkdown(@NlsSafe String html) {
            @NonNls String escape = "\\nbsp;";
            Element body = Jsoup.parse((String)html.replace("&nbsp;", escape)).outputSettings(new Document.OutputSettings().prettyPrint(false)).body();
            HtmlToMarkdownVisitor visitor2 = new HtmlToMarkdownVisitor(html.length());
            body.filter((NodeFilter)visitor2);
            return visitor2.getResult().replace(escape, "&nbsp;");
        }

        private static String getElementIndent(PsiElement element) {
            PsiElement leaf = PsiTreeUtil.prevLeaf((PsiElement)element);
            if (!(leaf instanceof PsiWhiteSpace)) {
                return "";
            }
            String text = leaf.getText();
            int lineBreak = text.lastIndexOf(10);
            return text.substring(lineBreak + 1);
        }

        private static void handleInlineDocTag(PsiElement element, StringBuilder result) {
            PsiElement[] children = element.getChildren();
            if (children.length > 0) {
                for (PsiElement child : children) {
                    MarkdownDocumentationCommentsMigrationFix.handleInlineDocTag(child, result);
                }
            } else if (element instanceof PsiWhiteSpace) {
                String text = element.getText();
                if (text.contains("\n")) {
                    result.append("\n ");
                } else {
                    result.append(text);
                }
            } else if (!PsiDocToken.isDocToken((PsiElement)element, (IElementType)JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS)) {
                result.append(element.getText());
            }
        }

        private static void handleCode(PsiInlineDocTag inlineDocTag, StringBuilder result) {
            StringBuilder codeBuilder = new StringBuilder();
            for (PsiElement dataElement : inlineDocTag.getDataElements()) {
                PsiWhiteSpace whiteSpace;
                if (!(dataElement instanceof PsiDocToken)) continue;
                codeBuilder.append(dataElement.getText());
                PsiElement psiElement = dataElement.getNextSibling();
                if (!(psiElement instanceof PsiWhiteSpace) || !(whiteSpace = (PsiWhiteSpace)psiElement).getText().contains("\n")) continue;
                codeBuilder.append("\n");
            }
            result.append("<code>").append(MarkdownDocumentationCommentsMigrationFix.escapeInline(codeBuilder.toString().trim().replace("\\", "\\\\"))).append("</code>");
        }

        private static void handleLink(PsiInlineDocTag inlineDocTag, StringBuilder result) {
            boolean isPlain = inlineDocTag.getName().equals("linkplain");
            PsiElement[] dataElements = inlineDocTag.getDataElements();
            StringBuilder referenceBuilder = new StringBuilder();
            StringBuilder labelBuilder = null;
            for (PsiElement dataElement : dataElements) {
                if (!(dataElement instanceof PsiDocToken)) continue;
                String labelText = dataElement.getText();
                if (labelBuilder == null) {
                    labelText = labelText.stripLeading();
                }
                if (labelText.isBlank()) continue;
                if (labelBuilder == null) {
                    labelBuilder = new StringBuilder();
                }
                labelBuilder.append(labelText);
            }
            for (PsiElement dataElement : dataElements) {
                if (dataElement instanceof PsiDocMethodOrFieldRef) {
                    for (PsiElement refChild : dataElement.getChildren()) {
                        if (refChild instanceof PsiDocToken) {
                            referenceBuilder.append(refChild.getText());
                            continue;
                        }
                        if (refChild instanceof PsiDocTagValue) {
                            for (PsiElement valueChild : refChild.getChildren()) {
                                if (valueChild instanceof PsiWhiteSpace) {
                                    referenceBuilder.append(valueChild.getText().contains("\n") ? Character.valueOf('\n') : valueChild.getText());
                                    continue;
                                }
                                if (PsiDocToken.isDocToken((PsiElement)valueChild, (IElementType)JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS)) continue;
                                referenceBuilder.append(valueChild.getText());
                            }
                            continue;
                        }
                        referenceBuilder.append(refChild.getText());
                    }
                    continue;
                }
                if (dataElement instanceof PsiDocToken || dataElement instanceof PsiWhiteSpace) continue;
                referenceBuilder.append(dataElement.getText());
            }
            if (isPlain && labelBuilder == null && !referenceBuilder.isEmpty()) {
                labelBuilder = referenceBuilder;
            }
            if (labelBuilder != null) {
                result.append(!isPlain ? "[<code>" : Character.valueOf('[')).append((CharSequence)labelBuilder).append(!isPlain ? "</code>]" : Character.valueOf(']'));
            }
            if (!referenceBuilder.isEmpty()) {
                result.append('[').append(referenceBuilder.toString().replace("[", "\\[").replace("]", "\\]")).append(']');
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/migration/MarkdownDocumentationCommentsMigrationInspection$MarkdownDocumentationCommentsMigrationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/migration/MarkdownDocumentationCommentsMigrationInspection$MarkdownDocumentationCommentsMigrationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "appendElementText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MarkdownDocumentationCommentsMigrationVisitor
    extends BaseInspectionVisitor {
        private MarkdownDocumentationCommentsMigrationVisitor() {
        }

        public void visitDocComment(@NotNull PsiDocComment comment) {
            if (comment == null) {
                MarkdownDocumentationCommentsMigrationVisitor.$$$reportNull$$$0(0);
            }
            super.visitDocComment(comment);
            if (comment.isMarkdownComment()) {
                return;
            }
            this.registerError((PsiElement)(this.isVisibleHighlight((PsiElement)comment) ? comment.getFirstChild() : comment), new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/siyeh/ig/migration/MarkdownDocumentationCommentsMigrationInspection$MarkdownDocumentationCommentsMigrationVisitor", "visitDocComment"));
        }
    }

    private static class HtmlToMarkdownVisitor
    implements NodeFilter {
        static final String INTERNAL_TAG_INLINE_RAW = "jbr-internal-inline";
        static final String INTERNAL_TAG_JDOC_TAG = "jbr-internal-jdoc";
        private static final Pattern MULTI_LINE_BREAK = Pattern.compile("\n\\s*(?=\n)");
        private static final Pattern MARKDOWN_LINE_STRUCT = Pattern.compile("(?m)(^ *)(#{1,6} |> )");
        private static final Pattern MARKDOWN_BLOCK_STRUCT = Pattern.compile("(?m)(^ {2,})(- |\\d[.)] )");
        private static final int LINE_BREAK = 1;
        private static final int PARAGRAPH_BREAK = 2;
        private final StringBuilder result = new StringBuilder();
        private final ArrayDeque<Integer> listContext = new ArrayDeque(1);

        HtmlToMarkdownVisitor() {
        }

        HtmlToMarkdownVisitor(int size) {
            this.result.ensureCapacity(size);
        }

        @NotNull
        public NodeFilter.FilterResult head(@NotNull Node node, int depth) {
            String nodeName;
            if (node == null) {
                HtmlToMarkdownVisitor.$$$reportNull$$$0(0);
            }
            if ((nodeName = node.nodeName()).equals("body")) {
                NodeFilter.FilterResult filterResult = NodeFilter.FilterResult.CONTINUE;
                if (filterResult == null) {
                    HtmlToMarkdownVisitor.$$$reportNull$$$0(1);
                }
                return filterResult;
            }
            if (HtmlToMarkdownVisitor.shouldSkipConversion(node)) {
                this.appendWithoutConversion(node);
                NodeFilter.FilterResult filterResult = NodeFilter.FilterResult.SKIP_ENTIRELY;
                if (filterResult == null) {
                    HtmlToMarkdownVisitor.$$$reportNull$$$0(2);
                }
                return filterResult;
            }
            switch (nodeName) {
                case "a": {
                    this.result.append("[");
                    break;
                }
                case "i": 
                case "em": {
                    this.result.append('_');
                    break;
                }
                case "b": 
                case "strong": {
                    this.result.append("**");
                    break;
                }
                case "hr": {
                    this.appendWithNewLineIfNeeded("___\n");
                    break;
                }
                case "p": 
                case "br": {
                    this.appendBreaks(2);
                    break;
                }
                case "img": {
                    this.result.append("![").append(node.attr("alt")).append("](").append(node.attr("src")).append(')');
                    break;
                }
                case "jbr-internal-jdoc": {
                    Node previousSibling = node.previousSibling();
                    if (previousSibling != null && HtmlToMarkdownVisitor.hasEnoughLineBreaks(previousSibling.nodeValue(), 2, true)) {
                        this.appendBreaks(2);
                        break;
                    }
                    this.appendBreaks(1);
                    break;
                }
                case "h1": 
                case "h2": 
                case "h3": 
                case "h4": 
                case "h5": 
                case "h6": {
                    HtmlToMarkdownVisitor subVisitor = new HtmlToMarkdownVisitor();
                    node.childNodes().forEach(child -> child.filter((NodeFilter)subVisitor));
                    this.appendWithNewLineIfNeeded("#".repeat(Integer.parseInt(nodeName.substring(1))));
                    this.result.append(' ').append(subVisitor.getResult().replace("\n", " ").replace("  ", " "));
                    NodeFilter.FilterResult filterResult = NodeFilter.FilterResult.SKIP_CHILDREN;
                    if (filterResult == null) {
                        HtmlToMarkdownVisitor.$$$reportNull$$$0(3);
                    }
                    return filterResult;
                }
                case "blockquote": {
                    if (HtmlToMarkdownVisitor.isBlockquoteTagCodeBlock(node)) {
                        this.appendCodeBlock(HtmlToMarkdownVisitor.getSingleRelevantChild(node));
                        NodeFilter.FilterResult filterResult = NodeFilter.FilterResult.SKIP_ENTIRELY;
                        if (filterResult == null) {
                            HtmlToMarkdownVisitor.$$$reportNull$$$0(4);
                        }
                        return filterResult;
                    }
                    this.appendBreaks(1);
                    HtmlToMarkdownVisitor subVisitor = new HtmlToMarkdownVisitor();
                    node.childNodes().forEach(child -> child.filter((NodeFilter)subVisitor));
                    this.appendWithNewLineIfNeeded("> " + subVisitor.getResult().strip().replace("\n", "\n> "));
                    NodeFilter.FilterResult filterResult = NodeFilter.FilterResult.SKIP_CHILDREN;
                    if (filterResult == null) {
                        HtmlToMarkdownVisitor.$$$reportNull$$$0(5);
                    }
                    return filterResult;
                }
                case "pre": {
                    if (HtmlToMarkdownVisitor.isPreTagCodeBlock(node)) break;
                    this.appendWithNewLineIfNeeded("<pre>\n");
                    node.html((Appendable)this.result);
                    this.appendWithNewLineIfNeeded("</pre>\n");
                    NodeFilter.FilterResult filterResult = NodeFilter.FilterResult.SKIP_ENTIRELY;
                    if (filterResult == null) {
                        HtmlToMarkdownVisitor.$$$reportNull$$$0(6);
                    }
                    return filterResult;
                }
                case "jbr-internal-inline": {
                    this.appendRaw(node);
                    NodeFilter.FilterResult filterResult = NodeFilter.FilterResult.SKIP_ENTIRELY;
                    if (filterResult == null) {
                        HtmlToMarkdownVisitor.$$$reportNull$$$0(7);
                    }
                    return filterResult;
                }
                case "code": {
                    if (HtmlToMarkdownVisitor.isCodeTagCodeBlock(node)) {
                        this.appendCodeBlock(node);
                        NodeFilter.FilterResult filterResult = NodeFilter.FilterResult.SKIP_ENTIRELY;
                        if (filterResult == null) {
                            HtmlToMarkdownVisitor.$$$reportNull$$$0(8);
                        }
                        return filterResult;
                    }
                    this.result.append("`");
                    break;
                }
                case "ul": 
                case "ol": {
                    if (this.listContext.isEmpty()) {
                        this.appendBreaks(2);
                    }
                    this.listContext.push(0);
                    break;
                }
                case "li": {
                    this.appendBreaks(this.listContext.isEmpty() ? 2 : 1);
                    int newItemListAmount = this.listContext.isEmpty() ? 1 : this.listContext.peek() + 1;
                    this.appendWithIndent(Math.max(4 * this.listContext.size() - 1, 3), (String)(node.parentNameIs("ol") ? newItemListAmount + ". " : "- "));
                    this.listContext.pollLast();
                    this.listContext.push(newItemListAmount);
                    break;
                }
                case "#text": {
                    if (node.nodeValue().isBlank()) {
                        if (!node.nodeValue().contains("\n")) break;
                        this.appendBreaks(1);
                        break;
                    }
                    String cleanedText = MULTI_LINE_BREAK.matcher(node.nodeValue()).replaceAll("");
                    cleanedText = cleanedText.replace("~", "\\~").replace("`", "\\`").replace("_", "\\_").replace("*", "\\*");
                    cleanedText = MARKDOWN_LINE_STRUCT.matcher(cleanedText).replaceAll("$1\\\\$2");
                    cleanedText = MARKDOWN_BLOCK_STRUCT.matcher(cleanedText).replaceAll("$1\\\\$2");
                    if (!this.listContext.isEmpty()) {
                        if (node.siblingIndex() == 0) {
                            cleanedText = cleanedText.stripLeading();
                        }
                        this.appendWithIndent(Math.max(4 * this.listContext.size() + 1, 5), cleanedText);
                        break;
                    }
                    this.appendWithLineBreakLimits(cleanedText);
                    break;
                }
                default: {
                    this.appendWithoutConversion(node);
                    NodeFilter.FilterResult filterResult = NodeFilter.FilterResult.SKIP_ENTIRELY;
                    if (filterResult == null) {
                        HtmlToMarkdownVisitor.$$$reportNull$$$0(9);
                    }
                    return filterResult;
                }
            }
            NodeFilter.FilterResult filterResult = NodeFilter.FilterResult.CONTINUE;
            if (filterResult == null) {
                HtmlToMarkdownVisitor.$$$reportNull$$$0(10);
            }
            return filterResult;
        }

        @NotNull
        public NodeFilter.FilterResult tail(Node node, int depth) {
            String nodeName = node.nodeName();
            if (nodeName.equals("body")) {
                NodeFilter.FilterResult filterResult = NodeFilter.FilterResult.CONTINUE;
                if (filterResult == null) {
                    HtmlToMarkdownVisitor.$$$reportNull$$$0(11);
                }
                return filterResult;
            }
            switch (nodeName) {
                case "i": 
                case "em": {
                    this.result.append('_');
                    break;
                }
                case "b": 
                case "strong": {
                    this.result.append("**");
                    break;
                }
                case "h1": 
                case "h2": 
                case "h3": 
                case "h4": 
                case "h5": 
                case "h6": {
                    this.appendBreaks(1);
                    break;
                }
                case "p": 
                case "blockquote": {
                    this.appendBreaks(2);
                    break;
                }
                case "a": {
                    this.result.append("](").append(node.attr("href")).append(')');
                    break;
                }
                case "#text": 
                case "pre": 
                case "hr": 
                case "br": 
                case "li": 
                case "jbr-internal-jdoc": {
                    break;
                }
                case "code": {
                    if (HtmlToMarkdownVisitor.isCodeTagCodeBlock(node)) break;
                    this.result.append("`");
                    break;
                }
                case "ol": 
                case "ul": {
                    if (!this.listContext.isEmpty()) {
                        this.listContext.pop();
                    }
                    if (!this.listContext.isEmpty()) break;
                    this.appendBreaks(2);
                }
            }
            NodeFilter.FilterResult filterResult = NodeFilter.FilterResult.CONTINUE;
            if (filterResult == null) {
                HtmlToMarkdownVisitor.$$$reportNull$$$0(12);
            }
            return filterResult;
        }

        private static boolean isBlockquoteTagCodeBlock(Node node) {
            Node child = HtmlToMarkdownVisitor.getSingleRelevantChild(node);
            return child != null && child.nameIs("pre");
        }

        private static boolean isPreTagCodeBlock(Node node) {
            return node.childNodeSize() == 1 && node.childNode(0).nodeName().equals("code") || node.parentNameIs("blockquote") && HtmlToMarkdownVisitor.isBlockquoteTagCodeBlock(node.parentNode());
        }

        private static boolean isCodeTagCodeBlock(Node node) {
            return node.parentNameIs("pre") && HtmlToMarkdownVisitor.isPreTagCodeBlock(node.parentNode());
        }

        @Nullable
        private static Node getSingleRelevantChild(Node node) {
            Node singleRelevantChild = null;
            for (Node child : node.childNodes()) {
                if (child.nodeName().equals("#text") && child.nodeValue().isBlank()) continue;
                if (singleRelevantChild != null) {
                    return null;
                }
                singleRelevantChild = child;
            }
            return singleRelevantChild;
        }

        private void appendWithNewLineIfNeeded(String text) {
            this.appendBreaks(1);
            this.result.append(text);
        }

        private void appendWithLineBreakLimits(String text) {
            this.result.append(this.hasParagraphBreak() ? text.stripLeading() : text);
        }

        private void appendWithIndent(int indent, String text) {
            boolean isStartLineBlank;
            int lastNewLine = CharArrayUtil.lastIndexOf((CharSequence)this.result, (String)"\n", (int)(this.result.length() - 1));
            int lineStart = CharArrayUtil.shiftBackward((CharSequence)this.result, (int)(this.result.length() - 1), (String)" ");
            boolean bl = isStartLineBlank = lineStart == lastNewLine;
            if (isStartLineBlank) {
                int indentToAdd = indent - (this.result.length() - 1 - lineStart);
                if (indentToAdd > 0) {
                    this.result.repeat(" ", indentToAdd);
                } else if (indentToAdd < 0) {
                    this.result.delete(this.result.length() + indentToAdd, this.result.length());
                }
                text = text.stripLeading();
            }
            text = text.replaceAll("\n *", "\n" + " ".repeat(indent));
            this.result.append(text);
        }

        private static String prepareRaw(Node node) {
            if (node.childNodeSize() == 1 && node.childNode(0).nameIs(INTERNAL_TAG_INLINE_RAW)) {
                node = node.childNode(0);
            }
            StringBuilder subBuilder = (StringBuilder)node.html((Appendable)new StringBuilder());
            return StringUtil.unescapeXmlEntities((String)subBuilder.toString().replaceAll("</?%s>".formatted(INTERNAL_TAG_INLINE_RAW), ""));
        }

        private void appendRaw(Node node) {
            this.result.append(HtmlToMarkdownVisitor.prepareRaw(node));
        }

        private void appendCodeBlock(Node node) {
            String codeContent = HtmlToMarkdownVisitor.prepareRaw(node);
            int startBreakIndex = codeContent.indexOf("\n");
            boolean needStartBreak = startBreakIndex == -1 || !CharArrayUtil.isEmptyOrSpaces((CharSequence)codeContent, (int)0, (int)(startBreakIndex + 1));
            this.appendWithNewLineIfNeeded(needStartBreak ? "```\n" : "```");
            this.result.append(codeContent.stripTrailing());
            this.appendWithNewLineIfNeeded("```\n");
        }

        private void appendBreaks(int lineBreaks) {
            if (!this.listContext.isEmpty() && (Strings.endsWith((CharSequence)this.result, (CharSequence)"- ") || Strings.endsWith((CharSequence)this.result, (CharSequence)(String.valueOf(this.listContext.peek()) + ". ")))) {
                return;
            }
            while (!HtmlToMarkdownVisitor.hasEnoughLineBreaks(this.result, lineBreaks)) {
                this.result.append("\n");
            }
        }

        private static boolean hasEnoughLineBreaks(CharSequence sequence, int lineBreaks) {
            return HtmlToMarkdownVisitor.hasEnoughLineBreaks(sequence, lineBreaks, false);
        }

        private static boolean hasEnoughLineBreaks(CharSequence sequence, int lineBreaks, boolean strictCheck) {
            if (lineBreaks <= 0 || !strictCheck && CharArrayUtil.isEmptyOrSpaces((CharSequence)sequence, (int)0, (int)sequence.length())) {
                return true;
            }
            int lastLineIndex = sequence.length() + 1;
            for (int i = 0; i < lineBreaks; ++i) {
                if ((lastLineIndex = CharArrayUtil.lastIndexOf((CharSequence)sequence, (String)"\n", (int)Math.min(lastLineIndex - 1, sequence.length()))) == -1) {
                    return false;
                }
                if (lastLineIndex != 0) continue;
                if (i + 1 >= lineBreaks) break;
                return false;
            }
            return CharArrayUtil.isEmptyOrSpaces((CharSequence)sequence, (int)Math.max(lastLineIndex, 0), (int)sequence.length());
        }

        private boolean hasParagraphBreak() {
            return HtmlToMarkdownVisitor.hasEnoughLineBreaks(this.result, 2);
        }

        private static boolean shouldSkipConversion(Node node) {
            if (node.attributesSize() > 0) {
                if (node.nameIs("a")) {
                    return !HtmlToMarkdownVisitor.checkSupported(node, "href");
                }
                if (node.nameIs("img")) {
                    return !HtmlToMarkdownVisitor.checkSupported(node, "src", "alt");
                }
                return true;
            }
            if (node.nameIs("ol") || node.nameIs("ul")) {
                return ContainerUtil.exists((Iterable)node.childNodes(), HtmlToMarkdownVisitor::shouldSkipConversion);
            }
            return false;
        }

        private static boolean checkSupported(Node node, String ... attributes) {
            if (node.attributesSize() > attributes.length) {
                return false;
            }
            return ContainerUtil.and((Iterable)node.attributes(), attribute -> ArrayUtil.contains((String)attribute.getKey(), (String[])attributes));
        }

        private void appendWithoutConversion(Node node) {
            if (node instanceof Element) {
                Element element = (Element)node;
                if (element.tag().isBlock()) {
                    this.appendBreaks(1);
                    this.result.append(node.outerHtml());
                    this.appendBreaks(1);
                } else {
                    this.result.append(element.outerHtml());
                }
            }
        }

        private String getResult() {
            return this.result.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/migration/MarkdownDocumentationCommentsMigrationInspection$HtmlToMarkdownVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/migration/MarkdownDocumentationCommentsMigrationInspection$HtmlToMarkdownVisitor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "head";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tail";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "head";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
            };
        }
    }
}

