/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TryWithIdenticalCatchesInspection
extends BaseInspection {
    public boolean ignoreBlocksWithDifferentComments = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreBlocksWithDifferentComments", (String)InspectionGadgetsBundle.message("try.with.identical.catches.checkbox.different.comments", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String string = InspectionGadgetsBundle.message("try.with.identical.catches.problem.descriptor", type.getPresentableText());
        if (string == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.MULTI_CATCH);
        if (set == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        PsiCatchSection catchSection;
        PsiParameter parameter;
        if (element == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiCatchSection && (parameter = (catchSection = (PsiCatchSection)element).getParameter()) != null && super.isSuppressedFor((PsiElement)parameter)) {
            return true;
        }
        return super.isSuppressedFor(element);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new TryWithIdenticalCatchesVisitor();
    }

    static CatchSectionIndices @Nullable [] getCatchSectionIndices(CatchSectionWrapper @NotNull [] sections, boolean[] @NotNull [] canSwap, @NotNull BiPredicate<? super CatchSectionWrapper, ? super CatchSectionWrapper> equals) {
        if (equals == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(4);
        }
        if (sections == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(5);
        }
        CatchSectionIndices[] indices = new CatchSectionIndices[sections.length];
        for (int index = 0; index < sections.length; ++index) {
            indices[index] = new CatchSectionIndices(index);
        }
        boolean duplicateFound = false;
        for (int from = 0; from < sections.length - 1; ++from) {
            CatchSectionWrapper section;
            if (indices[from].myHasDuplicate || (section = sections[from]) == null) continue;
            for (int to = from + 1; to < sections.length; ++to) {
                CatchSectionWrapper otherSection;
                if (indices[to].myHasDuplicate || (otherSection = sections[to]) == null || !equals.test(section, otherSection)) continue;
                indices[from].addDuplicate(indices[to]);
                duplicateFound = true;
            }
        }
        if (!duplicateFound) {
            return null;
        }
        for (int index = 0; index < sections.length; ++index) {
            indices[index].computeInsertionRange(canSwap);
        }
        for (CatchSectionIndices idx : indices) {
            int[] duplicates = idx.myDuplicates;
            if (duplicates == null) continue;
            for (int from : duplicates) {
                for (int to : duplicates) {
                    indices[to].tryCollapseInto(indices[from]);
                }
            }
        }
        return indices;
    }

    private static boolean[][] collectCanSwap(CatchSectionWrapper @NotNull [] sections) {
        if (sections == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(6);
        }
        boolean[][] canSwap = new boolean[sections.length][sections.length];
        for (int from = 0; from < sections.length; ++from) {
            for (int to = from + 1; to < sections.length; ++to) {
                boolean bl = sections[from] != null && sections[from].canSwapWith(sections[to]);
                canSwap[to][from] = bl;
                canSwap[from][to] = bl;
            }
        }
        return canSwap;
    }

    public static void collectCommentTexts(@NotNull PsiElement element, @NotNull Collection<? super String> result) {
        if (element == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(7);
        }
        if (result == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(8);
        }
        if (element instanceof PsiComment) {
            TryWithIdenticalCatchesInspection.addCommentText(result, (PsiComment)element);
            return;
        }
        if (element instanceof LeafPsiElement) {
            return;
        }
        PsiTreeUtil.processElements((PsiElement)element, child -> {
            if (child instanceof PsiComment) {
                TryWithIdenticalCatchesInspection.addCommentText(result, (PsiComment)child);
            }
            return true;
        });
    }

    private static void addCommentText(@NotNull Collection<? super String> result, PsiComment child) {
        String text;
        if (result == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(9);
        }
        if (!(text = TryWithIdenticalCatchesInspection.getCommentText(child)).isEmpty()) {
            result.add(text);
        }
    }

    @NotNull
    private static List<String> collectCommentTexts(@NotNull PsiElement element) {
        if (element == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(10);
        }
        ArrayList<String> result = new ArrayList<String>();
        TryWithIdenticalCatchesInspection.collectCommentTexts(element, result);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public static String getCommentText(@NotNull PsiComment comment) {
        String extractedText;
        if (comment == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(12);
        }
        IElementType type = comment.getTokenType();
        String text = comment.getText();
        int start = 0;
        int end = text.length();
        if (comment instanceof PsiDocComment) {
            if (text.startsWith("/**")) {
                start += "/**".length();
            }
            if (text.endsWith("*/")) {
                end -= "*/".length();
            }
        } else if (type == JavaTokenType.C_STYLE_COMMENT) {
            if (text.startsWith("/*")) {
                start += "/*".length();
            }
            if (text.endsWith("*/")) {
                end -= "*/".length();
            }
        } else if (type == JavaTokenType.END_OF_LINE_COMMENT && text.startsWith("//")) {
            start += "//".length();
        }
        while (start < end && Character.isWhitespace(text.charAt(start))) {
            ++start;
        }
        while (start < end - 1 && Character.isWhitespace(text.charAt(end - 1))) {
            --end;
        }
        String string = extractedText = start < end ? text.substring(start, end) : "";
        if (extractedText.trim().startsWith("noinspection")) {
            return "";
        }
        String string2 = extractedText;
        if (string2 == null) {
            TryWithIdenticalCatchesInspection.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new CollapseCatchSectionsFix((Boolean)infos[1], this.ignoreBlocksWithDifferentComments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equals";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sections";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommentTexts";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCatchSectionIndices";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectCanSwap";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectCommentTexts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addCommentText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommentText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 12 -> new IllegalArgumentException(string);
        };
    }

    private class TryWithIdenticalCatchesVisitor
    extends BaseInspectionVisitor {
        private TryWithIdenticalCatchesVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            CatchSectionIndices[] emptyIndices;
            if (statement == null) {
                TryWithIdenticalCatchesVisitor.$$$reportNull$$$0(0);
            }
            super.visitTryStatement(statement);
            CatchSectionWrapper[] sections = CatchSectionWrapper.createWrappers(statement);
            if (sections == null) {
                return;
            }
            boolean[][] canSwap = TryWithIdenticalCatchesInspection.collectCanSwap(sections);
            CatchSectionIndices[] duplicateIndices = TryWithIdenticalCatchesInspection.getCatchSectionIndices(sections, canSwap, (s1, s2) -> CatchSectionWrapper.areDuplicates(s1, s2, TryWithIdenticalCatchesInspection.this.ignoreBlocksWithDifferentComments));
            CatchSectionIndices[] catchSectionIndicesArray = emptyIndices = this.isOnTheFly() ? TryWithIdenticalCatchesInspection.getCatchSectionIndices(sections, canSwap, CatchSectionWrapper::areEmpty) : null;
            if (duplicateIndices == null && emptyIndices == null) {
                return;
            }
            boolean[] problems = new boolean[sections.length];
            this.registerProblems(sections, duplicateIndices, problems, false);
            this.registerProblems(sections, emptyIndices, problems, true);
        }

        private void registerProblems(CatchSectionWrapper @NotNull [] sections, CatchSectionIndices @Nullable [] sectionIndices, boolean @NotNull [] problems, boolean empty) {
            if (sections == null) {
                TryWithIdenticalCatchesVisitor.$$$reportNull$$$0(1);
            }
            if (problems == null) {
                TryWithIdenticalCatchesVisitor.$$$reportNull$$$0(2);
            }
            if (sectionIndices == null) {
                return;
            }
            for (int index = 0; index < sections.length; ++index) {
                int collapseIntoIndex;
                if (problems[index] || (collapseIntoIndex = sectionIndices[index].myCollapseIntoIndex) < 0) continue;
                this.registerProblem(sections, index, collapseIntoIndex, empty);
                problems[index] = true;
            }
        }

        private void registerProblem(CatchSectionWrapper @NotNull [] sections, int at, int collapseIntoIndex, boolean empty) {
            PsiCatchSection section;
            PsiJavaToken rParenth;
            if (sections == null) {
                TryWithIdenticalCatchesVisitor.$$$reportNull$$$0(3);
            }
            if ((rParenth = (section = sections[at].myCatchSection).getRParenth()) != null) {
                this.registerErrorAtOffset((PsiElement)section, 0, rParenth.getStartOffsetInParent() + 1, empty ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[]{sections[collapseIntoIndex].myParameter.getType(), empty});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sections";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problems";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection$TryWithIdenticalCatchesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTryStatement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerProblems";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerProblem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CatchSectionIndices {
        final int myIndex;
        int myCanInsertBefore = -1;
        int myCanInsertAfter = -1;
        boolean myHasDuplicate;
        int[] myDuplicates;
        int myCollapseIntoIndex = -1;

        CatchSectionIndices(int index) {
            this.myIndex = index;
        }

        void addDuplicate(CatchSectionIndices duplicate) {
            if (this.myDuplicates == null) {
                this.myDuplicates = new int[]{this.myIndex, duplicate.myIndex};
                this.myHasDuplicate = true;
            } else {
                this.myDuplicates = ArrayUtil.append((int[])this.myDuplicates, (int)duplicate.myIndex);
            }
            duplicate.myHasDuplicate = true;
        }

        void computeInsertionRange(boolean[] @NotNull [] canSwap) {
            boolean[] canSwapWith = canSwap[this.myIndex];
            int before = this.myIndex;
            while (true) {
                if (before - 1 < 0 || !canSwapWith[before - 1]) break;
                --before;
            }
            this.myCanInsertBefore = before;
            int after = this.myIndex;
            while (true) {
                if (after + 1 >= canSwapWith.length || !canSwapWith[after + 1]) break;
                ++after;
            }
            this.myCanInsertAfter = after;
        }

        public void tryCollapseInto(CatchSectionIndices collapseInto) {
            if (this.myCollapseIntoIndex < 0 && this.myIndex > collapseInto.myIndex && this.myCanInsertBefore <= collapseInto.myCanInsertAfter + 1) {
                this.myCollapseIntoIndex = collapseInto.myIndex;
            }
        }
    }

    private static final class CatchSectionWrapper {
        @NotNull
        final PsiCatchSection myCatchSection;
        @NotNull
        final PsiCodeBlock myCodeBlock;
        @NotNull
        final PsiParameter myParameter;
        @NotNull
        final List<? extends PsiClassType> myTypes;
        @NotNull
        final DuplicatesFinder myFinder;

        private CatchSectionWrapper(@NotNull PsiCatchSection catchSection, @NotNull PsiCodeBlock codeBlock, @NotNull PsiParameter parameter, @NotNull List<? extends PsiClassType> types, @NotNull DuplicatesFinder finder) {
            if (catchSection == null) {
                CatchSectionWrapper.$$$reportNull$$$0(0);
            }
            if (codeBlock == null) {
                CatchSectionWrapper.$$$reportNull$$$0(1);
            }
            if (parameter == null) {
                CatchSectionWrapper.$$$reportNull$$$0(2);
            }
            if (types == null) {
                CatchSectionWrapper.$$$reportNull$$$0(3);
            }
            if (finder == null) {
                CatchSectionWrapper.$$$reportNull$$$0(4);
            }
            this.myCatchSection = catchSection;
            this.myCodeBlock = codeBlock;
            this.myParameter = parameter;
            this.myTypes = types;
            this.myFinder = finder;
        }

        static boolean areEmpty(@NotNull CatchSectionWrapper s1, @NotNull CatchSectionWrapper s2) {
            if (s1 == null) {
                CatchSectionWrapper.$$$reportNull$$$0(5);
            }
            if (s2 == null) {
                CatchSectionWrapper.$$$reportNull$$$0(6);
            }
            return s1.myCodeBlock.isEmpty() && s2.myCodeBlock.isEmpty();
        }

        static boolean areDuplicates(@NotNull CatchSectionWrapper s1, @NotNull CatchSectionWrapper s2, boolean strictCommentMatch) {
            boolean empty2;
            boolean empty1;
            if (s1 == null) {
                CatchSectionWrapper.$$$reportNull$$$0(7);
            }
            if (s2 == null) {
                CatchSectionWrapper.$$$reportNull$$$0(8);
            }
            if ((empty1 = s1.myCodeBlock.isEmpty()) != (empty2 = s2.myCodeBlock.isEmpty())) {
                return false;
            }
            if (empty1) {
                return CatchSectionWrapper.commentsMatch(s1, s2);
            }
            Match match1 = s1.findDuplicate(s2);
            if (match1 == null) {
                return false;
            }
            Match match2 = s2.findDuplicate(s1);
            if (match2 == null) {
                return false;
            }
            if (!ReturnValue.areEquivalent(match1.getReturnValue(), match2.getReturnValue())) {
                return false;
            }
            return !strictCommentMatch || CatchSectionWrapper.commentsMatch(s1, s2);
        }

        private static boolean commentsMatch(@NotNull CatchSectionWrapper s1, @NotNull CatchSectionWrapper s2) {
            if (s1 == null) {
                CatchSectionWrapper.$$$reportNull$$$0(9);
            }
            if (s2 == null) {
                CatchSectionWrapper.$$$reportNull$$$0(10);
            }
            List<String> comments1 = TryWithIdenticalCatchesInspection.collectCommentTexts((PsiElement)s1.myCatchSection);
            List<String> comments2 = TryWithIdenticalCatchesInspection.collectCommentTexts((PsiElement)s2.myCatchSection);
            return comments1.equals(comments2);
        }

        private Match findDuplicate(@NotNull CatchSectionWrapper section) {
            if (section == null) {
                CatchSectionWrapper.$$$reportNull$$$0(11);
            }
            return this.myFinder.isDuplicate((PsiElement)section.myCodeBlock, true);
        }

        boolean canSwapWith(@Nullable CatchSectionWrapper section) {
            if (section == null) {
                return false;
            }
            for (PsiClassType psiClassType : this.myTypes) {
                for (PsiClassType psiClassType2 : section.myTypes) {
                    if (!psiClassType.isAssignableFrom((PsiType)psiClassType2) && !psiClassType2.isAssignableFrom((PsiType)psiClassType)) continue;
                    return false;
                }
            }
            return true;
        }

        static CatchSectionWrapper @Nullable [] createWrappers(@NotNull PsiTryStatement statement) {
            PsiCatchSection[] catchSections;
            if (statement == null) {
                CatchSectionWrapper.$$$reportNull$$$0(12);
            }
            if ((catchSections = statement.getCatchSections()).length < 2) {
                return null;
            }
            PsiParameter[] parameters = statement.getCatchBlockParameters();
            if (catchSections.length != parameters.length) {
                return null;
            }
            CatchSectionWrapper[] sections = new CatchSectionWrapper[catchSections.length];
            for (int i = 0; i < sections.length; ++i) {
                sections[i] = CatchSectionWrapper.createWrapper(catchSections[i]);
            }
            return sections;
        }

        @Nullable
        private static CatchSectionWrapper createWrapper(@NotNull PsiCatchSection catchSection) {
            List<PsiClassType> types;
            if (catchSection == null) {
                CatchSectionWrapper.$$$reportNull$$$0(13);
            }
            PsiParameter parameter = catchSection.getParameter();
            PsiCodeBlock codeBlock = catchSection.getCatchBlock();
            if (parameter != null && codeBlock != null && (types = CatchSectionWrapper.getClassTypes(parameter.getType())) != null && ControlFlowUtil.isEffectivelyFinal((PsiVariable)parameter, (PsiElement)codeBlock)) {
                DuplicatesFinder finder = CatchSectionWrapper.buildDuplicatesFinder(codeBlock, parameter);
                return new CatchSectionWrapper(catchSection, codeBlock, parameter, types, finder);
            }
            return null;
        }

        @Nullable
        private static List<PsiClassType> getClassTypes(@Nullable PsiType type) {
            List classTypes;
            List disjunctions;
            if (type instanceof PsiClassType) {
                return Collections.singletonList((PsiClassType)type);
            }
            if (type instanceof PsiDisjunctionType && !(disjunctions = ((PsiDisjunctionType)type).getDisjunctions()).isEmpty() && (classTypes = ContainerUtil.mapNotNull((Collection)disjunctions, t -> (PsiClassType)ObjectUtils.tryCast((Object)t, PsiClassType.class))).size() == disjunctions.size()) {
                return classTypes;
            }
            return null;
        }

        @NotNull
        private static DuplicatesFinder buildDuplicatesFinder(@NotNull PsiCodeBlock catchBlock, @NotNull PsiParameter parameter) {
            if (catchBlock == null) {
                CatchSectionWrapper.$$$reportNull$$$0(14);
            }
            if (parameter == null) {
                CatchSectionWrapper.$$$reportNull$$$0(15);
            }
            InputVariables inputVariables = new InputVariables(Collections.singletonList(parameter), parameter.getProject(), new LocalSearchScope((PsiElement)catchBlock), false, Collections.emptySet());
            return new DuplicatesFinder(new PsiElement[]{catchBlock}, inputVariables, null, Collections.emptyList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "catchSection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeBlock";
                    break;
                }
                case 2: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "finder";
                    break;
                }
                case 5: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s1";
                    break;
                }
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s2";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "section";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "catchBlock";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection$CatchSectionWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "areEmpty";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "areDuplicates";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commentsMatch";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findDuplicate";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createWrappers";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createWrapper";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildDuplicatesFinder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CollapseCatchSectionsFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myEmpty;
        private final boolean myIgnoreBlocksWithDifferentComments;

        CollapseCatchSectionsFix(boolean empty, boolean ignoreBlocksWithDifferentComments) {
            this.myEmpty = empty;
            this.myIgnoreBlocksWithDifferentComments = ignoreBlocksWithDifferentComments;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("try.with.identical.catches.quickfix", new Object[0]);
            if (string == null) {
                CollapseCatchSectionsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiCatchSection[] catchSections;
            PsiCatchSection catchSection;
            PsiTryStatement tryStatement;
            CatchSectionWrapper[] sections;
            if (project == null) {
                CollapseCatchSectionsFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                CollapseCatchSectionsFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                CollapseCatchSectionsFix.$$$reportNull$$$0(3);
            }
            if ((sections = CatchSectionWrapper.createWrappers(tryStatement = (PsiTryStatement)(catchSection = (PsiCatchSection)startElement).getParent())) == null) {
                return;
            }
            int sectionIndex = CollapseCatchSectionsFix.getSectionIndex(sections, (PsiElement)catchSection);
            if (sectionIndex < 0) {
                return;
            }
            CatchSectionWrapper duplicateSection = sections[sectionIndex];
            if (duplicateSection == null) {
                return;
            }
            boolean[][] canSwap = TryWithIdenticalCatchesInspection.collectCanSwap(sections);
            CatchSectionIndices[] duplicatesIndices = TryWithIdenticalCatchesInspection.getCatchSectionIndices(sections, canSwap, this.myEmpty ? CatchSectionWrapper::areEmpty : (s1, s2) -> CatchSectionWrapper.areDuplicates(s1, s2, this.myIgnoreBlocksWithDifferentComments));
            if (duplicatesIndices == null) {
                return;
            }
            int collapseIntoIndex = duplicatesIndices[sectionIndex].myCollapseIntoIndex;
            if (collapseIntoIndex < 0) {
                return;
            }
            CatchSectionWrapper collapseIntoSection = sections[collapseIntoIndex];
            if (collapseIntoSection == null) {
                return;
            }
            PsiTypeElement collapseIntoTypeElement = collapseIntoSection.myParameter.getTypeElement();
            if (collapseIntoTypeElement == null) {
                return;
            }
            ArrayList<? extends PsiClassType> parameterTypes = new ArrayList<PsiClassType>(collapseIntoSection.myTypes);
            parameterTypes.addAll(duplicateSection.myTypes);
            List filteredTypes = PsiDisjunctionType.flattenAndRemoveDuplicates(parameterTypes);
            PsiType disjunction = PsiDisjunctionType.createDisjunction((List)filteredTypes, (PsiManager)tryStatement.getManager());
            List<PsiClassType> targetTypes = CatchSectionWrapper.getClassTypes(disjunction);
            if (targetTypes != null && targetTypes.equals(duplicateSection.myTypes)) {
                CatchSectionWrapper temp = collapseIntoSection;
                collapseIntoSection = duplicateSection;
                duplicateSection = temp;
            }
            HashSet<String> survivingCommentTexts = new HashSet<String>(TryWithIdenticalCatchesInspection.collectCommentTexts((PsiElement)collapseIntoSection.myCatchSection));
            PsiTypeElement newTypeElement = JavaPsiFacade.getElementFactory((Project)project).createTypeElement(disjunction);
            CommentTracker tracker = new CommentTracker();
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(tracker.replace((PsiElement)collapseIntoTypeElement, (PsiElement)newTypeElement));
            int insertBeforeIndex = duplicatesIndices[sectionIndex].myCanInsertBefore;
            if (collapseIntoIndex < insertBeforeIndex && insertBeforeIndex < (catchSections = tryStatement.getCatchSections()).length && catchSections[insertBeforeIndex] != null) {
                CatchSectionWrapper finalCollapseIntoSection = collapseIntoSection;
                CodeStyleManager.getInstance((Project)tryStatement.getProject()).performActionWithFormatterDisabled(() -> {
                    PsiElement patt1$temp;
                    PsiCatchSection sectionToMove = finalCollapseIntoSection.myCatchSection;
                    PsiElement toCopy = null;
                    PsiElement patt0$temp = sectionToMove.getNextSibling();
                    if (patt0$temp instanceof PsiWhiteSpace) {
                        PsiWhiteSpace whiteSpace = (PsiWhiteSpace)patt0$temp;
                        toCopy = whiteSpace.copy();
                    }
                    PsiElement element = tryStatement.addBefore((PsiElement)finalCollapseIntoSection.myCatchSection, (PsiElement)catchSections[insertBeforeIndex]);
                    if (toCopy != null) {
                        tryStatement.addAfter(toCopy, element);
                    }
                    if ((patt1$temp = sectionToMove.getNextSibling()) instanceof PsiWhiteSpace) {
                        PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)patt1$temp;
                        psiWhiteSpace.delete();
                    }
                    sectionToMove.delete();
                });
            }
            PsiTreeUtil.processElements((PsiElement)duplicateSection.myCatchSection, element -> {
                String text;
                if (element instanceof PsiComment && ((text = TryWithIdenticalCatchesInspection.getCommentText((PsiComment)element)).isEmpty() || survivingCommentTexts.contains(text))) {
                    tracker.markUnchanged(element);
                }
                return true;
            });
            tracker.grabComments((PsiElement)duplicateSection.myCatchSection);
            tracker.insertCommentsBefore((PsiElement)duplicateSection.myCatchSection);
            CatchSectionWrapper finalDuplicateSection = duplicateSection;
            CodeStyleManager.getInstance((Project)tryStatement.getProject()).performActionWithFormatterDisabled(() -> {
                PsiElement patt0$temp = finalDuplicateSection.myCatchSection.getNextSibling();
                if (patt0$temp instanceof PsiWhiteSpace) {
                    PsiWhiteSpace whiteSpace = (PsiWhiteSpace)patt0$temp;
                    whiteSpace.delete();
                }
                finalDuplicateSection.myCatchSection.delete();
            });
        }

        private static int getSectionIndex(CatchSectionWrapper @NotNull [] sections, @NotNull PsiElement catchSection) {
            if (catchSection == null) {
                CollapseCatchSectionsFix.$$$reportNull$$$0(4);
            }
            if (sections == null) {
                CollapseCatchSectionsFix.$$$reportNull$$$0(5);
            }
            for (int i = 0; i < sections.length; ++i) {
                CatchSectionWrapper section = sections[i];
                if (section == null || section.myCatchSection != catchSection) continue;
                return i;
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection$CollapseCatchSectionsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "catchSection";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sections";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/migration/TryWithIdenticalCatchesInspection$CollapseCatchSectionsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getSectionIndex";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

