/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public final class OverloadedMethodsWithSameNumberOfParametersInspection
extends BaseInspection {
    public boolean ignoreInconvertibleTypes = true;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("overloaded.methods.with.same.number.parameters.problem.descriptor", new Object[0]);
        if (string == null) {
            OverloadedMethodsWithSameNumberOfParametersInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreInconvertibleTypes", (String)InspectionGadgetsBundle.message("overloaded.methods.with.same.number.parameters.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            OverloadedMethodsWithSameNumberOfParametersInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new OverloadedMethodsWithSameNumberOfParametersVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/naming/OverloadedMethodsWithSameNumberOfParametersInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class OverloadedMethodsWithSameNumberOfParametersVisitor
    extends BaseInspectionVisitor {
        private OverloadedMethodsWithSameNumberOfParametersVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] sameNameMethods;
            if (method == null) {
                OverloadedMethodsWithSameNumberOfParametersVisitor.$$$reportNull$$$0(0);
            }
            if (method.isConstructor()) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            int parameterCount = parameterList.getParametersCount();
            if (parameterCount == 0) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            String methodName = method.getName();
            for (PsiMethod sameNameMethod : sameNameMethods = aClass.findMethodsByName(methodName, false)) {
                PsiParameterList otherParameterList;
                if (method.equals((Object)sameNameMethod) || parameterCount != (otherParameterList = sameNameMethod.getParameterList()).getParametersCount()) continue;
                if (OverloadedMethodsWithSameNumberOfParametersInspection.this.ignoreInconvertibleTypes && !OverloadedMethodsWithSameNumberOfParametersVisitor.areParameterTypesConvertible(parameterList, otherParameterList)) {
                    return;
                }
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }

        private static boolean areParameterTypesConvertible(PsiParameterList parameterList, PsiParameterList otherParameterList) {
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter[] otherParameters = otherParameterList.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                PsiType otherType;
                PsiType type = parameters[i].getType();
                if (type.isAssignableFrom(otherType = otherParameters[i].getType()) || otherType.isAssignableFrom(type)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/OverloadedMethodsWithSameNumberOfParametersInspection$OverloadedMethodsWithSameNumberOfParametersVisitor", "visitMethod"));
        }
    }
}

