/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class CharUsedInArithmeticContextInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.problem.descriptor", new Object[0]);
        if (string == null) {
            CharUsedInArithmeticContextInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        PsiExpression binaryExpression;
        PsiType type;
        ArrayList<PsiUpdateModCommandQuickFix> result = new ArrayList<PsiUpdateModCommandQuickFix>();
        PsiElement expression = (PsiElement)infos[0];
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        if (parent instanceof PsiExpression && (type = (binaryExpression = (PsiExpression)parent).getType()) instanceof PsiPrimitiveType && !type.equals(PsiTypes.charType())) {
            String typeText = type.getCanonicalText();
            result.add(new CharUsedInArithmeticContentCastFix(typeText));
        }
        if (!(expression instanceof PsiLiteralExpression || expression instanceof PsiParenthesizedExpression && PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)expression)) instanceof PsiLiteralExpression)) {
            LocalQuickFix[] localQuickFixArray = result.toArray(LocalQuickFix.EMPTY_ARRAY);
            if (localQuickFixArray == null) {
                CharUsedInArithmeticContextInspection.$$$reportNull$$$0(1);
            }
            return localQuickFixArray;
        }
        while (parent instanceof PsiPolyadicExpression) {
            if (ExpressionUtils.hasStringType((PsiExpression)parent)) {
                result.add(new CharUsedInArithmeticContentFix());
                break;
            }
            parent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
        }
        LocalQuickFix[] localQuickFixArray = result.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            CharUsedInArithmeticContextInspection.$$$reportNull$$$0(2);
        }
        return localQuickFixArray;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CharUsedInArithmeticContextVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CharUsedInArithmeticContentCastFix
    extends PsiUpdateModCommandQuickFix {
        private final String typeText;

        CharUsedInArithmeticContentCastFix(String typeText) {
            this.typeText = typeText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.cast.quickfix", this.typeText);
            if (string == null) {
                CharUsedInArithmeticContentCastFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.content.cast.fix.family.name", new Object[0]);
            if (string == null) {
                CharUsedInArithmeticContentCastFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                CharUsedInArithmeticContentCastFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                CharUsedInArithmeticContentCastFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                CharUsedInArithmeticContentCastFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            CommentTracker commentTracker = new CommentTracker();
            String expressionText = commentTracker.text((PsiElement)expression);
            PsiReplacementUtil.replaceExpression(expression, "(" + this.typeText + ")" + expressionText, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection$CharUsedInArithmeticContentCastFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection$CharUsedInArithmeticContentCastFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class CharUsedInArithmeticContentFix
    extends PsiUpdateModCommandQuickFix {
        private CharUsedInArithmeticContentFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.quickfix", new Object[0]);
            if (string == null) {
                CharUsedInArithmeticContentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                CharUsedInArithmeticContentFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                CharUsedInArithmeticContentFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                CharUsedInArithmeticContentFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiLiteralExpression)) {
                return;
            }
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            Object literal = literalExpression.getValue();
            if (!(literal instanceof Character)) {
                return;
            }
            String escaped = StringUtil.escapeStringCharacters((String)literal.toString());
            PsiReplacementUtil.replaceExpression((PsiExpression)literalExpression, "\"" + escaped + "\"");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection$CharUsedInArithmeticContentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection$CharUsedInArithmeticContentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class CharUsedInArithmeticContextVisitor
    extends BaseInspectionVisitor {
        private CharUsedInArithmeticContextVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                CharUsedInArithmeticContextVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (ComparisonUtils.isComparisonOperation(tokenType)) {
                return;
            }
            PsiExpression[] operands = expression.getOperands();
            PsiType leftType = operands[0].getType();
            for (int i = 1; i < operands.length; ++i) {
                PsiExpression operand = operands[i];
                PsiType rightType = operand.getType();
                PsiType expressionType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)leftType, (PsiType)rightType, (IElementType)tokenType, (boolean)true);
                if (TypeUtils.isJavaLangString(expressionType)) {
                    return;
                }
                if (PsiTypes.charType().equals((Object)rightType)) {
                    this.registerError((PsiElement)operand, operand);
                }
                if (PsiTypes.charType().equals((Object)leftType) && i == 1) {
                    this.registerError((PsiElement)operands[0], operands[0]);
                }
                leftType = rightType;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection$CharUsedInArithmeticContextVisitor", "visitPolyadicExpression"));
        }
    }
}

