/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImplicitNumericConversionInspection
extends BaseInspection {
    public boolean ignoreWideningConversions = false;
    public boolean ignoreCharConversions = false;
    public boolean ignoreConstantConversions = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreWideningConversions", (String)InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.widening.conversion.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreCharConversions", (String)InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.char.conversion.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreConstantConversions", (String)InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.constant.conversion.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ImplicitNumericConversionInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[1];
        PsiType expectedType = (PsiType)infos[2];
        String string = InspectionGadgetsBundle.message(infos[0] instanceof PsiAssignmentExpression ? "implicit.numeric.conversion.assignment.problem.descriptor" : "implicit.numeric.conversion.problem.descriptor", type.getPresentableText(), expectedType.getPresentableText());
        if (string == null) {
            ImplicitNumericConversionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitNumericConversionVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ImplicitNumericConversionFix((PsiExpression)infos[0], (PsiType)infos[2]);
    }

    private static boolean isCharConversion(PsiType expressionType, PsiType convertedType) {
        return PsiTypes.charType().equals((Object)expressionType) && !PsiTypes.floatType().equals((Object)convertedType) && !PsiTypes.doubleType().equals((Object)convertedType) || PsiTypes.charType().equals((Object)convertedType) && !PsiTypes.floatType().equals((Object)expressionType) && !PsiTypes.doubleType().equals((Object)expressionType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/ImplicitNumericConversionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ImplicitNumericConversionVisitor
    extends BaseInspectionVisitor {
        private ImplicitNumericConversionVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                ImplicitNumericConversionVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            if (expression == null) {
                ImplicitNumericConversionVisitor.$$$reportNull$$$0(1);
            }
            super.visitConditionalExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                ImplicitNumericConversionVisitor.$$$reportNull$$$0(2);
            }
            super.visitLiteralExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
            if (expression == null) {
                ImplicitNumericConversionVisitor.$$$reportNull$$$0(3);
            }
            super.visitUnaryExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                ImplicitNumericConversionVisitor.$$$reportNull$$$0(4);
            }
            super.visitReferenceExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
            if (expression == null) {
                ImplicitNumericConversionVisitor.$$$reportNull$$$0(5);
            }
            super.visitArrayAccessExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ImplicitNumericConversionVisitor.$$$reportNull$$$0(6);
            }
            super.visitMethodCallExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                ImplicitNumericConversionVisitor.$$$reportNull$$$0(7);
            }
            super.visitTypeCastExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                ImplicitNumericConversionVisitor.$$$reportNull$$$0(8);
            }
            super.visitAssignmentExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
            if (expression == null) {
                ImplicitNumericConversionVisitor.$$$reportNull$$$0(9);
            }
            super.visitParenthesizedExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        private void checkExpression(PsiExpression expression) {
            PsiAssignmentExpression assignmentExpression;
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiParenthesizedExpression) {
                return;
            }
            if (parent instanceof PsiAssignmentExpression && (assignmentExpression = (PsiAssignmentExpression)parent).getOperationTokenType() != JavaTokenType.EQ) {
                PsiExpression rhs;
                if (assignmentExpression.getLExpression() == expression && (rhs = assignmentExpression.getRExpression()) != null) {
                    PsiType expressionType = expression.getType();
                    if (!ClassUtils.isPrimitiveNumericType(expressionType)) {
                        return;
                    }
                    PsiType rhsType = rhs.getType();
                    if (!ClassUtils.isPrimitiveNumericType(rhsType)) {
                        return;
                    }
                    PsiType promotedType = TypeConversionUtil.binaryNumericPromotion((PsiType)expressionType, (PsiType)rhsType);
                    if (this.checkTypes((PsiExpression)assignmentExpression, promotedType, expressionType)) {
                        return;
                    }
                    if (ImplicitNumericConversionInspection.this.ignoreWideningConversions) {
                        return;
                    }
                    this.checkTypes(rhs, rhsType, promotedType);
                }
                return;
            }
            if (ImplicitNumericConversionInspection.this.ignoreWideningConversions) {
                return;
            }
            PsiType expressionType = expression.getType();
            if (!ClassUtils.isPrimitiveNumericType(expressionType)) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, true);
            if (!ClassUtils.isPrimitiveNumericType(expectedType)) {
                return;
            }
            this.checkTypes(expression, expressionType, expectedType);
        }

        private boolean checkTypes(PsiExpression expression, PsiType expressionType, PsiType convertedType) {
            if (expressionType.equals(convertedType)) {
                return false;
            }
            if (ImplicitNumericConversionInspection.this.ignoreConstantConversions) {
                PsiExpression rootExpression = expression;
                while (rootExpression instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)rootExpression;
                    rootExpression = parenthesizedExpression.getExpression();
                }
                if (rootExpression instanceof PsiLiteralExpression || PsiUtil.isConstantExpression((PsiExpression)rootExpression)) {
                    return false;
                }
            }
            if (ImplicitNumericConversionInspection.this.ignoreCharConversions && ImplicitNumericConversionInspection.isCharConversion(expressionType, convertedType)) {
                return false;
            }
            this.registerError((PsiElement)(expression instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)expression).getLExpression() : expression), expression, expressionType, convertedType);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/numeric/ImplicitNumericConversionInspection$ImplicitNumericConversionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitConditionalExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLiteralExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayAccessExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeCastExpression";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParenthesizedExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ImplicitNumericConversionFix
    extends PsiUpdateModCommandQuickFix {
        @IntentionName
        private final String m_name;

        ImplicitNumericConversionFix(PsiExpression expression, PsiType expectedType) {
            String convertedExpression = ImplicitNumericConversionFix.convertExpression(expression, expectedType);
            this.m_name = convertedExpression != null ? CommonQuickFixBundle.message((String)"fix.convert.to.x", (Object[])new Object[]{convertedExpression}) : InspectionGadgetsBundle.message("implicit.numeric.conversion.make.explicit.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("implicit.numeric.conversion.make.explicit.quickfix", new Object[0]);
            if (string == null) {
                ImplicitNumericConversionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                ImplicitNumericConversionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiExpression expression;
            PsiType expectedType;
            if (project == null) {
                ImplicitNumericConversionFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                ImplicitNumericConversionFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ImplicitNumericConversionFix.$$$reportNull$$$0(4);
            }
            if ((expectedType = ExpectedTypeUtils.findExpectedType(expression = (PsiExpression)startElement, true)) == null) {
                return;
            }
            String convertedExpression = ImplicitNumericConversionFix.convertExpression(expression, expectedType);
            if (convertedExpression != null) {
                PsiReplacementUtil.replaceExpression(expression, convertedExpression);
            } else {
                PsiAssignmentExpression assignmentExpression;
                PsiJavaToken sign;
                PsiElement parent = expression.getParent();
                if (parent instanceof PsiAssignmentExpression && !JavaTokenType.EQ.equals((sign = (assignmentExpression = (PsiAssignmentExpression)parent).getOperationSign()).getTokenType())) {
                    this.replaceCompoundAssignment(assignmentExpression);
                    return;
                }
                CommentTracker commentTracker = new CommentTracker();
                String castExpression = "(" + expectedType.getCanonicalText() + ")" + commentTracker.text(expression, 4);
                PsiReplacementUtil.replaceExpression(expression, castExpression, commentTracker);
            }
        }

        private void replaceCompoundAssignment(PsiAssignmentExpression assignmentExpression) {
            boolean cast;
            PsiJavaToken sign = assignmentExpression.getOperationSign();
            if (JavaTokenType.EQ.equals(sign.getTokenType())) {
                throw new IllegalArgumentException();
            }
            CommentTracker commentTracker = new CommentTracker();
            PsiExpression lhs = assignmentExpression.getLExpression();
            String lhsText = commentTracker.text((PsiElement)lhs);
            StringBuilder builder = new StringBuilder();
            builder.append(lhsText).append('=');
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (rhs == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (rhsType == null) {
                return;
            }
            PsiType promotedType = TypeConversionUtil.binaryNumericPromotion((PsiType)assignmentExpression.getType(), (PsiType)rhsType);
            PsiType lhsType = lhs.getType();
            if (lhsType == null) {
                return;
            }
            boolean bl = cast = !promotedType.equals(lhsType);
            if (cast) {
                builder.append('(').append(lhsType.getCanonicalText()).append(")(");
                if (!(ImplicitNumericConversionInspection.this.ignoreWideningConversions || ImplicitNumericConversionInspection.this.ignoreCharConversions && ImplicitNumericConversionInspection.isCharConversion(lhsType, promotedType))) {
                    builder.append("(").append(promotedType.getCanonicalText()).append(')');
                }
            }
            builder.append(lhsText).append(StringUtil.substringBefore((String)sign.getText(), (String)"="));
            if (!(ImplicitNumericConversionInspection.this.ignoreWideningConversions || promotedType.equals(rhsType) || ImplicitNumericConversionInspection.this.ignoreCharConversions && ImplicitNumericConversionInspection.isCharConversion(rhsType, promotedType))) {
                builder.append('(').append(promotedType.getCanonicalText()).append(')');
            }
            builder.append(commentTracker.text((PsiElement)rhs));
            if (cast) {
                builder.append(')');
            }
            String newExpressionText = builder.toString();
            PsiReplacementUtil.replaceExpression((PsiExpression)assignmentExpression, newExpressionText, commentTracker);
        }

        @Nullable
        @NonNls
        private static String convertExpression(PsiExpression expression, PsiType expectedType) {
            if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiLiteralExpression) && !ImplicitNumericConversionFix.isNegatedLiteral(expression)) {
                return null;
            }
            PsiType expressionType = expression.getType();
            if (expressionType == null) {
                return null;
            }
            String text = expression.getText();
            if (expressionType.equals(PsiTypes.intType()) && expectedType.equals(PsiTypes.longType())) {
                return text + "L";
            }
            if (expressionType.equals(PsiTypes.intType()) && expectedType.equals(PsiTypes.floatType())) {
                if (!ImplicitNumericConversionFix.isDecimalLiteral(text)) {
                    return null;
                }
                return text + ".0F";
            }
            if (expressionType.equals(PsiTypes.intType()) && expectedType.equals(PsiTypes.doubleType())) {
                if (!ImplicitNumericConversionFix.isDecimalLiteral(text)) {
                    return null;
                }
                return text + ".0";
            }
            if (expressionType.equals(PsiTypes.longType()) && expectedType.equals(PsiTypes.floatType())) {
                if (!ImplicitNumericConversionFix.isDecimalLiteral(text)) {
                    return null;
                }
                return text.substring(0, text.length() - 1) + ".0F";
            }
            if (expressionType.equals(PsiTypes.longType()) && expectedType.equals(PsiTypes.doubleType())) {
                if (!ImplicitNumericConversionFix.isDecimalLiteral(text)) {
                    return null;
                }
                return text.substring(0, text.length() - 1) + ".0";
            }
            if (expressionType.equals(PsiTypes.doubleType()) && expectedType.equals(PsiTypes.floatType())) {
                int length = text.length();
                if (text.charAt(length - 1) == 'd' || text.charAt(length - 1) == 'D') {
                    return text.substring(0, length - 1) + "F";
                }
                return text + "F";
            }
            if (expressionType.equals(PsiTypes.floatType()) && expectedType.equals(PsiTypes.doubleType())) {
                int length = text.length();
                return text.substring(0, length - 1);
            }
            return null;
        }

        private static boolean isDecimalLiteral(String text) {
            return !text.isEmpty() && text.charAt(0) != '0';
        }

        private static boolean isNegatedLiteral(PsiExpression expression) {
            if (!(expression instanceof PsiPrefixExpression)) {
                return false;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (!JavaTokenType.MINUS.equals(tokenType)) {
                return false;
            }
            PsiExpression operand = prefixExpression.getOperand();
            return operand instanceof PsiLiteralExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/ImplicitNumericConversionInspection$ImplicitNumericConversionFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/ImplicitNumericConversionInspection$ImplicitNumericConversionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

