/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class LongLiteralsEndingWithLowercaseLInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        return "LongLiteralEndingWithLowercaseL";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("long.literals.ending.with.lowercase.l.problem.descriptor", new Object[0]);
        if (string == null) {
            LongLiteralsEndingWithLowercaseLInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new LongLiteralWithLowercaseLVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new LongLiteralFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/LongLiteralsEndingWithLowercaseLInspection", "buildErrorString"));
    }

    private static class LongLiteralWithLowercaseLVisitor
    extends BaseInspectionVisitor {
        private LongLiteralWithLowercaseLVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                LongLiteralWithLowercaseLVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (!type.equals(PsiTypes.longType())) {
                return;
            }
            String text = expression.getText();
            if (text == null) {
                return;
            }
            int length = text.length();
            if (length == 0) {
                return;
            }
            if (text.charAt(length - 1) != 'l') {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/LongLiteralsEndingWithLowercaseLInspection$LongLiteralWithLowercaseLVisitor", "visitLiteralExpression"));
        }
    }

    private static class LongLiteralFix
    extends PsiUpdateModCommandQuickFix {
        private LongLiteralFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"l", "L"});
            if (string == null) {
                LongLiteralFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                LongLiteralFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                LongLiteralFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                LongLiteralFix.$$$reportNull$$$0(3);
            }
            PsiExpression literal = (PsiExpression)startElement;
            String text = literal.getText();
            String newText = text.replace('l', 'L');
            PsiReplacementUtil.replaceExpression(literal, newText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/LongLiteralsEndingWithLowercaseLInspection$LongLiteralFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/LongLiteralsEndingWithLowercaseLInspection$LongLiteralFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

