/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LossyConversionCompoundAssignmentInspection
extends BaseInspection {
    private static final Set<IElementType> SUPPORTED_SIGNS = Set.of(JavaTokenType.PLUSEQ, JavaTokenType.MINUSEQ, JavaTokenType.ASTERISKEQ, JavaTokenType.DIVEQ, JavaTokenType.ANDEQ, JavaTokenType.OREQ, JavaTokenType.XOREQ, JavaTokenType.PERCEQ);

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiType lType = (PsiType)infos[1];
        PsiExpression rExpression = (PsiExpression)infos[2];
        return LocalQuickFix.from((ModCommandAction)new AddTypeCastFix(lType, rExpression));
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType rType = (PsiType)infos[0];
        PsiType lType = (PsiType)infos[1];
        String string = InspectionGadgetsBundle.message("inspection.lossy.conversion.compound.assignment.display.name", rType.getCanonicalText(), lType.getCanonicalText());
        if (string == null) {
            LossyConversionCompoundAssignmentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(this){

            public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
                PsiJavaToken sign;
                IElementType tokenType;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((tokenType = (sign = expression.getOperationSign()).getTokenType()) == null || !SUPPORTED_SIGNS.contains(tokenType)) {
                    return;
                }
                PsiExpression rExpression = expression.getRExpression();
                PsiExpression lExpression = expression.getLExpression();
                if (rExpression == null) {
                    return;
                }
                PsiType lType = lExpression.getType();
                PsiType rType = rExpression.getType();
                if (lType == null || rType == null) {
                    return;
                }
                if (!(TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lType) && TypeConversionUtil.isNumericType((PsiType)lType) && TypeConversionUtil.isNumericType((PsiType)rType))) {
                    return;
                }
                if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)lType, (PsiExpression)rExpression) || !TypeConversionUtil.areTypesConvertible((PsiType)rType, (PsiType)lType)) {
                    return;
                }
                this.registerError((PsiElement)rExpression, rType, lType, rExpression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/LossyConversionCompoundAssignmentInspection$1", "visitAssignmentExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/LossyConversionCompoundAssignmentInspection", "buildErrorString"));
    }
}

