/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiTypes;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

class RemoveLeadingZeroFix
extends PsiUpdateModCommandQuickFix {
    RemoveLeadingZeroFix() {
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("remove.leading.zero.to.make.decimal.quickfix", new Object[0]);
        if (string == null) {
            RemoveLeadingZeroFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            RemoveLeadingZeroFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            RemoveLeadingZeroFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            RemoveLeadingZeroFix.$$$reportNull$$$0(3);
        }
        if (!(element instanceof PsiLiteralExpression)) {
            return;
        }
        PsiLiteralExpression literal = (PsiLiteralExpression)element;
        RemoveLeadingZeroFix.removeLeadingZeroes(literal);
    }

    static void removeLeadingZeroes(PsiLiteralExpression literal) {
        int index;
        String text = literal.getText();
        int max = text.length() - (PsiTypes.longType().equals((Object)literal.getType()) ? 2 : 1);
        if (max < 1) {
            return;
        }
        for (index = 0; index < max && (text.charAt(index) == '0' || text.charAt(index) == '_'); ++index) {
        }
        String textWithoutLeadingZeros = text.substring(index);
        PsiReplacementUtil.replaceExpression((PsiExpression)literal, textWithoutLeadingZeros);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/numeric/RemoveLeadingZeroFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/numeric/RemoveLeadingZeroFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

