/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class SuspiciousLiteralUnderscoreInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("suspicious.literal.underscore.problem.descriptor", new Object[0]);
        if (string == null) {
            SuspiciousLiteralUnderscoreInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousLiteralUnderscoreVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/SuspiciousLiteralUnderscoreInspection", "buildErrorString"));
    }

    private static class SuspiciousLiteralUnderscoreVisitor
    extends BaseInspectionVisitor {
        private SuspiciousLiteralUnderscoreVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                SuspiciousLiteralUnderscoreVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (!(PsiTypes.shortType().equals((Object)type) || PsiTypes.intType().equals((Object)type) || PsiTypes.longType().equals((Object)type) || PsiTypes.floatType().equals((Object)type) || PsiTypes.doubleType().equals((Object)type))) {
                return;
            }
            String text = expression.getText();
            if (text.startsWith("0") && !text.startsWith("0.")) {
                return;
            }
            if (!text.contains("_")) {
                return;
            }
            boolean underscore = false;
            boolean group = false;
            int dot = -1;
            int digit = 0;
            int index = StringUtil.indexOfAny((String)text, (String)"fledFLED");
            int length = index > 0 ? index : text.length();
            for (int i = 0; i < length; ++i) {
                char c = text.charAt(i);
                if (c == '_' || c == '.') {
                    if (underscore) {
                        return;
                    }
                    underscore = true;
                    if (digit != 3 && group || digit > 3) {
                        this.registerErrorAtOffset((PsiElement)expression, i - digit, digit, new Object[0]);
                    }
                    group = true;
                    digit = 0;
                    if (c != '.') continue;
                    dot = i;
                    continue;
                }
                if (Character.isDigit(c)) {
                    underscore = false;
                    ++digit;
                    continue;
                }
                return;
            }
            if (digit == 0) {
                return;
            }
            if (dot > 0 ? digit > 3 : digit != 3) {
                boolean completeFractional;
                int offset = length - digit;
                boolean bl = completeFractional = offset == dot + 1;
                if (!completeFractional) {
                    this.registerErrorAtOffset((PsiElement)expression, offset, digit, new Object[0]);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/SuspiciousLiteralUnderscoreInspection$SuspiciousLiteralUnderscoreVisitor", "visitLiteralExpression"));
        }
    }
}

