/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;

public final class ClassUnconnectedToPackageInspection
extends BaseGlobalInspection {
    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (refEntity == null) {
            ClassUnconnectedToPackageInspection.$$$reportNull$$$0(0);
        }
        if (analysisScope == null) {
            ClassUnconnectedToPackageInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            ClassUnconnectedToPackageInspection.$$$reportNull$$$0(2);
        }
        if (globalInspectionContext == null) {
            ClassUnconnectedToPackageInspection.$$$reportNull$$$0(3);
        }
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        RefEntity owner = refClass.getOwner();
        if (!(owner instanceof RefPackage)) {
            return null;
        }
        int numClasses = ClassUnconnectedToPackageInspection.getClassesCount(manager, owner);
        if (numClasses == 1) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(refClass);
        for (RefClass refClass2 : dependencies) {
            if (!ClassUnconnectedToPackageInspection.inSamePackage(refClass, refClass2)) continue;
            return null;
        }
        Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(refClass);
        for (RefClass dependent : dependents) {
            if (!ClassUnconnectedToPackageInspection.inSamePackage(refClass, dependent)) continue;
            return null;
        }
        PsiElement psiElement = UDeclarationKt.getAnchorPsi((UDeclaration)refClass.getUastElement());
        if (psiElement == null) {
            return null;
        }
        return new CommonProblemDescriptor[]{manager.createProblemDescriptor(psiElement, InspectionGadgetsBundle.message("class.unconnected.to.package.problem.descriptor", new Object[0]), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0])};
    }

    private static int getClassesCount(@NotNull InspectionManager manager, RefEntity owner) {
        if (manager == null) {
            ClassUnconnectedToPackageInspection.$$$reportNull$$$0(4);
        }
        return (Integer)ReadAction.compute(() -> {
            Project project = manager.getProject();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(owner.getQualifiedName());
            if (aPackage == null || aPackage.getSubPackages().length > 0) {
                return -1;
            }
            return aPackage.getClasses(GlobalSearchScope.projectScope((Project)project)).length;
        });
    }

    private static boolean inSamePackage(RefClass class1, RefClass class2) {
        return class1.getOwner() == class2.getOwner();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisScope";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/packaging/ClassUnconnectedToPackageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassesCount";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

