/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArraysAsListWithZeroOrOneArgumentInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Boolean isEmpty = (Boolean)infos[0];
        if (isEmpty.booleanValue()) {
            String string = InspectionGadgetsBundle.message("arrays.as.list.with.zero.arguments.problem.descriptor", new Object[0]);
            if (string == null) {
                ArraysAsListWithZeroOrOneArgumentInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("arrays.as.list.with.one.argument.problem.descriptor", new Object[0]);
        if (string == null) {
            ArraysAsListWithZeroOrOneArgumentInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        boolean isEmpty = (Boolean)infos[0];
        boolean suggestListOf = (Boolean)infos[1];
        return new ArraysAsListWithOneArgumentFix(isEmpty, suggestListOf);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayAsListWithOneArgumentVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ArraysAsListWithZeroOrOneArgumentInspection", "buildErrorString"));
    }

    private static final class ArraysAsListWithOneArgumentFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myEmpty;
        private final boolean mySuggestListOf;

        private ArraysAsListWithOneArgumentFix(boolean isEmpty, boolean suggestListOf) {
            this.myEmpty = isEmpty;
            this.mySuggestListOf = suggestListOf;
        }

        @NotNull
        public String getName() {
            if (this.mySuggestListOf) {
                String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"List.of()"});
                if (string == null) {
                    ArraysAsListWithOneArgumentFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            @NonNls String call = this.myEmpty ? "Collections.emptyList()" : "Collections.singletonList()";
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{call});
            if (string == null) {
                ArraysAsListWithOneArgumentFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
            if (string == null) {
                ArraysAsListWithOneArgumentFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            String parameterText;
            PsiElement element;
            if (project == null) {
                ArraysAsListWithOneArgumentFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ArraysAsListWithOneArgumentFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                ArraysAsListWithOneArgumentFix.$$$reportNull$$$0(5);
            }
            if (!((element = startElement.getParent().getParent()) instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiReferenceParameterList parameterList = methodExpression.getParameterList();
            CommentTracker commentTracker = new CommentTracker();
            String string = parameterText = parameterList != null ? commentTracker.text((PsiElement)parameterList) : "";
            if (this.myEmpty) {
                if (this.mySuggestListOf) {
                    PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, "java.util.List." + parameterText + "of()", commentTracker);
                } else {
                    PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, "java.util.Collections." + parameterText + "emptyList()", commentTracker);
                }
            } else {
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                if (this.mySuggestListOf) {
                    PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, "java.util.List." + parameterText + "of" + commentTracker.text((PsiElement)argumentList), commentTracker);
                } else {
                    PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, "java.util.Collections." + parameterText + "singletonList" + commentTracker.text((PsiElement)argumentList), commentTracker);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/ArraysAsListWithZeroOrOneArgumentInspection$ArraysAsListWithOneArgumentFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/ArraysAsListWithZeroOrOneArgumentInspection$ArraysAsListWithOneArgumentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ArrayAsListWithOneArgumentVisitor
    extends BaseInspectionVisitor {
        private ArrayAsListWithOneArgumentVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ArrayAsListWithOneArgumentVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if (!"asList".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length > 1) {
                return;
            }
            boolean suggestListOf = PsiUtil.isAvailable((JavaFeature)JavaFeature.COLLECTION_FACTORIES, (PsiElement)expression);
            boolean empty = false;
            if (arguments.length == 0) {
                empty = true;
            } else {
                PsiExpression argument = arguments[0];
                if (!MethodCallUtils.isVarArgCall((PsiCall)expression)) {
                    if (!ConstructionUtils.isEmptyArrayInitializer(argument)) {
                        return;
                    }
                    empty = true;
                }
                if (suggestListOf && NullabilityUtil.getExpressionNullability(argument, true) != Nullability.NOT_NULL) {
                    suggestListOf = false;
                }
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if (!"java.util.Arrays".equals(className)) {
                return;
            }
            this.registerMethodCallError(expression, empty, suggestListOf);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/ArraysAsListWithZeroOrOneArgumentInspection$ArrayAsListWithOneArgumentVisitor", "visitMethodCallExpression"));
        }
    }
}

