/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class BooleanConstructorInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        return "BooleanConstructorCall";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("boolean.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            BooleanConstructorInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanConstructorVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new BooleanConstructorFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/BooleanConstructorInspection", "buildErrorString"));
    }

    private static class BooleanConstructorVisitor
    extends BaseInspectionVisitor {
        private BooleanConstructorVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            String qualifiedName;
            if (expression == null) {
                BooleanConstructorVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (type == null || !type.equalsToText("java.lang.Boolean")) {
                return;
            }
            PsiClass aClass = PsiUtil.getContainingClass((PsiElement)expression);
            if (aClass != null && "java.lang.Boolean".equals(qualifiedName = aClass.getQualifiedName())) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length != 1) {
                return;
            }
            this.registerNewExpressionError(expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/BooleanConstructorInspection$BooleanConstructorVisitor", "visitNewExpression"));
        }
    }

    private static class BooleanConstructorFix
    extends PsiUpdateModCommandQuickFix {
        private static final String TRUE = "\"true\"";
        private static final String FALSE = "\"false\"";

        private BooleanConstructorFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("boolean.constructor.simplify.quickfix", new Object[0]);
            if (string == null) {
                BooleanConstructorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            String newExpression;
            PsiElement element;
            if (project == null) {
                BooleanConstructorFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                BooleanConstructorFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                BooleanConstructorFix.$$$reportNull$$$0(3);
            }
            if (!((element = startElement.getParent()) instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression expression = (PsiNewExpression)element;
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            String text = argument.getText();
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)expression);
            CommentTracker tracker = new CommentTracker();
            if ("true".equals(text) || TRUE.equalsIgnoreCase(text)) {
                newExpression = "java.lang.Boolean.TRUE";
            } else if ("false".equals(text) || FALSE.equalsIgnoreCase(text)) {
                newExpression = "java.lang.Boolean.FALSE";
            } else if (languageLevel.equals((Object)LanguageLevel.JDK_1_3)) {
                newExpression = BooleanConstructorFix.buildText(tracker.markUnchanged(argument), false);
            } else {
                PsiClass booleanClass = ClassUtils.findClass("java.lang.Boolean", (PsiElement)argument);
                boolean methodFound = false;
                if (booleanClass != null) {
                    PsiMethod[] methods;
                    for (PsiMethod method : methods = booleanClass.findMethodsByName("valueOf", false)) {
                        PsiParameterList parameterList = method.getParameterList();
                        PsiParameter[] parameters = parameterList.getParameters();
                        if (parameters.length == 0) continue;
                        PsiParameter parameter = parameters[0];
                        PsiType type = parameter.getType();
                        if (!PsiTypes.booleanType().equals((Object)type)) continue;
                        methodFound = true;
                        break;
                    }
                }
                newExpression = BooleanConstructorFix.buildText(tracker.markUnchanged(argument), methodFound);
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression, tracker);
        }

        @NonNls
        private static String buildText(PsiExpression argument, boolean useValueOf) {
            String text = argument.getText();
            PsiType argumentType = argument.getType();
            if (!useValueOf && PsiTypes.booleanType().equals((Object)argumentType)) {
                if (ParenthesesUtils.getPrecedence(argument) > 15) {
                    return text + "?java.lang.fBoolean.TRUE:java.lang.Boolean.FALSE";
                }
                return "(" + text + ")?java.lang.Boolean.TRUE:java.lang.Boolean.FALSE";
            }
            return "java.lang.Boolean.valueOf(" + text + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/BooleanConstructorInspection$BooleanConstructorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/BooleanConstructorInspection$BooleanConstructorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

