/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.performance.MethodReferenceVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public final class ClassInitializerMayBeStaticInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.initializer.may.be.static.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassInitializerMayBeStaticInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new ChangeModifierFix("static");
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ClassInitializerCanBeStaticVisitor();
    }

    public static boolean dependsOnInstanceMembers(PsiClassInitializer initializer) {
        MethodReferenceVisitor visitor2 = new MethodReferenceVisitor((PsiMember)initializer);
        initializer.accept((PsiElementVisitor)visitor2);
        return !visitor2.areReferencesStaticallyAccessible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ClassInitializerMayBeStaticInspection", "buildErrorString"));
    }

    private static class ClassInitializerCanBeStaticVisitor
    extends BaseInspectionVisitor {
        private ClassInitializerCanBeStaticVisitor() {
        }

        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            if (initializer == null) {
                ClassInitializerCanBeStaticVisitor.$$$reportNull$$$0(0);
            }
            if (initializer.hasModifierProperty("static")) {
                return;
            }
            PsiCodeBlock body = initializer.getBody();
            if (ControlFlowUtils.isEmptyCodeBlock(body)) {
                return;
            }
            PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)initializer);
            if (containingClass == null || containingClass instanceof PsiAnonymousClass) {
                return;
            }
            for (Condition addin : InspectionManager.CANT_BE_STATIC_EXTENSION.getExtensionList()) {
                if (!addin.value((Object)initializer)) continue;
                return;
            }
            PsiElement scope = containingClass.getScope();
            if (!(scope instanceof PsiJavaFile || containingClass.hasModifierProperty("static") || PsiUtil.isAvailable((JavaFeature)JavaFeature.INNER_STATICS, (PsiElement)containingClass))) {
                return;
            }
            if (ClassInitializerMayBeStaticInspection.dependsOnInstanceMembers(initializer)) {
                return;
            }
            this.registerClassInitializerError(initializer, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/siyeh/ig/performance/ClassInitializerMayBeStaticInspection$ClassInitializerCanBeStaticVisitor", "visitClassInitializer"));
        }
    }
}

