/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IfStatementMissingBreakInLoopInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("inspection.if.statement.missing.break.in.loop.description", new Object[0]);
        if (string == null) {
            IfStatementMissingBreakInLoopInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new IfStatementMissingBreakInLoopVisitor();
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new IfStatementMissingBreakInLoopFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/IfStatementMissingBreakInLoopInspection", "buildErrorString"));
    }

    private static class IfStatementMissingBreakInLoopVisitor
    extends BaseInspectionVisitor {
        private IfStatementMissingBreakInLoopVisitor() {
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            PsiStatement body;
            if (statement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(0);
            }
            if ((body = statement.getBody()) == null) {
                return;
            }
            PsiParameter parameter = statement.getIterationParameter();
            HashSet<PsiVariable> nonFinalVariables = new HashSet<PsiVariable>();
            nonFinalVariables.add((PsiVariable)parameter);
            HashSet<PsiVariable> declaredVariables = new HashSet<PsiVariable>();
            declaredVariables.add((PsiVariable)parameter);
            this.visitLoopBody(body, nonFinalVariables, declaredVariables);
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            PsiStatement update;
            PsiStatement body;
            if (statement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(1);
            }
            if ((body = statement.getBody()) == null) {
                return;
            }
            HashSet<PsiVariable> nonFinalVariables = new HashSet<PsiVariable>();
            HashSet<PsiVariable> declaredVariables = new HashSet<PsiVariable>();
            PsiDeclarationStatement initialization = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)statement.getInitialization(), PsiDeclarationStatement.class);
            if (initialization != null) {
                IfStatementMissingBreakInLoopVisitor.collectVariables(initialization, (PsiStatement)statement, nonFinalVariables, declaredVariables);
            }
            if ((update = statement.getUpdate()) != null && IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)update, declaredVariables)) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            if (condition != null && IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)condition, declaredVariables)) {
                return;
            }
            this.visitLoopBody(body, nonFinalVariables, declaredVariables);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(2);
            }
            this.visitLoopStatement((PsiConditionalLoopStatement)statement);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(3);
            }
            this.visitLoopStatement((PsiConditionalLoopStatement)statement);
        }

        private void visitLoopStatement(@NotNull PsiConditionalLoopStatement loopStatement) {
            PsiStatement body;
            if (loopStatement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(4);
            }
            if ((body = loopStatement.getBody()) == null) {
                return;
            }
            HashSet<PsiVariable> nonFinalVariables = new HashSet<PsiVariable>();
            HashSet<PsiVariable> declaredVariables = new HashSet<PsiVariable>();
            PsiExpression condition = loopStatement.getCondition();
            if (condition != null) {
                if (IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)condition, declaredVariables)) {
                    return;
                }
                Set<PsiVariable> conditionVariables = VariableAccessUtils.collectUsedVariables((PsiElement)condition);
                declaredVariables.addAll(conditionVariables);
                nonFinalVariables.addAll(conditionVariables);
            }
            this.visitLoopBody(body, nonFinalVariables, declaredVariables);
        }

        private void visitLoopBody(@NotNull PsiStatement loopBody, @NotNull Set<PsiVariable> nonFinalVariables, @NotNull Set<PsiVariable> declaredVariables) {
            PsiStatement[] statements;
            if (loopBody == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(5);
            }
            if (nonFinalVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(6);
            }
            if (declaredVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(7);
            }
            if (!IfStatementMissingBreakInLoopVisitor.hasMissingBreakCandidates(statements = IfStatementMissingBreakInLoopVisitor.getStatements(loopBody))) {
                return;
            }
            PsiIfStatement ifStatementMissingBreak = null;
            for (PsiStatement statement : statements) {
                if (statement instanceof PsiDeclarationStatement) {
                    IfStatementMissingBreakInLoopVisitor.collectVariables((PsiDeclarationStatement)statement, loopBody, nonFinalVariables, declaredVariables);
                } else if (statement instanceof PsiIfStatement) {
                    PsiIfStatement ifStatement = (PsiIfStatement)statement;
                    PsiExpression condition = ifStatement.getCondition();
                    if (condition == null || IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)condition, declaredVariables)) {
                        return;
                    }
                    if (IfStatementMissingBreakInLoopVisitor.isMissingBreak(ifStatement, nonFinalVariables, declaredVariables)) {
                        if (ifStatementMissingBreak != null) {
                            return;
                        }
                        ifStatementMissingBreak = ifStatement;
                        continue;
                    }
                }
                if (!IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)statement, declaredVariables)) continue;
                return;
            }
            if (ifStatementMissingBreak == null) {
                return;
            }
            this.registerError(ifStatementMissingBreak.getFirstChild(), new Object[0]);
        }

        private static boolean hasMissingBreakCandidates(PsiStatement[] statements) {
            return Arrays.stream(statements).filter(s -> s instanceof PsiIfStatement).map(s -> IfStatementMissingBreakInLoopVisitor.getStatements((PsiIfStatement)s)).filter(ss -> ((PsiStatement[])ss).length != 0).anyMatch(ss -> Arrays.stream(ss).allMatch(s -> IfStatementMissingBreakInLoopVisitor.getAssignment(s) != null));
        }

        private static PsiStatement @NotNull [] getStatements(@NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(8);
            }
            if (ifStatement.getElseBranch() != null) {
                if (PsiStatement.EMPTY_ARRAY == null) {
                    IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(9);
                }
                return PsiStatement.EMPTY_ARRAY;
            }
            PsiStatement branch = ifStatement.getThenBranch();
            if (branch == null) {
                if (PsiStatement.EMPTY_ARRAY == null) {
                    IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(10);
                }
                return PsiStatement.EMPTY_ARRAY;
            }
            return IfStatementMissingBreakInLoopVisitor.getStatements(branch);
        }

        @Nullable
        private static PsiAssignmentExpression getAssignment(@NotNull PsiStatement statement) {
            if (statement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(11);
            }
            if (!(statement instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression expression = ((PsiExpressionStatement)statement).getExpression();
            if (!(expression instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            if (!JavaTokenType.EQ.equals(assignment.getOperationTokenType())) {
                return null;
            }
            return assignment;
        }

        private static boolean isMissingBreak(@NotNull PsiIfStatement ifStatement, @NotNull Set<PsiVariable> nonFinalVariables, @NotNull Set<PsiVariable> declaredVariables) {
            PsiStatement[] statements;
            if (ifStatement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(12);
            }
            if (nonFinalVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(13);
            }
            if (declaredVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(14);
            }
            if ((statements = IfStatementMissingBreakInLoopVisitor.getStatements(ifStatement)).length == 0) {
                return false;
            }
            HashSet<PsiVariable> usedVariables = new HashSet<PsiVariable>();
            for (PsiStatement statement : statements) {
                PsiAssignmentExpression assignment = IfStatementMissingBreakInLoopVisitor.getAssignment(statement);
                if (assignment == null) {
                    return false;
                }
                PsiExpression lhs = assignment.getLExpression();
                Set<PsiVariable> lhsVariables = VariableAccessUtils.collectUsedVariables((PsiElement)lhs);
                if (IfStatementMissingBreakInLoopVisitor.haveCommonElements(lhsVariables, nonFinalVariables) || IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)lhs, declaredVariables)) {
                    return false;
                }
                PsiExpression rhs = assignment.getRExpression();
                if (rhs == null) {
                    return false;
                }
                Set<PsiVariable> rhsVariables = VariableAccessUtils.collectUsedVariables((PsiElement)rhs);
                if (IfStatementMissingBreakInLoopVisitor.haveCommonElements(rhsVariables, nonFinalVariables) || IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)rhs, declaredVariables)) {
                    return false;
                }
                usedVariables.addAll(rhsVariables);
                if (usedVariables.addAll(lhsVariables)) continue;
                return false;
            }
            return true;
        }

        private static boolean haveCommonElements(Set<PsiVariable> s1, Set<PsiVariable> s2) {
            return !Collections.disjoint(s2, s1);
        }

        private static void collectVariables(@NotNull PsiDeclarationStatement declaration, @NotNull PsiStatement scope, @NotNull Set<PsiVariable> nonFinalVariables, @NotNull Set<? super PsiVariable> declaredVariables) {
            if (declaration == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(15);
            }
            if (scope == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(16);
            }
            if (nonFinalVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(17);
            }
            if (declaredVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(18);
            }
            Set<PsiVariable> usedVariables = VariableAccessUtils.collectUsedVariables((PsiElement)declaration);
            boolean hasNonFinalVariables = IfStatementMissingBreakInLoopVisitor.haveCommonElements(usedVariables, nonFinalVariables);
            for (PsiElement element : declaration.getDeclaredElements()) {
                if (!(element instanceof PsiVariable)) continue;
                PsiVariable variable = (PsiVariable)element;
                declaredVariables.add((PsiVariable)variable);
                if (!hasNonFinalVariables && ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)scope)) continue;
                nonFinalVariables.add(variable);
            }
        }

        private static PsiStatement @NotNull [] getStatements(@NotNull PsiStatement statement) {
            if (statement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(19);
            }
            if (statement instanceof PsiBlockStatement) {
                PsiStatement[] psiStatementArray = ((PsiBlockStatement)statement).getCodeBlock().getStatements();
                if (psiStatementArray == null) {
                    IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(20);
                }
                return psiStatementArray;
            }
            PsiStatement[] psiStatementArray = new PsiStatement[]{statement};
            if (psiStatementArray == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(21);
            }
            return psiStatementArray;
        }

        private static boolean mayHaveOutsideOfLoopSideEffects(@NotNull PsiElement element, @NotNull Set<PsiVariable> declaredVariables) {
            if (element == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(22);
            }
            if (declaredVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(23);
            }
            return SideEffectChecker.mayHaveSideEffects(element, e -> IfStatementMissingBreakInLoopVisitor.isLoopOnlySideEffect(e, declaredVariables));
        }

        private static boolean isLoopOnlySideEffect(PsiElement e, @NotNull Set<PsiVariable> declaredVariables) {
            if (declaredVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(24);
            }
            if (e instanceof PsiContinueStatement || e instanceof PsiBreakStatement || e instanceof PsiVariable) {
                return true;
            }
            PsiExpression operand = null;
            if (e instanceof PsiUnaryExpression) {
                operand = ((PsiUnaryExpression)e).getOperand();
            } else if (e instanceof PsiAssignmentExpression) {
                operand = ((PsiAssignmentExpression)e).getLExpression();
            }
            if (operand == null) {
                return false;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)(operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand)), PsiReferenceExpression.class);
            if (ref != null) {
                return IfStatementMissingBreakInLoopVisitor.isDeclaredVariable(ref.resolve(), declaredVariables);
            }
            PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)operand, PsiArrayAccessExpression.class);
            if (arrayAccess == null) {
                return true;
            }
            return IfStatementMissingBreakInLoopVisitor.loopOnlyVariablesChanged(arrayAccess, declaredVariables);
        }

        private static boolean loopOnlyVariablesChanged(@NotNull PsiArrayAccessExpression arrayAccess, @NotNull Set<PsiVariable> declaredVariables) {
            if (arrayAccess == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(25);
            }
            if (declaredVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(26);
            }
            return ExpressionUtils.nonStructuralChildren(arrayAccess.getArrayExpression()).allMatch(child -> {
                PsiArrayAccessExpression childArrayAccess = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)child, PsiArrayAccessExpression.class);
                if (childArrayAccess != null) {
                    return IfStatementMissingBreakInLoopVisitor.loopOnlyVariablesChanged(childArrayAccess, declaredVariables);
                }
                PsiReferenceExpression childRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)child, PsiReferenceExpression.class);
                if (childRef != null) {
                    return IfStatementMissingBreakInLoopVisitor.isDeclaredVariable(childRef.resolve(), declaredVariables);
                }
                return true;
            });
        }

        private static boolean isDeclaredVariable(PsiElement element, Set<PsiVariable> declaredVariables) {
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)element, PsiVariable.class);
            return variable == null || declaredVariables.contains(variable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 9, 10, 20, 21 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopStatement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopBody";
                    break;
                }
                case 6: 
                case 13: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nonFinalVariables";
                    break;
                }
                case 7: 
                case 14: 
                case 18: 
                case 23: 
                case 24: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaredVariables";
                    break;
                }
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 9: 
                case 10: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/IfStatementMissingBreakInLoopInspection$IfStatementMissingBreakInLoopVisitor";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayAccess";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/IfStatementMissingBreakInLoopInspection$IfStatementMissingBreakInLoopVisitor";
                    break;
                }
                case 9: 
                case 10: 
                case 20: 
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitForeachStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitForStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitWhileStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitDoWhileStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLoopStatement";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLoopBody";
                    break;
                }
                case 8: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatements";
                    break;
                }
                case 9: 
                case 10: 
                case 20: 
                case 21: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getAssignment";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "isMissingBreak";
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "collectVariables";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "mayHaveOutsideOfLoopSideEffects";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "isLoopOnlySideEffect";
                    break;
                }
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "loopOnlyVariablesChanged";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 9, 10, 20, 21 -> new IllegalStateException(string);
            };
        }
    }

    private static class IfStatementMissingBreakInLoopFix
    extends PsiUpdateModCommandQuickFix {
        private IfStatementMissingBreakInLoopFix() {
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiIfStatement ifStatement;
            if (project == null) {
                IfStatementMissingBreakInLoopFix.$$$reportNull$$$0(0);
            }
            if (startElement == null) {
                IfStatementMissingBreakInLoopFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                IfStatementMissingBreakInLoopFix.$$$reportNull$$$0(2);
            }
            if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)startElement.getParent(), PsiIfStatement.class)) == null || ifStatement.getElseBranch() != null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiStatement breakStatement = factory.createStatementFromText("break;", null);
            PsiCodeBlock block = IfStatementMissingBreakInLoopFix.getBlock(thenBranch);
            if (block == null) {
                return;
            }
            block.addBefore((PsiElement)breakStatement, block.getLastChild());
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)ifStatement);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.if.statement.missing.break.in.loop.quickfix", new Object[0]);
            if (string == null) {
                IfStatementMissingBreakInLoopFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        private static PsiCodeBlock getBlock(@NotNull PsiStatement thenBranch) {
            if (thenBranch == null) {
                IfStatementMissingBreakInLoopFix.$$$reportNull$$$0(4);
            }
            if (thenBranch instanceof PsiBlockStatement) {
                return ((PsiBlockStatement)thenBranch).getCodeBlock();
            }
            PsiStatement statementInBlock = BlockUtils.expandSingleStatementToBlockStatement((PsiStatement)thenBranch);
            return (PsiCodeBlock)ObjectUtils.tryCast((Object)statementInBlock.getParent(), PsiCodeBlock.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/IfStatementMissingBreakInLoopInspection$IfStatementMissingBreakInLoopFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenBranch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/IfStatementMissingBreakInLoopInspection$IfStatementMissingBreakInLoopFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getBlock";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

