/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KeySetIterationMayUseEntrySetInspection
extends BaseInspection {
    private static final CallMatcher ITERABLE_FOR_EACH = CallMatcher.instanceCall("java.lang.Iterable", "forEach").parameterTypes("java.util.function.Consumer");
    private static final CallMatcher MAP_KEY_SET = CallMatcher.instanceCall("java.util.Map", "keySet").parameterCount(0);
    private static final CallMatcher MAP_GET = CallMatcher.instanceCall("java.util.Map", "get").parameterTypes("java.lang.Object");

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        ReplacementMode mode = (ReplacementMode)((Object)infos[0]);
        String string = InspectionGadgetsBundle.message("key.set.iteration.may.use.entry.set.problem.descriptor", mode.myDisplayName);
        if (string == null) {
            KeySetIterationMayUseEntrySetInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new KeySetIterationMapUseEntrySetFix((ReplacementMode)((Object)infos[0]));
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new KeySetIterationMayUseEntrySetVisitor();
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiExpression getIteratedExpression(PsiExpression iteratedValue) {
        PsiLocalVariable variable = ExpressionUtils.resolveLocalVariable(iteratedValue);
        if (variable != null) {
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiMethod.class);
            if (VariableAccessUtils.variableIsAssignedAtPoint((PsiVariable)variable, (PsiElement)containingMethod, (PsiElement)iteratedValue)) {
                return null;
            }
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer());
        }
        return iteratedValue;
    }

    @Contract(value="null -> null")
    private static PsiReferenceExpression getMapReferenceFromKeySetCall(PsiExpression keySetCandidate) {
        if (!(keySetCandidate instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)keySetCandidate;
        if (!MAP_KEY_SET.test(methodCallExpression)) {
            return null;
        }
        PsiExpression qualifier = methodCallExpression.getMethodExpression().getQualifierExpression();
        return (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier), PsiReferenceExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection", "buildErrorString"));
    }

    private static enum ReplacementMode {
        FOR_EACH("Map.forEach()"),
        VALUES("values()"),
        ENTRY_SET("entrySet()");

        @NlsSafe
        private final String myDisplayName;

        private ReplacementMode(String displayName) {
            this.myDisplayName = displayName;
        }
    }

    private static class KeySetIterationMapUseEntrySetFix
    extends PsiUpdateModCommandQuickFix {
        private final ReplacementMode myMode;

        KeySetIterationMapUseEntrySetFix(ReplacementMode mode) {
            this.myMode = mode;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myMode.myDisplayName});
            if (string == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("key.set.iteration.may.use.entry.set.quickfix", new Object[0]);
            if (string == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiExpression keySetExpression;
            PsiLocalVariable toRemove;
            PsiExpression expression;
            if (project == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(4);
            }
            if ((expression = (PsiExpression)ObjectUtils.tryCast((Object)startElement, PsiExpression.class)) == null) {
                return;
            }
            if (expression instanceof PsiReferenceExpression) {
                toRemove = ExpressionUtils.resolveLocalVariable(expression);
                if (toRemove == null) {
                    return;
                }
                keySetExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)toRemove.getInitializer());
            } else {
                toRemove = null;
                keySetExpression = expression;
            }
            PsiReferenceExpression mapRef = KeySetIterationMayUseEntrySetInspection.getMapReferenceFromKeySetCall(keySetExpression);
            if (mapRef == null) {
                return;
            }
            if (this.myMode == ReplacementMode.FOR_EACH) {
                KeySetIterationMapUseEntrySetFix.processLambda(project, expression, mapRef);
            } else {
                KeySetIterationMapUseEntrySetFix.processLoop(project, expression, mapRef, this.myMode);
            }
            if (toRemove != null && VariableAccessUtils.getVariableReferences((PsiVariable)toRemove).isEmpty()) {
                PsiDeclarationStatement declaration;
                PsiElement psiElement = toRemove.getParent();
                if (psiElement instanceof PsiDeclarationStatement && (declaration = (PsiDeclarationStatement)psiElement).getDeclaredElements().length == 1) {
                    declaration.delete();
                } else {
                    toRemove.delete();
                }
            }
        }

        private static void processLambda(Project project, PsiExpression iteratedValue, PsiReferenceExpression mapRef) {
            PsiMethodCallExpression forEachCall = ExpressionUtils.getCallForQualifier(iteratedValue);
            if (!ITERABLE_FOR_EACH.test(forEachCall)) {
                return;
            }
            PsiExpression[] args = forEachCall.getArgumentList().getExpressions();
            PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), PsiLambdaExpression.class);
            if (lambda == null) {
                return;
            }
            PsiParameterList parameterList = lambda.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiElement lambdaBody = lambda.getBody();
            if (lambdaBody == null) {
                return;
            }
            PsiParameter keyParameter = Objects.requireNonNull(parameterList.getParameter(0));
            mapRef = (PsiReferenceExpression)new CommentTracker().replaceAndRestoreComments((PsiElement)iteratedValue, (PsiElement)mapRef);
            PsiType valueType = PsiUtil.substituteTypeParameter((PsiType)mapRef.getType(), (String)"java.util.Map", (int)1, (boolean)true);
            List<PsiExpression> accesses = ParameterAccessCollector.collectParameterAccesses(keyParameter, mapRef, lambdaBody);
            String valueName = KeySetIterationMapUseEntrySetFix.tryReuseValueVariable(lambdaBody, accesses, valueType);
            if (valueName == null) {
                valueName = new VariableNameGenerator(lambdaBody, VariableKind.PARAMETER).byType(valueType).byName("k".equals(keyParameter.getName()) ? "v" : "value").generate(false);
            }
            for (PsiExpression access : accesses) {
                if (!(access instanceof PsiMethodCallExpression) || !access.isValid()) continue;
                new CommentTracker().replaceAndRestoreComments((PsiElement)access, valueName);
            }
            String newLambdaText = "(" + keyParameter.getName() + "," + valueName + ")->" + lambdaBody.getText();
            PsiExpression newLambda = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newLambdaText, (PsiElement)lambda);
            lambda.replace((PsiElement)newLambda);
        }

        private static String tryReuseValueVariable(PsiElement scope, List<PsiExpression> accesses, PsiType wantedType) {
            for (PsiExpression access : accesses) {
                PsiLocalVariable var;
                PsiElement varParent;
                PsiElement parent;
                if (!(access instanceof PsiMethodCallExpression) || !((parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)access)) instanceof PsiLocalVariable) || !((varParent = (var = (PsiLocalVariable)parent).getParent()) instanceof PsiDeclarationStatement) || varParent.getParent() != scope || !var.getType().equals(wantedType) || VariableAccessUtils.variableIsAssigned((PsiVariable)var, scope)) continue;
                String valueName = var.getName();
                new CommentTracker().deleteAndRestoreComments((PsiElement)var);
                return valueName;
            }
            return null;
        }

        private static void processLoop(Project project, PsiExpression iteratedValue, PsiReferenceExpression mapRef, ReplacementMode mode) {
            PsiCodeBlock codeBlock;
            PsiJavaToken brace;
            Object replacement;
            PsiModifierList modifierList;
            PsiForeachStatement foreachStatement = (PsiForeachStatement)ObjectUtils.tryCast((Object)ParenthesesUtils.getParentSkipParentheses((PsiElement)iteratedValue), PsiForeachStatement.class);
            if (foreachStatement == null) {
                return;
            }
            PsiMethodCallExpression newIterationValue = (PsiMethodCallExpression)new CommentTracker().replaceAndRestoreComments((PsiElement)iteratedValue, mapRef.getText() + "." + mode.myDisplayName);
            mapRef = (PsiReferenceExpression)newIterationValue.getMethodExpression().getQualifierExpression();
            PsiType collectionType = newIterationValue.getType();
            PsiType newParameterType = GenericsUtil.getVariableTypeByExpressionType((PsiType)PsiUtil.substituteTypeParameter((PsiType)collectionType, (String)"java.util.Collection", (int)0, (boolean)true));
            boolean insertCast = false;
            if (newParameterType == null) {
                newParameterType = TypeUtils.getObjectType((PsiElement)foreachStatement);
                insertCast = mode == ReplacementMode.ENTRY_SET;
            }
            PsiParameter keyParameter = foreachStatement.getIterationParameter();
            String keyParameterText = keyParameter.getText();
            String keyTypeText = keyParameter.getType().getCanonicalText();
            PsiStatement body = Objects.requireNonNull(foreachStatement.getBody());
            List accesses = ParameterAccessCollector.collectParameterAccesses(keyParameter, mapRef, (PsiElement)body);
            String loopParameterName = null;
            if (mode == ReplacementMode.VALUES && body instanceof PsiBlockStatement) {
                loopParameterName = KeySetIterationMapUseEntrySetFix.tryReuseValueVariable((PsiElement)((PsiBlockStatement)body).getCodeBlock(), accesses, newParameterType);
            }
            if (loopParameterName == null) {
                loopParameterName = KeySetIterationMapUseEntrySetFix.createNewVariableName((PsiElement)foreachStatement, newParameterType, mode);
            }
            PsiParameter loopParameter = JavaPsiFacade.getElementFactory((Project)project).createParameter(loopParameterName, newParameterType);
            if (keyParameter.hasModifierProperty("final") && (modifierList = loopParameter.getModifierList()) != null) {
                modifierList.setModifierProperty("final", true);
            }
            keyParameter.replace((PsiElement)loopParameter);
            Object object = replacement = insertCast ? "((java.util.Map.Entry)" + loopParameterName + ")" : loopParameterName;
            if (body instanceof PsiBlockStatement && accesses.stream().filter(access -> !(access instanceof PsiMethodCallExpression)).count() > 1L && (brace = (codeBlock = ((PsiBlockStatement)body).getCodeBlock()).getLBrace()) != null) {
                String keyVariableText = keyParameterText + "=" + (String)replacement + ".getKey();";
                PsiStatement keyDeclaration = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(keyVariableText, (PsiElement)body);
                codeBlock.addAfter((PsiElement)keyDeclaration, (PsiElement)brace);
                accesses = ContainerUtil.filterIsInstance(accesses, PsiMethodCallExpression.class);
            }
            KeySetIterationMapUseEntrySetFix.replaceParameterAccess(accesses, keyTypeText, (String)replacement, mode);
        }

        private static void replaceParameterAccess(@NotNull List<PsiExpression> accesses, @NotNull String typeText, @NonNls String variableName, @NotNull ReplacementMode mode) {
            if (accesses == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(5);
            }
            if (typeText == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(6);
            }
            if (mode == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(7);
            }
            String keyAccess = "(" + typeText + ")" + variableName + ".getKey()";
            for (PsiExpression access : accesses) {
                if (access instanceof PsiMethodCallExpression) {
                    if (!access.isValid()) continue;
                    Object replacement = mode == ReplacementMode.VALUES ? variableName : variableName + ".getValue()";
                    PsiReplacementUtil.replaceExpression(access, (String)replacement);
                    continue;
                }
                assert (mode == ReplacementMode.ENTRY_SET);
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)PsiReplacementUtil.replaceExpressionAndShorten(access, keyAccess);
                if (!RedundantCastUtil.isCastRedundant(typeCastExpression)) continue;
                PsiExpression operand = typeCastExpression.getOperand();
                assert (operand != null);
                PsiElement parent = typeCastExpression.getParent();
                typeCastExpression.replace((PsiElement)operand);
                if (!(parent instanceof PsiParenthesizedExpression)) continue;
                ParenthesesUtils.removeParentheses((PsiCaseLabelElement)((PsiExpression)parent), false);
            }
        }

        @NotNull
        private static String createNewVariableName(@NotNull PsiElement scope, @NotNull PsiType type, ReplacementMode mode) {
            if (scope == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(8);
            }
            if (type == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(9);
            }
            VariableNameGenerator generator = new VariableNameGenerator(scope, VariableKind.LOCAL_VARIABLE);
            if (mode == ReplacementMode.VALUES) {
                generator.byType(type).byName("value", "val", "v");
            } else {
                generator.byName("entry", "e").byType(type);
            }
            String string = generator.generate(true);
            if (string == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accesses";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeText";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewVariableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceParameterAccess";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewVariableName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
            };
        }

        private static class ParameterAccessCollector
        extends JavaRecursiveElementWalkingVisitor {
            private final PsiReferenceExpression myMapReference;
            private final PsiParameter myParameter;
            private final List<PsiExpression> myParameterAccesses = new ArrayList<PsiExpression>();

            ParameterAccessCollector(PsiParameter parameter, PsiReferenceExpression mapReference) {
                this.myParameter = parameter;
                this.myMapReference = mapReference;
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    ParameterAccessCollector.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(expression);
                if (expression.getQualifierExpression() != null || !expression.isReferenceTo((PsiElement)this.myParameter)) {
                    return;
                }
                if (!this.collectValueUsage(expression)) {
                    this.myParameterAccesses.add((PsiExpression)expression);
                }
            }

            private boolean collectValueUsage(PsiReferenceExpression expression) {
                PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
                if (!(parent instanceof PsiExpressionList)) {
                    return false;
                }
                PsiElement grandParent = parent.getParent();
                if (!(grandParent instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                if (!MAP_GET.test(methodCallExpression)) {
                    return false;
                }
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodCallExpression.getMethodExpression().getQualifierExpression());
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)this.myMapReference, (PsiExpression)referenceExpression)) {
                    return false;
                }
                this.myParameterAccesses.add((PsiExpression)methodCallExpression);
                return true;
            }

            List<PsiExpression> getParameterAccesses() {
                Collections.reverse(this.myParameterAccesses);
                return this.myParameterAccesses;
            }

            static List<PsiExpression> collectParameterAccesses(PsiParameter parameter, PsiReferenceExpression mapReference, PsiElement body) {
                ParameterAccessCollector collector = new ParameterAccessCollector(parameter, mapReference);
                body.accept((PsiElementVisitor)collector);
                return collector.getParameterAccesses();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix$ParameterAccessCollector", "visitReferenceExpression"));
            }
        }
    }

    private static class KeySetIterationMayUseEntrySetVisitor
    extends BaseInspectionVisitor {
        private KeySetIterationMayUseEntrySetVisitor() {
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                KeySetIterationMayUseEntrySetVisitor.$$$reportNull$$$0(0);
            }
            super.visitForeachStatement(statement);
            PsiExpression iteratedValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getIteratedValue());
            PsiExpression iteratedExpression = KeySetIterationMayUseEntrySetInspection.getIteratedExpression(iteratedValue);
            if (iteratedExpression == null) {
                return;
            }
            PsiParameter parameter = statement.getIterationParameter();
            PsiStatement context = statement.getBody();
            if (context == null) {
                return;
            }
            PsiReferenceExpression mapExpression = KeySetIterationMayUseEntrySetInspection.getMapReferenceFromKeySetCall(iteratedExpression);
            if (mapExpression == null) {
                return;
            }
            GetValueFromMapChecker checker = new GetValueFromMapChecker(mapExpression, (PsiVariable)parameter);
            context.accept((PsiElementVisitor)checker);
            if (checker.isGetValueFromMap()) {
                this.registerError((PsiElement)iteratedValue, new Object[]{checker.isKeyUsedExplicitly() ? ReplacementMode.ENTRY_SET : ReplacementMode.VALUES});
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                KeySetIterationMayUseEntrySetVisitor.$$$reportNull$$$0(1);
            }
            if (!ITERABLE_FOR_EACH.test(call)) {
                return;
            }
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
            PsiExpression expression = KeySetIterationMayUseEntrySetInspection.getIteratedExpression(qualifier);
            PsiReferenceExpression mapExpression = KeySetIterationMayUseEntrySetInspection.getMapReferenceFromKeySetCall(expression);
            if (mapExpression == null) {
                return;
            }
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]);
            PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)arg, PsiLambdaExpression.class);
            if (lambda == null) {
                return;
            }
            PsiParameter[] parameters = lambda.getParameterList().getParameters();
            if (parameters.length != 1) {
                return;
            }
            PsiElement body = lambda.getBody();
            if (body == null) {
                return;
            }
            PsiParameter key = parameters[0];
            GetValueFromMapChecker checker = new GetValueFromMapChecker(mapExpression, (PsiVariable)key);
            body.accept((PsiElementVisitor)checker);
            if (!checker.isGetValueFromMap()) {
                return;
            }
            this.registerError((PsiElement)qualifier, new Object[]{ReplacementMode.FOR_EACH});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMayUseEntrySetVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GetValueFromMapChecker
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiVariable myKey;
        private final PsiReferenceExpression myMapReference;
        private boolean myGetValueFromMap;
        private boolean myKeyUsedExplicitly;
        private boolean myTainted;

        GetValueFromMapChecker(@NotNull PsiReferenceExpression mapReference, @NotNull PsiVariable key) {
            if (mapReference == null) {
                GetValueFromMapChecker.$$$reportNull$$$0(0);
            }
            if (key == null) {
                GetValueFromMapChecker.$$$reportNull$$$0(1);
            }
            this.myMapReference = mapReference;
            this.myKey = key;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                GetValueFromMapChecker.$$$reportNull$$$0(2);
            }
            super.visitReferenceExpression(expression);
            if (PsiUtil.isAccessedForWriting((PsiExpression)expression) && (expression.isReferenceTo((PsiElement)this.myKey) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)this.myMapReference, (PsiExpression)expression))) {
                this.myTainted = true;
                this.stopWalking();
            }
            if (!expression.isReferenceTo((PsiElement)this.myKey)) {
                return;
            }
            if (this.isMapGetArgument(expression)) {
                this.myGetValueFromMap = true;
            } else {
                this.myKeyUsedExplicitly = true;
            }
        }

        private boolean isMapGetArgument(PsiReferenceExpression arg) {
            PsiExpressionList argList = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)arg.getParent()), PsiExpressionList.class);
            if (argList == null || argList.getExpressionCount() != 1) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)argList.getParent(), PsiMethodCallExpression.class);
            if (!MAP_GET.test(call)) {
                return false;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)this.myMapReference, qualifier);
        }

        boolean isKeyUsedExplicitly() {
            return this.myKeyUsedExplicitly;
        }

        boolean isGetValueFromMap() {
            return this.myGetValueFromMap && !this.myTainted;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$GetValueFromMapChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

