/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.EqualsToEqualityFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectEqualsCanBeEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Boolean negated = (Boolean)infos[0];
        String string = negated != false ? InspectionGadgetsBundle.message("not.object.equals.can.be.equality.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("object.equals.can.be.equality.problem.descriptor", new Object[0]);
        if (string == null) {
            ObjectEqualsCanBeEqualityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        Boolean not = (Boolean)infos[0];
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[1];
        return EqualsToEqualityFix.buildFix(methodCallExpression, not);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectEqualsMayBeEqualityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ObjectEqualsCanBeEqualityInspection", "buildErrorString"));
    }

    private static class ObjectEqualsMayBeEqualityVisitor
    extends BaseInspectionVisitor {
        private ObjectEqualsMayBeEqualityVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            ProblemHighlightType highlightType;
            PsiExpression right;
            if (expression == null) {
                ObjectEqualsMayBeEqualityVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            EqualityCheck check = EqualityCheck.from((PsiExpression)expression);
            if (check == null) {
                return;
            }
            PsiExpression left = check.getLeft();
            if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)JavaTokenType.EQEQ, (PsiExpression)left, (PsiExpression)(right = check.getRight()), (boolean)false)) {
                return;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)left.getType());
            if (aClass != null && aClass.isEnum()) {
                return;
            }
            if (ClassUtils.isFinalClassWithDefaultEquals(aClass)) {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            } else {
                if (!this.isOnTheFly()) {
                    return;
                }
                highlightType = ProblemHighlightType.INFORMATION;
            }
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
            boolean negated = parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
            PsiElement nameToken = expression.getMethodExpression().getReferenceNameElement();
            assert (nameToken != null);
            this.registerError(nameToken, highlightType, new Object[]{negated, expression});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/ObjectEqualsCanBeEqualityInspection$ObjectEqualsMayBeEqualityVisitor", "visitMethodCallExpression"));
        }
    }
}

