/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public final class StringBufferMustHaveInitialCapacityInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "StringBufferWithoutInitialCapacity";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.buffer.must.have.initial.capacity.problem.descriptor", new Object[0]);
        if (string == null) {
            StringBufferMustHaveInitialCapacityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferInitialCapacityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringBufferMustHaveInitialCapacityInspection", "buildErrorString"));
    }

    private static class StringBufferInitialCapacityVisitor
    extends BaseInspectionVisitor {
        private StringBufferInitialCapacityVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                StringBufferInitialCapacityVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (!TypeUtils.typeEquals("java.lang.StringBuffer", type) && !TypeUtils.typeEquals("java.lang.StringBuilder", type)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null || !argumentList.isEmpty()) {
                return;
            }
            this.registerNewExpressionError(expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/StringBufferMustHaveInitialCapacityInspection$StringBufferInitialCapacityVisitor", "visitNewExpression"));
        }
    }
}

